/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzn;
import com.google.android.gms.wallet.zzo;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GiftCardWalletObjectCreator")
public final class GiftCardWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GiftCardWalletObject> CREATOR = new zzo();
    @SafeParcelable.Field(id=2)
    CommonWalletObject zzbj = CommonWalletObject.zze().zzf();
    @SafeParcelable.Field(id=3)
    String zzbk;
    @SafeParcelable.Field(id=4)
    String pin;
    @SafeParcelable.Field(id=5)
    String zzbl;
    @SafeParcelable.Field(id=6)
    long zzbm;
    @SafeParcelable.Field(id=7)
    String zzbn;
    @SafeParcelable.Field(id=8)
    long zzbo;
    @SafeParcelable.Field(id=9)
    String zzbp;

    public static Builder newBuilder() {
        return new GiftCardWalletObject().new Builder(null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GiftCardWalletObject giftCardWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)giftCardWalletObject.zzbj, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)giftCardWalletObject.zzbk, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)giftCardWalletObject.pin, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)giftCardWalletObject.zzbl, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)6, (long)giftCardWalletObject.zzbm);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)giftCardWalletObject.zzbn, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)8, (long)giftCardWalletObject.zzbo);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)giftCardWalletObject.zzbp, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    GiftCardWalletObject() {
    }

    @SafeParcelable.Constructor
    GiftCardWalletObject(@SafeParcelable.Param(id=2) CommonWalletObject commonWalletObject, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) String string4, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) String string5) {
        this.zzbj = commonWalletObject;
        this.zzbk = string;
        this.pin = string2;
        this.zzbm = l;
        this.zzbn = string4;
        this.zzbo = l2;
        this.zzbp = string5;
        this.zzbl = string3;
    }

    public final String getId() {
        return this.zzbj.getId();
    }

    public final String getClassId() {
        return this.zzbj.getClassId();
    }

    public final String getTitle() {
        return this.zzbj.getName();
    }

    public final String getIssuerName() {
        return this.zzbj.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbj.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbj.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbj.getBarcodeValue();
    }

    public final String getBarcodeLabel() {
        return this.zzbj.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbj.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbj.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbj.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbj.getLocations();
    }

    public final String getInfoModuleDataHexFontColor() {
        return this.zzbj.getInfoModuleDataHexFontColor();
    }

    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbj.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbj.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbj.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbj.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbj.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbj.getLinksModuleDataUris();
    }

    public final String getCardNumber() {
        return this.zzbk;
    }

    public final String getPin() {
        return this.pin;
    }

    public final long getBalanceMicros() {
        return this.zzbm;
    }

    public final String getBalanceCurrencyCode() {
        return this.zzbn;
    }

    public final long getBalanceUpdateTime() {
        return this.zzbo;
    }

    public final String getEventNumber() {
        return this.zzbp;
    }

    public final String getCardIdentifier() {
        return this.zzbl;
    }

    public final class Builder {
        private CommonWalletObject.zza zzbq = CommonWalletObject.zze();

        private Builder() {
        }

        public final Builder setCardNumber(String string) {
            GiftCardWalletObject.this.zzbk = string;
            return this;
        }

        public final Builder setPin(String string) {
            GiftCardWalletObject.this.pin = string;
            return this;
        }

        public final Builder setBalanceMicros(long l) {
            GiftCardWalletObject.this.zzbm = l;
            return this;
        }

        public final Builder setBalanceCurrencyCode(String string) {
            GiftCardWalletObject.this.zzbn = string;
            return this;
        }

        public final Builder setBalanceUpdateTime(long l) {
            GiftCardWalletObject.this.zzbo = l;
            return this;
        }

        public final Builder setEventNumber(String string) {
            GiftCardWalletObject.this.zzbp = string;
            return this;
        }

        public final Builder setCardIdentifier(String string) {
            GiftCardWalletObject.this.zzbl = string;
            return this;
        }

        public final Builder setId(String string) {
            this.zzbq.zza(string);
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbq.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbq.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbq.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbq.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbq.zzg(string);
            return this;
        }

        public final Builder setBarcodeLabel(String string) {
            this.zzbq.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbq.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbq.zzc(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbq.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbq.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbq.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbq.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbq.zza(latLng);
            return this;
        }

        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbq.zzi(string);
            return this;
        }

        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbq.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbq.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbq.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbq.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbq.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbq.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbq.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbq.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbq.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbq.zzb(uriData);
            return this;
        }

        public final GiftCardWalletObject build() {
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbk) ? 1 : 0) != 0, (Object)"Card number is required.");
            GiftCardWalletObject.this.zzbj = this.zzbq.zzf();
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbj.getName()) ? 1 : 0) != 0, (Object)"Card name is required.");
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbj.getIssuerName()) ? 1 : 0) != 0, (Object)"Card issuer name is required.");
            return GiftCardWalletObject.this;
        }

        /* synthetic */ Builder(zzn zzn2) {
            this();
        }
    }
}

