/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzd;
import com.google.android.gms.wallet.zze;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="CardRequirementsCreator")
public final class CardRequirements
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CardRequirements> CREATOR = new zze();
    @SafeParcelable.Field(id=1)
    ArrayList<Integer> zzai;
    @SafeParcelable.Field(id=2, defaultValue="true")
    boolean zzaj;
    @SafeParcelable.Field(id=3)
    boolean zzak;
    @SafeParcelable.Field(id=4)
    int zzal;

    @SafeParcelable.Constructor
    CardRequirements(@SafeParcelable.Param(id=1) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=4) int n) {
        this.zzai = arrayList;
        this.zzaj = bl;
        this.zzak = bl2;
        this.zzal = n;
    }

    private CardRequirements() {
        this.zzaj = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CardRequirements cardRequirements = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)1, cardRequirements.zzai, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)cardRequirements.zzaj);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)cardRequirements.zzak);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)cardRequirements.zzal);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzai;
    }

    public final boolean allowPrepaidCards() {
        return this.zzaj;
    }

    public final boolean isBillingAddressRequired() {
        return this.zzak;
    }

    public final int getBillingAddressFormat() {
        return this.zzal;
    }

    public static Builder newBuilder() {
        return new CardRequirements().new Builder(null);
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder addAllowedCardNetwork(int n) {
            if (CardRequirements.this.zzai == null) {
                CardRequirements.this.zzai = new ArrayList();
            }
            CardRequirements.this.zzai.add(n);
            return this;
        }

        public final Builder addAllowedCardNetworks(@NonNull Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedCardNetworks can't be null or empty! You must provide a valid value from WalletConstants.CardNetwork.");
            if (CardRequirements.this.zzai == null) {
                CardRequirements.this.zzai = new ArrayList();
            }
            CardRequirements.this.zzai.addAll(collection);
            return this;
        }

        public final Builder setAllowPrepaidCards(boolean bl) {
            CardRequirements.this.zzaj = bl;
            return this;
        }

        public final Builder setBillingAddressRequired(boolean bl) {
            CardRequirements.this.zzak = bl;
            return this;
        }

        public final Builder setBillingAddressFormat(int n) {
            CardRequirements.this.zzal = n;
            return this;
        }

        public final CardRequirements build() {
            Preconditions.checkNotNull(CardRequirements.this.zzai, (Object)"Allowed card networks must be non-empty! You can set it through addAllowedCardNetwork() or addAllowedCardNetworks() in the CardRequirements Builder.");
            return CardRequirements.this;
        }

        /* synthetic */ Builder(zzd zzd2) {
            this();
        }
    }
}

