/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.DeferredLifecycleHelper;
import com.google.android.gms.dynamic.FragmentWrapper;
import com.google.android.gms.dynamic.IFragmentWrapper;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.internal.wallet.zzak;
import com.google.android.gms.internal.wallet.zzl;
import com.google.android.gms.internal.wallet.zzp;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.R;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzfp;
    private boolean zzfc = false;
    private final FragmentWrapper zzfq = FragmentWrapper.wrap((Fragment)this);
    private final zzc zzfr = new zzc(null);
    private zza zzfs = new zza(this);
    private final Fragment zzft = this;
    private WalletFragmentOptions zzfg;
    private WalletFragmentInitParams zzfh;
    private MaskedWalletRequest zzfi;
    private MaskedWallet zzfj;
    private Boolean zzfk;

    public WalletFragment() {
    }

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzft.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzfp != null) {
            this.zzfp.initialize(walletFragmentInitParams);
            this.zzfh = null;
            return;
        }
        if (this.zzfh == null) {
            this.zzfh = walletFragmentInitParams;
            if (this.zzfi != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzfj != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzfp != null) {
            this.zzfp.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzfi = null;
            return;
        }
        this.zzfi = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzfp != null) {
            this.zzfp.updateMaskedWallet(maskedWallet);
            this.zzfj = null;
            return;
        }
        this.zzfj = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzfp != null) {
            this.zzfp.setEnabled(bl);
            this.zzfk = null;
            return;
        }
        this.zzfk = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzfs.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzfp != null) {
            return this.zzfp.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzfg == null) {
            this.zzfg = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzfg);
        this.zzfr.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzfh != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzfh = walletFragmentInitParams;
            }
            if (this.zzfi == null) {
                this.zzfi = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzfj == null) {
                this.zzfj = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzfg = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzfk = bundle.getBoolean("enabled");
            }
        } else if (this.zzft.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzft.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zza((Context)this.zzft.getActivity());
            this.zzfg = walletFragmentOptions;
        }
        this.zzfc = true;
        this.zzfr.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzfr.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzfr.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzfr.onResume();
        FragmentManager fragmentManager = this.zzft.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzft.getActivity(), (int)12451000), (Activity)this.zzft.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzfr.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzfr.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzfr.onSaveInstanceState(bundle);
        if (this.zzfh != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzfh);
            this.zzfh = null;
        }
        if (this.zzfi != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzfi);
            this.zzfi = null;
        }
        if (this.zzfj != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzfj);
            this.zzfj = null;
        }
        if (this.zzfg != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzfg);
            this.zzfg = null;
        }
        if (this.zzfk != null) {
            bundle.putBoolean("enabled", this.zzfk.booleanValue());
            this.zzfk = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzfc = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzfp != null) {
            this.zzfp.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzfg = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzfh = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzfi = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzfj = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzfk = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzp {
        private OnStateChangedListener zzfu;
        private final WalletFragment zzfv;

        zza(WalletFragment walletFragment) {
            this.zzfv = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzfu != null) {
                this.zzfu.onStateChanged(this.zzfv, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzfu = onStateChangedListener;
        }
    }

    private static final class zzb
    implements LifecycleDelegate {
        private final zzl zzfn;

        private zzb(zzl zzl2) {
            this.zzfn = zzl2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzfn.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzfn.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzfn.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzfn.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzfn.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzfn.zza(ObjectWrapper.wrap((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzfn.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)this.zzfn.onCreateView(ObjectWrapper.wrap((Object)layoutInflater), ObjectWrapper.wrap((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzfn.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzfn.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzfn.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzfn.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzfn.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzfn.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzl zzl2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(zzl2);
        }
    }

    private final class zzc
    extends DeferredLifecycleHelper<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected final void createDelegate(OnDelegateCreatedListener<zzb> onDelegateCreatedListener) {
            Activity activity = WalletFragment.this.zzft.getActivity();
            if (WalletFragment.this.zzfp == null && WalletFragment.this.zzfc && activity != null) {
                try {
                    zzl zzl2 = zzak.zza(activity, (IFragmentWrapper)WalletFragment.this.zzfq, WalletFragment.this.zzfg, WalletFragment.this.zzfs);
                    WalletFragment.this.zzfp = new zzb(zzl2, null);
                    WalletFragment.zza(WalletFragment.this, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                onDelegateCreatedListener.onDelegateCreated((LifecycleDelegate)WalletFragment.this.zzfp);
                if (WalletFragment.this.zzfh != null) {
                    WalletFragment.this.zzfp.initialize(WalletFragment.this.zzfh);
                    WalletFragment.zza(WalletFragment.this, null);
                }
                if (WalletFragment.this.zzfi != null) {
                    WalletFragment.this.zzfp.updateMaskedWalletRequest(WalletFragment.this.zzfi);
                    WalletFragment.zza(WalletFragment.this, null);
                }
                if (WalletFragment.this.zzfj != null) {
                    WalletFragment.this.zzfp.updateMaskedWallet(WalletFragment.this.zzfj);
                    WalletFragment.zza(WalletFragment.this, null);
                }
                if (WalletFragment.this.zzfk != null) {
                    WalletFragment.this.zzfp.setEnabled(WalletFragment.this.zzfk);
                    WalletFragment.zza(WalletFragment.this, null);
                }
            }
        }

        protected final void handleGooglePlayUnavailable(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzft.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzfg != null && (walletFragmentStyle = WalletFragment.this.zzfg.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzft.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = WalletFragment.this.zzft.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity, (int)12451000), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(com.google.android.gms.wallet.fragment.zzb zzb2) {
            this();
        }
    }
}

