/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzan;
import com.google.android.gms.wallet.zzao;

@SafeParcelable.Class(creator="TransactionInfoCreator")
public final class TransactionInfo
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<TransactionInfo> CREATOR = new zzao();
    @SafeParcelable.Field(id=1)
    int zzen;
    @SafeParcelable.Field(id=2)
    String zzan;
    @SafeParcelable.Field(id=3)
    String zzao;

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TransactionInfo transactionInfo = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)transactionInfo.zzen);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)transactionInfo.zzan, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)transactionInfo.zzao, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    public TransactionInfo(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2) {
        this.zzen = n;
        this.zzan = string;
        this.zzao = string2;
    }

    private TransactionInfo() {
    }

    public static Builder newBuilder() {
        return new TransactionInfo().new Builder(null);
    }

    public final int getTotalPriceStatus() {
        return this.zzen;
    }

    @Nullable
    public final String getTotalPrice() {
        return this.zzan;
    }

    public final String getCurrencyCode() {
        return this.zzao;
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setTotalPriceStatus(int n) {
            TransactionInfo.this.zzen = n;
            return this;
        }

        public final Builder setTotalPrice(@NonNull String string) {
            TransactionInfo.this.zzan = string;
            return this;
        }

        public final Builder setCurrencyCode(@NonNull String string) {
            TransactionInfo.this.zzao = string;
            return this;
        }

        public final TransactionInfo build() {
            Preconditions.checkNotEmpty((String)TransactionInfo.this.zzao, (Object)"currencyCode must be set!");
            Builder builder = this;
            if (!(builder.TransactionInfo.this.zzen == 1 || builder.TransactionInfo.this.zzen == 2 || builder.TransactionInfo.this.zzen == 3)) {
                throw new IllegalArgumentException("totalPriceStatus must be set to one of WalletConstants.TotalPriceStatus!");
            }
            if (TransactionInfo.this.zzen == 2) {
                Preconditions.checkNotEmpty((String)TransactionInfo.this.zzan, (Object)"An estimated total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_ESTIMATED!");
            }
            if (TransactionInfo.this.zzen == 3) {
                Preconditions.checkNotEmpty((String)TransactionInfo.this.zzan, (Object)"An final total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_FINAL!");
            }
            return TransactionInfo.this;
        }

        /* synthetic */ Builder(zzan zzan2) {
            this();
        }
    }
}

