/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.internal.wallet.zzae;
import com.google.android.gms.internal.wallet.zzaf;
import com.google.android.gms.internal.wallet.zzag;
import com.google.android.gms.internal.wallet.zzah;
import com.google.android.gms.internal.wallet.zzai;
import com.google.android.gms.internal.wallet.zzaj;
import com.google.android.gms.internal.wallet.zzq;
import com.google.android.gms.internal.wallet.zzr;
import com.google.android.gms.internal.wallet.zzu;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;

public final class zzad
extends GmsClient<zzq> {
    private final Context zzgh;
    private final int environment;
    private final String zzci;
    private final int theme;
    private final boolean zzer;

    public zzad(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzgh = context;
        this.environment = n;
        this.zzci = clientSettings.getAccountName();
        this.theme = n2;
        this.zzer = bl;
    }

    public final boolean requiresAccount() {
        return true;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zzb(int n) {
        Bundle bundle = this.zzd();
        zzae zzae2 = new zzae((Activity)this.zzgh, n);
        try {
            ((zzq)this.getService()).zza(bundle, zzae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzaf)zzae2).zza(8, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(String string, String string2, int n) {
        int n2 = n;
        String string3 = string2;
        String string4 = string;
        Activity activity = (Activity)this.zzgh;
        zzad zzad2 = this;
        Bundle bundle = zzad2.zzd();
        zzae zzae2 = new zzae(activity, n2);
        try {
            ((zzq)zzad2.getService()).zza(string4, string3, bundle, zzae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            ((zzaf)zzae2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(MaskedWalletRequest maskedWalletRequest, int n) {
        int n2 = n;
        MaskedWalletRequest maskedWalletRequest2 = maskedWalletRequest;
        Activity activity = (Activity)this.zzgh;
        zzad zzad2 = this;
        Bundle bundle = zzad2.zzd();
        zzae zzae2 = new zzae(activity, n2);
        try {
            ((zzq)zzad2.getService()).zza(maskedWalletRequest2, bundle, (zzu)zzae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            ((zzaf)zzae2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(FullWalletRequest fullWalletRequest, int n) {
        int n2 = n;
        FullWalletRequest fullWalletRequest2 = fullWalletRequest;
        Activity activity = (Activity)this.zzgh;
        zzad zzad2 = this;
        zzae zzae2 = new zzae(activity, n2);
        Bundle bundle = zzad2.zzd();
        try {
            ((zzq)zzad2.getService()).zza(fullWalletRequest2, bundle, (zzu)zzae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            ((zzaf)zzae2).zza(8, (FullWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzae zzae2 = new zzae((Activity)this.zzgh, n);
        Bundle bundle = this.zzd();
        try {
            ((zzq)this.getService()).zza(createWalletObjectsRequest, bundle, (zzu)zzae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzaf)zzae2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzd();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzah zzah2 = new zzah(taskCompletionSource);
        try {
            ((zzq)this.getService()).zza(createWalletObjectsRequest, bundle, (zzu)zzah2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzaf)zzah2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, BaseImplementation.ResultHolder<BooleanResult> resultHolder) {
        zzai zzai2 = new zzai(resultHolder);
        Bundle bundle = this.zzd();
        try {
            ((zzq)this.getService()).zza(isReadyToPayRequest, bundle, (zzu)zzai2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzaf)zzai2).zza(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzd();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzaj zzaj2 = new zzaj(taskCompletionSource);
        try {
            ((zzq)this.getService()).zza(paymentDataRequest, bundle, (zzu)zzaj2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzaf)zzaj2).zza(Status.RESULT_INTERNAL_ERROR, (PaymentData)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzag zzag2 = new zzag(taskCompletionSource);
        try {
            ((zzq)this.getService()).zza(isReadyToPayRequest, this.zzd(), (zzu)zzag2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzaf)zzag2).zza(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzd() {
        boolean bl = this.zzer;
        int n = this.theme;
        String string = this.zzci;
        String string2 = this.zzgh.getPackageName();
        int n2 = this.environment;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    public final int getMinApkVersion() {
        return 12451000;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzq) {
            return (zzq)iInterface;
        }
        return new zzr(iBinder2);
    }
}

