/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.app.Fragment;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableResult;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoResolveHelper {
    private static final long zzb = TimeUnit.MINUTES.toMillis(10L);
    @Hide
    @VisibleForTesting
    static long zza = SystemClock.elapsedRealtime();
    public static final int RESULT_ERROR = 1;

    private AutoResolveHelper() {
    }

    @MainThread
    public static <TResult extends AutoResolvableResult> void resolveTask(@NonNull Task<TResult> task, @NonNull Activity activity, int n) {
        zza<TResult> zza2 = com.google.android.gms.wallet.AutoResolveHelper$zza.zza(task);
        int n2 = zza2.zzb;
        activity.getFragmentManager().beginTransaction().add(com.google.android.gms.wallet.AutoResolveHelper$zzb.zzb(zza2.zzb, n), new StringBuilder(58).append("com.google.android.gms.wallet.AutoResolveHelper").append(n2).toString()).commit();
    }

    @Nullable
    public static Status getStatusFromIntent(@Nullable Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Status)intent.getParcelableExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
    }

    public static void putStatusIntoIntent(@NonNull Intent intent, @Nullable Status status) {
        if (status == null) {
            intent.removeExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
            return;
        }
        intent.putExtra("com.google.android.gms.common.api.AutoResolveHelper.status", (Parcelable)status);
    }

    @Hide
    public static <TResult> void zza(Status status, TResult TResult, TaskCompletionSource<TResult> taskCompletionSource) {
        if (status.isSuccess()) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        taskCompletionSource.setException((Exception)com.google.android.gms.common.internal.zzb.zza((Status)status));
    }

    private static void zzb(Activity activity, int n, Task<? extends AutoResolvableResult> task) {
        if (activity.isFinishing()) {
            if (Log.isLoggable((String)"AutoResolveHelper", (int)3)) {
                Log.d((String)"AutoResolveHelper", (String)"Ignoring task result for, Activity is finishing.");
                return;
            }
        } else {
            int n2;
            if (task.getException() instanceof ResolvableApiException) {
                ResolvableApiException resolvableApiException = (ResolvableApiException)task.getException();
                try {
                    resolvableApiException.startResolutionForResult(activity, n);
                    return;
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                        Log.e((String)"AutoResolveHelper", (String)"Error starting pending intent!", (Throwable)sendIntentException);
                    }
                    return;
                }
            }
            Intent intent = new Intent();
            if (task.isSuccessful()) {
                n2 = -1;
                ((AutoResolvableResult)task.getResult()).putIntoIntent(intent);
            } else if (task.getException() instanceof ApiException) {
                ApiException apiException = (ApiException)task.getException();
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(apiException.getStatusCode(), apiException.getMessage(), null));
            } else {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                    Log.e((String)"AutoResolveHelper", (String)"Unexpected non API exception!", (Throwable)task.getException());
                }
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(8, "Unexpected non API exception when trying to deliver the task result to an activity!"));
            }
            AutoResolveHelper.zzb(activity, n, n2, intent);
        }
    }

    private static void zzb(Activity activity, int n, int n2, Intent intent) {
        block5: {
            PendingIntent pendingIntent = activity.createPendingResult(n, intent, 0x40000000);
            if (pendingIntent == null) {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                    Log.w((String)"AutoResolveHelper", (String)"Null pending result returned when trying to deliver task result!");
                    return;
                }
            } else {
                try {
                    pendingIntent.send(n2);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) break block5;
                    Log.e((String)"AutoResolveHelper", (String)"Exception sending pending result", (Throwable)canceledException);
                }
            }
        }
    }

    @Hide
    @VisibleForTesting
    static final class zza<TResult extends AutoResolvableResult>
    implements OnCompleteListener<TResult>,
    Runnable {
        @VisibleForTesting
        private static Handler zzc = new Handler(Looper.getMainLooper());
        @VisibleForTesting
        static final SparseArray<zza<?>> zza = new SparseArray(2);
        private static final AtomicInteger zzd = new AtomicInteger();
        int zzb;
        private zzb zze;
        private Task<TResult> zzf;

        zza() {
        }

        public static <TResult extends AutoResolvableResult> zza<TResult> zza(Task<TResult> task) {
            zza<TResult> zza2 = new zza<TResult>();
            new zza<TResult>().zzb = zzd.incrementAndGet();
            zza.put(zza2.zzb, zza2);
            zzc.postDelayed(zza2, zzb);
            task.addOnCompleteListener(zza2);
            return zza2;
        }

        public final void zza(zzb zzb2) {
            this.zze = zzb2;
            this.zza();
        }

        public final void zzb(zzb zzb2) {
            if (this.zze == zzb2) {
                this.zze = null;
            }
        }

        public final void onComplete(@NonNull Task<TResult> task) {
            this.zzf = task;
            this.zza();
        }

        @Override
        public final void run() {
            zza.delete(this.zzb);
        }

        private final void zza() {
            if (this.zzf != null && this.zze != null) {
                zza.delete(this.zzb);
                zzc.removeCallbacks((Runnable)this);
                this.zze.zza((Task<? extends AutoResolvableResult>)this.zzf);
            }
        }
    }

    @Hide
    public static final class zzb
    extends Fragment {
        private static String zza = "resolveCallId";
        private static String zzb = "requestCode";
        private static String zzc = "initializationElapsedRealtime";
        private static String zzd = "delivered";
        private int zze;
        private zza<?> zzf;
        @VisibleForTesting
        private boolean zzg;

        private static Fragment zzb(int n, int n2) {
            Bundle bundle = new Bundle();
            bundle.putInt(zza, n);
            bundle.putInt(zzb, n2);
            bundle.putLong(zzc, zza);
            zzb zzb2 = new zzb();
            zzb2.setArguments(bundle);
            return zzb2;
        }

        public final void onCreate(@Nullable Bundle bundle) {
            super.onCreate(bundle);
            this.zze = this.getArguments().getInt(zzb);
            if (zza != this.getArguments().getLong(zzc)) {
                this.zzf = null;
            } else {
                int n = this.getArguments().getInt(zza);
                this.zzf = (zza)com.google.android.gms.wallet.AutoResolveHelper$zza.zza.get(n);
            }
            this.zzg = bundle != null && bundle.getBoolean(zzd);
        }

        public final void onResume() {
            super.onResume();
            zzb zzb2 = this;
            if (zzb2.zzf != null) {
                zzb2.zzf.zza(zzb2);
                return;
            }
            if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                Log.w((String)"AutoResolveHelper", (String)"Sending canceled result for garbage collected task!");
            }
            zzb2.zza(null);
        }

        public final void onSaveInstanceState(Bundle bundle) {
            super.onSaveInstanceState(bundle);
            bundle.putBoolean(zzd, this.zzg);
            this.zza();
        }

        public final void onPause() {
            super.onPause();
            this.zza();
        }

        private final void zza() {
            if (this.zzf != null) {
                this.zzf.zzb(this);
            }
        }

        private final void zza(@Nullable Task<? extends AutoResolvableResult> task) {
            if (!this.zzg) {
                this.zzg = true;
                Activity activity = this.getActivity();
                activity.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
                if (task != null) {
                    AutoResolveHelper.zzb(activity, this.zze, (Task<? extends AutoResolvableResult>)task);
                    return;
                }
                AutoResolveHelper.zzb(activity, this.zze, 0, new Intent());
            }
        }
    }
}

