/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzj;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.internal.zzdkw;
import com.google.android.gms.internal.zzdla;
import com.google.android.gms.internal.zzdlv;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzley;
    private boolean mCreated = false;
    private final zzj zzlez = zzj.zza((Fragment)this);
    private final zzc zzlfa = new zzc(this, null);
    private zza zzlfb = new zza(this);
    private final Fragment zzgwm = this;
    private WalletFragmentOptions zzlep;
    private WalletFragmentInitParams zzleq;
    private MaskedWalletRequest zzler;
    private MaskedWallet zzles;
    private Boolean zzlet;

    public WalletFragment() {
    }

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzgwm.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzley != null) {
            this.zzley.initialize(walletFragmentInitParams);
            this.zzleq = null;
            return;
        }
        if (this.zzleq == null) {
            this.zzleq = walletFragmentInitParams;
            if (this.zzler != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzles != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzley != null) {
            this.zzley.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzler = null;
            return;
        }
        this.zzler = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzley != null) {
            this.zzley.updateMaskedWallet(maskedWallet);
            this.zzles = null;
            return;
        }
        this.zzles = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzley != null) {
            this.zzley.setEnabled(bl);
            this.zzlet = null;
            return;
        }
        this.zzlet = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzlfb.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzley != null) {
            return this.zzley.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzlep == null) {
            this.zzlep = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzlep);
        this.zzlfa.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzleq != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzleq = walletFragmentInitParams;
            }
            if (this.zzler == null) {
                this.zzler = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzles == null) {
                this.zzles = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzlep = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzlet = bundle.getBoolean("enabled");
            }
        } else if (this.zzgwm.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzgwm.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzeo((Context)this.zzgwm.getActivity());
            this.zzlep = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzlfa.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzlfa.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzlfa.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzlfa.onResume();
        FragmentManager fragmentManager = this.zzgwm.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzgwm.getActivity()), (Activity)this.zzgwm.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzlfa.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzlfa.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzlfa.onSaveInstanceState(bundle);
        if (this.zzleq != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzleq);
            this.zzleq = null;
        }
        if (this.zzler != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzler);
            this.zzler = null;
        }
        if (this.zzles != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzles);
            this.zzles = null;
        }
        if (this.zzlep != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzlep);
            this.zzlep = null;
        }
        if (this.zzlet != null) {
            bundle.putBoolean("enabled", this.zzlet.booleanValue());
            this.zzlet = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzley != null) {
            this.zzley.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzlep = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzleq = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzler = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzles = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzlet = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzdla {
        private OnStateChangedListener zzlfc;
        private final WalletFragment zzlfd;

        zza(WalletFragment walletFragment) {
            this.zzlfd = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzlfc != null) {
                this.zzlfc.onStateChanged(this.zzlfd, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzlfc = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzdkw zzlew;

        private zzb(zzdkw zzdkw2) {
            this.zzlew = zzdkw2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzlew.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzlew.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzlew.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzlew.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzlew.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzlew.zza(zzn.zzz((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzlew.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzx((IObjectWrapper)this.zzlew.onCreateView(zzn.zzz((Object)layoutInflater), zzn.zzz((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzlew.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzlew.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzlew.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzlew.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzlew.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzlew.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzdkw zzdkw2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(zzdkw2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ WalletFragment zzlfe;

        private zzc(WalletFragment walletFragment) {
            this.zzlfe = walletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            Activity activity = this.zzlfe.zzgwm.getActivity();
            if (this.zzlfe.zzley == null && this.zzlfe.mCreated && activity != null) {
                try {
                    zzdkw zzdkw2 = zzdlv.zza(activity, (zzk)this.zzlfe.zzlez, this.zzlfe.zzlep, this.zzlfe.zzlfb);
                    this.zzlfe.zzley = new zzb(zzdkw2, null);
                    WalletFragment.zza(this.zzlfe, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzlfe.zzley);
                if (this.zzlfe.zzleq != null) {
                    this.zzlfe.zzley.initialize(this.zzlfe.zzleq);
                    WalletFragment.zza(this.zzlfe, null);
                }
                if (this.zzlfe.zzler != null) {
                    this.zzlfe.zzley.updateMaskedWalletRequest(this.zzlfe.zzler);
                    WalletFragment.zza(this.zzlfe, null);
                }
                if (this.zzlfe.zzles != null) {
                    this.zzlfe.zzley.updateMaskedWallet(this.zzlfe.zzles);
                    WalletFragment.zza(this.zzlfe, null);
                }
                if (this.zzlfe.zzlet != null) {
                    this.zzlfe.zzley.setEnabled(this.zzlfe.zzlet);
                    WalletFragment.zza(this.zzlfe, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzlfe.zzgwm.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzlfe.zzlep != null && (walletFragmentStyle = this.zzlfe.zzlep.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzlfe.zzgwm.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = this.zzlfe.zzgwm.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(WalletFragment walletFragment, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(walletFragment);
        }
    }
}

