/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzdlb;
import com.google.android.gms.internal.zzdlc;
import com.google.android.gms.internal.zzdlf;
import com.google.android.gms.internal.zzdlp;
import com.google.android.gms.internal.zzdlq;
import com.google.android.gms.internal.zzdlr;
import com.google.android.gms.internal.zzdls;
import com.google.android.gms.internal.zzdlt;
import com.google.android.gms.internal.zzdlu;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;

public final class zzdlo
extends zzab<zzdlb> {
    private final Context mContext;
    private final int zzlea;
    private final String zzebv;
    private final int mTheme;
    private final boolean zzleb;

    public zzdlo(Context context, Looper looper, zzr zzr2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.mContext = context;
        this.zzlea = n;
        this.zzebv = zzr2.getAccountName();
        this.mTheme = n2;
        this.zzleb = bl;
    }

    public final boolean zzako() {
        return true;
    }

    protected final String zzhi() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String zzhj() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zzfb(int n) {
        Bundle bundle = this.zzbka();
        zzdlp zzdlp2 = new zzdlp((Activity)this.mContext, n);
        try {
            ((zzdlb)this.zzakn()).zza(bundle, zzdlp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzdlq)zzdlp2).zza(8, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zzc(String string, String string2, int n) {
        int n2 = n;
        String string3 = string2;
        String string4 = string;
        Activity activity = (Activity)this.mContext;
        zzdlo zzdlo2 = this;
        Bundle bundle = zzdlo2.zzbka();
        zzdlp zzdlp2 = new zzdlp(activity, n2);
        try {
            ((zzdlb)zzdlo2.zzakn()).zza(string4, string3, bundle, zzdlp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            ((zzdlq)zzdlp2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(MaskedWalletRequest maskedWalletRequest, int n) {
        int n2 = n;
        MaskedWalletRequest maskedWalletRequest2 = maskedWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdlo zzdlo2 = this;
        Bundle bundle = zzdlo2.zzbka();
        zzdlp zzdlp2 = new zzdlp(activity, n2);
        try {
            ((zzdlb)zzdlo2.zzakn()).zza(maskedWalletRequest2, bundle, (zzdlf)zzdlp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            ((zzdlq)zzdlp2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(FullWalletRequest fullWalletRequest, int n) {
        int n2 = n;
        FullWalletRequest fullWalletRequest2 = fullWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdlo zzdlo2 = this;
        zzdlp zzdlp2 = new zzdlp(activity, n2);
        Bundle bundle = zzdlo2.zzbka();
        try {
            ((zzdlb)zzdlo2.zzakn()).zza(fullWalletRequest2, bundle, (zzdlf)zzdlp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            ((zzdlq)zzdlp2).zza(8, (FullWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzdlp zzdlp2 = new zzdlp((Activity)this.mContext, n);
        Bundle bundle = this.zzbka();
        try {
            ((zzdlb)this.zzakn()).zza(createWalletObjectsRequest, bundle, (zzdlf)zzdlp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzdlq)zzdlp2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzbka();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzdls zzdls2 = new zzdls(taskCompletionSource);
        try {
            ((zzdlb)this.zzakn()).zza(createWalletObjectsRequest, bundle, (zzdlf)zzdls2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzdlq)zzdls2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, zzn<BooleanResult> zzn2) {
        zzdlt zzdlt2 = new zzdlt(zzn2);
        Bundle bundle = this.zzbka();
        try {
            ((zzdlb)this.zzakn()).zza(isReadyToPayRequest, bundle, (zzdlf)zzdlt2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzdlq)zzdlt2).zza(Status.zzfnk, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzbka();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzdlu zzdlu2 = new zzdlu(taskCompletionSource);
        try {
            ((zzdlb)this.zzakn()).zza(paymentDataRequest, bundle, (zzdlf)zzdlu2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzdlq)zzdlu2).zza(Status.zzfnk, null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzdlr zzdlr2 = new zzdlr(taskCompletionSource);
        try {
            ((zzdlb)this.zzakn()).zza(isReadyToPayRequest, this.zzbka(), (zzdlf)zzdlr2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzdlq)zzdlr2).zza(Status.zzfnk, false, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzbka() {
        boolean bl = this.zzleb;
        int n = this.mTheme;
        String string = this.zzebv;
        String string2 = this.mContext.getPackageName();
        int n2 = this.zzlea;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzdlb) {
            return (zzdlb)iInterface;
        }
        return new zzdlc(iBinder2);
    }
}

