/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object aNc = new Object();
    private Camera aNd;
    private int aNe = 0;
    private int zzbzf;
    private Size aNf;
    private float aNg = 30.0f;
    private int aNh = 1024;
    private int aNi = 768;
    private boolean aNj = false;
    private SurfaceView aNk;
    private SurfaceTexture aNl;
    private boolean aNm;
    private Thread aNn;
    private zzb aNo;
    private Map<byte[], ByteBuffer> aNp = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.aNc;
        synchronized (object) {
            this.stop();
            this.aNo.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.aNc;
        synchronized (object) {
            if (this.aNd != null) {
                return this;
            }
            this.aNd = this.zzclk();
            if (Build.VERSION.SDK_INT >= 11) {
                this.aNl = new SurfaceTexture(100);
                this.aNd.setPreviewTexture(this.aNl);
                this.aNm = true;
            } else {
                this.aNk = new SurfaceView(this.mContext);
                this.aNd.setPreviewDisplay(this.aNk.getHolder());
                this.aNm = false;
            }
            this.aNd.startPreview();
            this.aNn = new Thread(this.aNo);
            this.aNo.setActive(true);
            this.aNn.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.aNc;
        synchronized (object) {
            if (this.aNd != null) {
                return this;
            }
            this.aNd = this.zzclk();
            this.aNd.setPreviewDisplay(surfaceHolder);
            this.aNd.startPreview();
            this.aNn = new Thread(this.aNo);
            this.aNo.setActive(true);
            this.aNn.start();
            this.aNm = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.aNc;
        synchronized (object) {
            this.aNo.setActive(false);
            if (this.aNn != null) {
                try {
                    this.aNn.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.aNn = null;
            }
            if (this.aNd != null) {
                this.aNd.stopPreview();
                this.aNd.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.aNm) {
                        this.aNd.setPreviewTexture(null);
                    } else {
                        this.aNd.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                this.aNd.release();
                this.aNd = null;
            }
            this.aNp.clear();
        }
    }

    public Size getPreviewSize() {
        return this.aNf;
    }

    public int getCameraFacing() {
        return this.aNe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback) {
        Object object = this.aNc;
        synchronized (object) {
            if (this.aNd != null) {
                zzd zzd2 = new zzd();
                zzd2.aNy = shutterCallback;
                zzc zzc2 = new zzc();
                zzc2.aNx = pictureCallback;
                this.aNd.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private Camera zzclk() {
        int n = CameraSource.zzaap(this.aNe);
        if (n == -1) {
            throw new RuntimeException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n);
        zze zze2 = CameraSource.zza(camera, this.aNh, this.aNi);
        if (zze2 == null) {
            throw new RuntimeException("Could not find suitable preview size.");
        }
        Size size = zze2.zzclm();
        this.aNf = zze2.zzcll();
        int[] nArray = CameraSource.zza(camera, this.aNg);
        if (nArray == null) {
            throw new RuntimeException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        if (size != null) {
            parameters.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters.setPreviewSize(this.aNf.getWidth(), this.aNf.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        this.zza(camera, parameters, n);
        if (this.aNj) {
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza());
        camera.addCallbackBuffer(this.zza(this.aNf));
        camera.addCallbackBuffer(this.zza(this.aNf));
        camera.addCallbackBuffer(this.zza(this.aNf));
        camera.addCallbackBuffer(this.zza(this.aNf));
        return camera;
    }

    private static int zzaap(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != n) continue;
            return i;
        }
        return -1;
    }

    static zze zza(Camera camera, int n, int n2) {
        List<zze> list = CameraSource.zza(camera);
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        for (zze zze3 : list) {
            Size size = zze3.zzcll();
            int n4 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n4 >= n3) continue;
            zze2 = zze3;
            n3 = n4;
        }
        return zze2;
    }

    static List<zze> zza(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        return arrayList;
    }

    @SuppressLint(value={"InlinedApi"})
    static int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        List list = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] nArray2 : list) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    private void zza(Camera camera, Camera.Parameters parameters, int n) {
        int n2;
        int n3;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n4 = 0;
        int n5 = windowManager.getDefaultDisplay().getRotation();
        switch (n5) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n5).toString());
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n3) % 360;
        } else {
            n2 = n3 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        this.zzbzf = n3 / 90;
        camera.setDisplayOrientation(n2);
        parameters.setRotation(n3);
    }

    @SuppressLint(value={"InlinedApi"})
    private byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        long l = size.getHeight() * size.getWidth() * n;
        int n2 = (int)Math.ceil((double)l / 8.0) + 1;
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.aNp.put(byArray, byteBuffer);
        return byArray;
    }

    private class zzb
    implements Runnable {
        private Detector<?> aNq;
        private long eg = SystemClock.elapsedRealtime();
        private final Object zzako = new Object();
        private boolean aNt = true;
        private long aNu;
        private int aNv = 0;
        private ByteBuffer aNw;

        zzb(Detector<?> detector) {
            this.aNq = detector;
        }

        @SuppressLint(value={"Assert"})
        void release() {
            assert (CameraSource.this.aNn.getState() == Thread.State.TERMINATED);
            this.aNq.release();
            this.aNq = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean bl) {
            Object object = this.zzako;
            synchronized (object) {
                this.aNt = bl;
                this.zzako.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void zza(byte[] byArray, Camera camera) {
            Object object = this.zzako;
            synchronized (object) {
                if (this.aNw != null) {
                    camera.addCallbackBuffer(this.aNw.array());
                    this.aNw = null;
                }
                if (!CameraSource.this.aNp.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.aNu = SystemClock.elapsedRealtime() - this.eg;
                ++this.aNv;
                this.aNw = (ByteBuffer)CameraSource.this.aNp.get(byArray);
                this.zzako.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.zzako;
                synchronized (object) {
                    while (this.aNt && this.aNw == null) {
                        try {
                            this.zzako.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.aNt) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.aNw, CameraSource.this.aNf.getWidth(), CameraSource.this.aNf.getHeight(), 17).setId(this.aNv).setTimestampMillis(this.aNu).setRotation(CameraSource.this.zzbzf).build();
                    byteBuffer = this.aNw;
                    this.aNw = null;
                }
                try {
                    this.aNq.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    CameraSource.this.aNd.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    private class zza
    implements Camera.PreviewCallback {
        private zza() {
        }

        public void onPreviewFrame(byte[] byArray, Camera camera) {
            CameraSource.this.aNo.zza(byArray, camera);
        }
    }

    static class zze {
        private Size aNz;
        private Size aNA;

        public zze(Camera.Size size, Camera.Size size2) {
            this.aNz = new Size(size.width, size.height);
            if (size2 != null) {
                this.aNA = new Size(size2.width, size2.height);
            }
        }

        public Size zzcll() {
            return this.aNz;
        }

        public Size zzclm() {
            return this.aNA;
        }
    }

    private class zzc
    implements Camera.PictureCallback {
        private PictureCallback aNx;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.aNx != null) {
                this.aNx.onPictureTaken(byArray);
            }
            Object object = CameraSource.this.aNc;
            synchronized (object) {
                if (CameraSource.this.aNd != null) {
                    CameraSource.this.aNd.startPreview();
                }
            }
        }
    }

    private class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback aNy;

        private zzd() {
        }

        public void onShutter() {
            if (this.aNy != null) {
                this.aNy.onShutter();
            }
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> aNq;
        private CameraSource aNr = new CameraSource();

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.aNq = detector;
            this.aNr.mContext = context;
        }

        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.aNr.aNg = f;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            int n3 = 1000000;
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.aNr.aNh = n;
            this.aNr.aNi = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.aNr.aNe = n;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean bl) {
            this.aNr.aNj = bl;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.aNr;
            cameraSource.getClass();
            this.aNr.aNo = cameraSource.new zzb(this.aNq);
            return this.aNr;
        }
    }
}

