/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> aEu;
    private SparseArray<zza> aEv = new SparseArray();
    private int aEi = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.aEv.size(); ++i) {
            Tracker tracker = ((zza)this.aEv.valueAt(i)).aEh;
            tracker.onDone();
        }
        this.aEv.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.aEv.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.aEh = this.aEu.create(object);
            zza2.aEh.onNewItem(n, object);
            this.aEv.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.aEv.size(); ++i) {
            int n = this.aEv.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.aEv.valueAt(i);
            zza2.aEl++;
            if (zza2.aEl >= this.aEi) {
                zza2.aEh.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.aEh.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.aEv.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.aEv.get(n);
            zza2.aEl = 0;
            zza2.aEh.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> aEh;
        private int aEl = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> aEw = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.aEw).aEu = factory;
        }

        public Builder<T> setMaxGapFrames(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
            }
            ((MultiProcessor)this.aEw).aEi = n;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.aEw;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

