/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object aEc = new Object();
    private Processor<T> aEd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.aEc;
        synchronized (object) {
            if (this.aEd != null) {
                this.aEd.release();
                this.aEd = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.aEc;
        synchronized (object) {
            if (this.aEd == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzchu();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.aEd.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.aEd = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> aEe;
        private Frame.Metadata aEf;
        private boolean aEg;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.aEe = sparseArray;
            this.aEf = metadata;
            this.aEg = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.aEe;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.aEf;
        }

        public boolean detectorIsOperational() {
            return this.aEg;
        }
    }
}

