/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzbxq = new Metadata();
    private ByteBuffer zzbxr = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzbxq;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzMU();
        }
        return this.zzbxr;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzMU() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zzpi;
        private int zzpj;
        private int mId;
        private long zzaQl;
        private int zzGA;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzpi = metadata.getWidth();
            this.zzpj = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzaQl = metadata.getTimestampMillis();
            this.zzGA = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzpi;
        }

        public int getHeight() {
            return this.zzpj;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzaQl;
        }

        public int getRotation() {
            return this.zzGA;
        }

        public int getFormat() {
            return this.format;
        }

        public void zzMV() {
            if (this.zzGA % 2 != 0) {
                int n = this.zzpi;
                this.zzpi = this.zzpj;
                this.zzpj = n;
            }
            this.zzGA = 0;
        }
    }

    public static class Builder {
        private Frame zzbxs = new Frame();

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zzbxs.mBitmap = bitmap;
            Metadata metadata = this.zzbxs.getMetadata();
            metadata.zzpi = n;
            metadata.zzpj = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zzbxs.zzbxr = byteBuffer;
            Metadata metadata = this.zzbxs.getMetadata();
            metadata.zzpi = n;
            metadata.zzpj = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zzbxs.getMetadata().mId = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zzbxs.getMetadata().zzaQl = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zzbxs.getMetadata().zzGA = n;
            return this;
        }

        public Frame build() {
            if (this.zzbxs.zzbxr == null && this.zzbxs.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzbxs;
        }
    }
}

