/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text.internal.client;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import com.google.android.gms.vision.text.internal.client.LineBoxParcel;
import com.google.android.gms.vision.text.internal.client.TextRecognizerOptions;
import com.google.android.gms.vision.text.internal.client.zzb;
import com.google.android.gms.vision.text.internal.client.zzc;

public class zze {
    private final Context mContext;
    private final TextRecognizerOptions zzbyu;
    private final Object zzpp = new Object();
    private zzb zzbyG = null;
    private boolean zzbxG = false;

    public zze(Context context, TextRecognizerOptions textRecognizerOptions) {
        this.mContext = context;
        this.zzbyu = textRecognizerOptions;
        this.zzNd();
    }

    public LineBoxParcel[] zzc(Bitmap bitmap, FrameMetadataParcel frameMetadataParcel) {
        if (!this.isOperational()) {
            return new LineBoxParcel[0];
        }
        try {
            zzd zzd2 = com.google.android.gms.dynamic.zze.zzD((Object)bitmap);
            return this.zzNd().zzd(zzd2, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NativeTextRecognizerHandle", (String)"Error calling native text recognizer", (Throwable)remoteException);
            return new LineBoxParcel[0];
        }
    }

    public boolean isOperational() {
        return this.zzNd() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzb zzNd() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzbyG != null) {
                return this.zzbyG;
            }
            try {
                zzqi zzqi2 = zzqi.zza((Context)this.mContext, (zzqi.zzb)zzqi.zzaCr, (String)"com.google.android.gms.vision.dynamite");
                zzc zzc2 = zzc.zza.zzer(zzqi2.zzdM("com.google.android.gms.vision.text.ChimeraNativeTextRecognizerCreator"));
                zzd zzd2 = com.google.android.gms.dynamic.zze.zzD((Object)this.mContext);
                this.zzbyG = zzc2.zza(zzd2, this.zzbyu);
            }
            catch (RemoteException | zzqi.zza throwable) {
                Log.e((String)"NativeTextRecognizerHandle", (String)"Error creating remote native text detector", (Throwable)throwable);
            }
            if (!this.zzbxG && this.zzbyG == null) {
                Log.w((String)"NativeTextRecognizerHandle", (String)"Native text detector not yet available.  Reverting to no-op detection.");
                this.zzbxG = true;
            } else if (this.zzbxG && this.zzbyG != null) {
                Log.w((String)"NativeTextRecognizerHandle", (String)"Native text detector is now available.");
            }
            return this.zzbyG;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzNc() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzbyG == null) {
                return;
            }
            try {
                this.zzbyG.zzNc();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"NativeTextRecognizerHandle", (String)"Could not finalize native recognizer", (Throwable)remoteException);
            }
        }
    }
}

