/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode.internal.client;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.internal.client.BarcodeDetectorOptions;
import com.google.android.gms.vision.barcode.internal.client.zzb;
import com.google.android.gms.vision.barcode.internal.client.zzc;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzd {
    private final Context mContext;
    private final BarcodeDetectorOptions zzbxD;
    private final Object zzpp = new Object();
    private zzb zzbxF = null;
    private boolean zzbxG = false;

    public zzd(Context context, BarcodeDetectorOptions barcodeDetectorOptions) {
        this.mContext = context;
        this.zzbxD = barcodeDetectorOptions;
        this.zzMX();
    }

    public Barcode[] zza(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        if (!this.isOperational()) {
            return new Barcode[0];
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2 = zze.zzD((Object)byteBuffer);
            return this.zzMX().zza(zzd2, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    public Barcode[] zza(Bitmap bitmap, FrameMetadataParcel frameMetadataParcel) {
        if (!this.isOperational()) {
            return new Barcode[0];
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2 = zze.zzD((Object)bitmap);
            return this.zzMX().zzb(zzd2, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    public boolean isOperational() {
        return this.zzMX() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzb zzMX() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzbxF != null) {
                return this.zzbxF;
            }
            try {
                zzqi zzqi2 = zzqi.zza((Context)this.mContext, (zzqi.zzb)zzqi.zzaCr, (String)"com.google.android.gms.vision.dynamite");
                zzc zzc2 = zzc.zza.zzen(zzqi2.zzdM("com.google.android.gms.vision.barcode.ChimeraNativeBarcodeDetectorCreator"));
                com.google.android.gms.dynamic.zzd zzd2 = zze.zzD((Object)this.mContext);
                this.zzbxF = zzc2.zza(zzd2, this.zzbxD);
            }
            catch (RemoteException | zzqi.zza throwable) {
                Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error creating remote native barcode detector", (Throwable)throwable);
            }
            if (!this.zzbxG && this.zzbxF == null) {
                Log.w((String)"NativeBarcodeDetectorHandle", (String)"Native barcode detector not yet available.  Reverting to no-op detection.");
                this.zzbxG = true;
            } else if (this.zzbxG && this.zzbxF != null) {
                Log.w((String)"NativeBarcodeDetectorHandle", (String)"Native barcode detector is now available.");
            }
            return this.zzbxF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzMW() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzbxF == null) {
                return;
            }
            try {
                this.zzbxF.zzMW();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"NativeBarcodeDetectorHandle", (String)"Could not finalize native barcode detector", (Throwable)remoteException);
            }
        }
    }
}

