/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzc;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzg {
    private final Context mContext;
    private final FaceSettingsParcel zzbcc;
    private final Object zzpd = new Object();
    private zzc zzbcd = null;
    private boolean zzbce = false;

    public zzg(Context context, FaceSettingsParcel faceSettingsParcel) {
        this.mContext = context;
        this.zzbcc = faceSettingsParcel;
        this.zzEB();
    }

    public Face[] zzb(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        zzc zzc2 = this.zzEB();
        if (zzc2 == null) {
            return new Face[0];
        }
        try {
            faceArray = zze.zzy((Object)byteBuffer);
            faceParcelArray = zzc2.zzc((zzd)faceArray, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = this.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public boolean zzjW(int n) {
        zzc zzc2 = this.zzEB();
        if (zzc2 == null) {
            return false;
        }
        try {
            return zzc2.zzjW(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzEA() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzbcd == null) {
                return;
            }
            try {
                this.zzbcd.zzEA();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FaceDetectorHandle", (String)"Could not finalize native face detector", (Throwable)remoteException);
            }
        }
    }

    public boolean isOperational() {
        return this.zzEB() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zzEB() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzbcd != null) {
                return this.zzbcd;
            }
            this.zzbcd = zzf.zza(this.mContext, this.zzbcc);
            if (!this.zzbce && this.zzbcd == null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector not yet available.  Reverting to no-op detection.");
                this.zzbce = true;
            } else if (this.zzbce && this.zzbcd != null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector is now available.");
            }
            return this.zzbcd;
        }
    }

    private Face zza(FaceParcel faceParcel) {
        return new Face(faceParcel.id, new PointF(faceParcel.centerX, faceParcel.centerY), faceParcel.width, faceParcel.height, faceParcel.zzbbR, faceParcel.zzbbS, this.zzb(faceParcel), faceParcel.zzbbU, faceParcel.zzbbV, faceParcel.zzbbW);
    }

    private Landmark[] zzb(FaceParcel faceParcel) {
        Landmark[] landmarkArray;
        LandmarkParcel[] landmarkParcelArray = faceParcel.zzbbT;
        if (landmarkParcelArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[landmarkParcelArray.length];
            for (int i = 0; i < landmarkParcelArray.length; ++i) {
                landmarkArray[i] = this.zza(landmarkParcelArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(LandmarkParcel landmarkParcel) {
        return new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
    }
}

