/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> zzbbs;
    private SparseArray<zza> zzbbt = new SparseArray();
    private int zzbbu = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.zzbbt.size(); ++i) {
            Tracker tracker = ((zza)this.zzbbt.valueAt(i)).zzbbh;
            tracker.onDone();
        }
        this.zzbbt.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.zzbbt.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.zzbbh = this.zzbbs.create(object);
            zza2.zzbbh.onNewItem(n, object);
            this.zzbbt.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.zzbbt.size(); ++i) {
            int n = this.zzbbt.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.zzbbt.valueAt(i);
            zza2.zzbbw++;
            if (zza2.zzbbw >= this.zzbbu) {
                zza2.zzbbh.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.zzbbh.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.zzbbt.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.zzbbt.get(n);
            zza2.zzbbw = 0;
            zza2.zzbbh.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> zzbbh;
        private int zzbbw = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> zzbbv = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.zzbbv).zzbbs = factory;
        }

        public Builder<T> setMaxGapFrames(int maxGapFrames) {
            if (maxGapFrames < 0) {
                throw new IllegalArgumentException("Invalid max gap: " + maxGapFrames);
            }
            ((MultiProcessor)this.zzbbv).zzbbu = maxGapFrames;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.zzbbv;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

