/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    public static final int CAMERA_FACING_BACK = 0;
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object zzbaE = new Object();
    private Camera zzbaF;
    private int zzbaG = 0;
    private int zzAF;
    private Size zzbaH;
    private float zzbaI = 30.0f;
    private int zzbaJ = 1024;
    private int zzbaK = 768;
    private SurfaceView zzbaL;
    private SurfaceTexture zzbaM;
    private boolean zzbaN;
    private Thread zzbaO;
    private zzb zzbaP;
    private Map<byte[], ByteBuffer> zzbaQ = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbaE;
        synchronized (object) {
            this.stop();
            this.zzbaP.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraSource start() throws IOException {
        Object object = this.zzbaE;
        synchronized (object) {
            if (this.zzbaF != null) {
                return this;
            }
            this.zzbaF = this.zzEu();
            if (Build.VERSION.SDK_INT >= 11) {
                this.zzbaM = new SurfaceTexture(100);
                this.zzbaF.setPreviewTexture(this.zzbaM);
                this.zzbaN = true;
            } else {
                this.zzbaL = new SurfaceView(this.mContext);
                this.zzbaF.setPreviewDisplay(this.zzbaL.getHolder());
                this.zzbaN = false;
            }
            this.zzbaF.startPreview();
            this.zzbaO = new Thread(this.zzbaP);
            this.zzbaP.setActive(true);
            this.zzbaO.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzbaE;
        synchronized (object) {
            if (this.zzbaF != null) {
                return this;
            }
            this.zzbaF = this.zzEu();
            this.zzbaF.setPreviewDisplay(surfaceHolder);
            this.zzbaF.startPreview();
            this.zzbaO = new Thread(this.zzbaP);
            this.zzbaP.setActive(true);
            this.zzbaO.start();
            this.zzbaN = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzbaE;
        synchronized (object) {
            this.zzbaP.setActive(false);
            if (this.zzbaO != null) {
                try {
                    this.zzbaO.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzbaO = null;
            }
            if (this.zzbaF != null) {
                this.zzbaF.stopPreview();
                this.zzbaF.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzbaN) {
                        this.zzbaF.setPreviewTexture(null);
                    } else {
                        this.zzbaF.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"CameraSource", (String)("Failed to clear camera preview: " + exception));
                }
                this.zzbaF.release();
                this.zzbaF = null;
            }
        }
    }

    public Size getPreviewSize() {
        return this.zzbaH;
    }

    public int getCameraFacing() {
        return this.zzbaG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutter, PictureCallback jpeg) {
        Object object = this.zzbaE;
        synchronized (object) {
            if (this.zzbaF != null) {
                zzd zzd2 = new zzd();
                zzd2.zzbaZ = shutter;
                zzc zzc2 = new zzc();
                zzc2.zzbaY = jpeg;
                this.zzbaF.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
        }
    }

    private CameraSource() {
    }

    private Camera zzEu() {
        int n = CameraSource.zzjD(this.zzbaG);
        if (n == -1) {
            throw new RuntimeException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n);
        zze zze2 = CameraSource.zza(camera, this.zzbaJ, this.zzbaK);
        if (zze2 == null) {
            throw new RuntimeException("Could not find suitable preview size.");
        }
        Size size = zze2.zzEw();
        this.zzbaH = zze2.zzEv();
        int[] nArray = this.zza(camera, this.zzbaI);
        if (nArray == null) {
            throw new RuntimeException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPictureSize(size.getWidth(), size.getHeight());
        parameters.setPreviewSize(this.zzbaH.getWidth(), this.zzbaH.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        this.zza(camera, parameters, n);
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza());
        camera.addCallbackBuffer(this.zza(this.zzbaH));
        camera.addCallbackBuffer(this.zza(this.zzbaH));
        camera.addCallbackBuffer(this.zza(this.zzbaH));
        camera.addCallbackBuffer(this.zza(this.zzbaH));
        return camera;
    }

    private static int zzjD(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != n) continue;
            return i;
        }
        return -1;
    }

    private static zze zza(Camera camera, int n, int n2) {
        List<zze> list = CameraSource.zza(camera);
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        for (zze zze3 : list) {
            Size size = zze3.zzEv();
            int n4 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n4 >= n3) continue;
            zze2 = zze3;
            n3 = n4;
        }
        return zze2;
    }

    private static List<zze> zza(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (int i = list2.size() - 1; i >= 0; --i) {
                Camera.Size size2 = (Camera.Size)list2.get(i);
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        return arrayList;
    }

    private int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        List list = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] nArray2 : list) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    private void zza(Camera camera, Camera.Parameters parameters, int n) {
        int n2;
        int n3;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n4 = 0;
        int n5 = windowManager.getDefaultDisplay().getRotation();
        switch (n5) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)("Bad rotation value: " + n5));
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n3) % 360;
        } else {
            n2 = n3 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        this.zzAF = n3 / 90;
        camera.setDisplayOrientation(n2);
        parameters.setRotation(n3);
    }

    private byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        long l = size.getHeight() * size.getWidth() * n;
        int n2 = (int)Math.ceil((double)l / 8.0) + 1;
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzbaQ.put(byArray, byteBuffer);
        return byArray;
    }

    private class zzb
    implements Runnable {
        private Detector<?> zzbaR;
        private long zzNY = SystemClock.elapsedRealtime();
        private final Object zzpd = new Object();
        private boolean zzbaU = true;
        private long zzbaV;
        private int zzbaW = 0;
        private ByteBuffer zzbaX;

        zzb(Detector<?> detector) {
            this.zzbaR = detector;
        }

        void release() {
            assert (CameraSource.this.zzbaO.getState() == Thread.State.TERMINATED);
            this.zzbaR.release();
            this.zzbaR = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean active) {
            Object object = this.zzpd;
            synchronized (object) {
                this.zzbaU = active;
                this.zzpd.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void zza(byte[] byArray, Camera camera) {
            Object object = this.zzpd;
            synchronized (object) {
                if (this.zzbaX != null) {
                    camera.addCallbackBuffer(this.zzbaX.array());
                    this.zzbaX = null;
                }
                this.zzbaV = SystemClock.elapsedRealtime() - this.zzNY;
                ++this.zzbaW;
                this.zzbaX = (ByteBuffer)CameraSource.this.zzbaQ.get(byArray);
                this.zzpd.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.zzpd;
                synchronized (object) {
                    if (this.zzbaU && this.zzbaX == null) {
                        try {
                            this.zzpd.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.zzbaU) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzbaX, CameraSource.this.zzbaH.getWidth(), CameraSource.this.zzbaH.getHeight(), 17).setId(this.zzbaW).setTimestampMillis(this.zzbaV).setRotation(CameraSource.this.zzAF).build();
                    byteBuffer = this.zzbaX;
                    this.zzbaX = null;
                }
                try {
                    this.zzbaR.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    CameraSource.this.zzbaF.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    private class zza
    implements Camera.PreviewCallback {
        private zza() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            CameraSource.this.zzbaP.zza(data, camera);
        }
    }

    private static class zze {
        private Size zzbba;
        private Size zzbbb;

        public zze(Camera.Size size, Camera.Size size2) {
            this.zzbba = new Size(size.width, size.height);
            this.zzbbb = new Size(size2.width, size2.height);
        }

        public Size zzEv() {
            return this.zzbba;
        }

        public Size zzEw() {
            return this.zzbbb;
        }
    }

    private class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzbaY;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPictureTaken(byte[] data, Camera camera) {
            if (this.zzbaY != null) {
                this.zzbaY.onPictureTaken(data);
            }
            Object object = CameraSource.this.zzbaE;
            synchronized (object) {
                if (CameraSource.this.zzbaF != null) {
                    CameraSource.this.zzbaF.startPreview();
                }
            }
        }
    }

    private class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzbaZ;

        private zzd() {
        }

        public void onShutter() {
            if (this.zzbaZ != null) {
                this.zzbaZ.onShutter();
            }
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzbaR;
        private CameraSource zzbaS = new CameraSource();

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzbaR = detector;
            this.zzbaS.mContext = context;
        }

        public Builder setRequestedFps(float fps) {
            if (fps <= 0.0f) {
                throw new IllegalArgumentException("Invalid fps: " + fps);
            }
            this.zzbaS.zzbaI = fps;
            return this;
        }

        public Builder setRequestedPreviewSize(int width, int height) {
            int n = 1000000;
            if (width <= 0 || width > 1000000 || height <= 0 || height > 1000000) {
                throw new IllegalArgumentException("Invalid preview size: " + width + "x" + height);
            }
            this.zzbaS.zzbaJ = width;
            this.zzbaS.zzbaK = height;
            return this;
        }

        public Builder setFacing(int facing) {
            if (facing != 0 && facing != 1) {
                throw new IllegalArgumentException("Invalid camera: " + facing);
            }
            this.zzbaS.zzbaG = facing;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzbaS;
            cameraSource.getClass();
            this.zzbaS.zzbaP = cameraSource.new zzb(this.zzbaR);
            return this.zzbaS;
        }
    }
}

