/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.internal.vision.zzab;
import com.google.android.gms.internal.vision.zzah;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzah[] zza;
    private Point[] zzb;
    private List<Line> zzc;
    private String zzd;
    private Rect zze;

    TextBlock(SparseArray<zzah> sparseArray) {
        this.zza = new zzah[sparseArray.size()];
        for (int i = 0; i < this.zza.length; ++i) {
            this.zza[i] = (zzah)((Object)sparseArray.valueAt(i));
        }
    }

    @Override
    @RecentlyNonNull
    public String getLanguage() {
        if (this.zzd != null) {
            return this.zzd;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzah[] zzahArray = this.zza;
        int n = this.zza.length;
        for (int i = 0; i < n; ++i) {
            zzah zzah2 = zzahArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzah2.zzd)) {
                n2 = (Integer)hashMap.get(zzah2.zzd);
            }
            hashMap.put(zzah2.zzd, n2 + 1);
        }
        this.zzd = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzd == null || this.zzd.isEmpty()) {
            this.zzd = "und";
        }
        return this.zzd;
    }

    @Override
    @RecentlyNonNull
    public String getValue() {
        if (this.zza.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zza[0].zzc);
        for (int i = 1; i < this.zza.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zza[i].zzc);
        }
        return stringBuilder.toString();
    }

    @Override
    @RecentlyNonNull
    public Point[] getCornerPoints() {
        if (this.zzb == null) {
            TextBlock textBlock = this;
            if (textBlock.zza.length == 0) {
                textBlock.zzb = new Point[0];
            } else {
                int n;
                int n2;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zza.length; ++i) {
                    zzab zzab2 = textBlock.zza[0].zzb;
                    zzab zzab3 = textBlock.zza[i].zzb;
                    n2 = -zzab2.zza;
                    n = -zzab2.zzb;
                    double d = Math.sin(Math.toRadians(zzab2.zze));
                    double d2 = Math.cos(Math.toRadians(zzab2.zze));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzab3.zza, zzab3.zzb);
                    pointArray2[0].offset(n2, n);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzab3.zzc, n8);
                    pointArray2[2] = new Point(n7 + zzab3.zzc, n8 + zzab3.zzd);
                    pointArray2[3] = new Point(n7, n8 + zzab3.zzd);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n3 = Math.min(n3, point.x);
                        n4 = Math.max(n4, point.x);
                        n5 = Math.min(n5, point.y);
                        n6 = Math.max(n6, point.y);
                    }
                }
                zzab zzab4 = textBlock.zza[0].zzb;
                n = n6;
                n2 = n4;
                int n9 = n5;
                int n10 = n3;
                int n11 = zzab4.zza;
                int n12 = zzab4.zzb;
                double d = Math.sin(Math.toRadians(zzab4.zze));
                double d3 = Math.cos(Math.toRadians(zzab4.zze));
                Point[] pointArray = new Point[4];
                Point[] pointArray4 = pointArray;
                pointArray[0] = new Point(n10, n9);
                pointArray4[1] = new Point(n2, n9);
                pointArray4[2] = new Point(n2, n);
                pointArray4[3] = new Point(n10, n);
                for (int i = 0; i < 4; ++i) {
                    int n13 = (int)((double)pointArray4[i].x * d3 - (double)pointArray4[i].y * d);
                    int n14 = (int)((double)pointArray4[i].x * d + (double)pointArray4[i].y * d3);
                    pointArray4[i].x = n13;
                    pointArray4[i].y = n14;
                    pointArray4[i].offset(n11, n12);
                }
                textBlock.zzb = pointArray4;
            }
        }
        return this.zzb;
    }

    @Override
    @RecentlyNonNull
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zza.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzc == null) {
            textBlock.zzc = new ArrayList<Line>(textBlock.zza.length);
            zzah[] zzahArray = textBlock.zza;
            int n = textBlock.zza.length;
            for (int i = 0; i < n; ++i) {
                zzah zzah2 = zzahArray[i];
                textBlock.zzc.add(new Line(zzah2));
            }
        }
        return textBlock.zzc;
    }

    @Override
    @RecentlyNonNull
    public Rect getBoundingBox() {
        if (this.zze == null) {
            this.zze = com.google.android.gms.vision.text.zzc.zza(this);
        }
        return this.zze;
    }
}

