/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.Image;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.vision.zzs;
import com.google.android.gms.internal.vision.zzw;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.zzb;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.zza;
import com.google.android.gms.vision.zzc;
import java.nio.ByteBuffer;
import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int CONTOUR_LANDMARKS = 2;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    public static final int SELFIE_MODE = 2;
    private final zzc zza = new zzc();
    @GuardedBy(value="lock")
    private final zzb zzb;
    private final Object zzc = new Object();
    @GuardedBy(value="lock")
    private boolean zzd = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        super.release();
        Object object = this.zzc;
        synchronized (object) {
            if (!this.zzd) {
                return;
            }
            this.zzb.zzc();
            this.zzd = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            Object object = this.zzc;
            synchronized (object) {
                if (this.zzd) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RecentlyNonNull
    public final SparseArray<Face> detect(@RecentlyNonNull Frame frame) {
        Face[] faceArray;
        Object object;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        if (Build.VERSION.SDK_INT >= 19 && frame.getPlanes() != null && ((Image.Plane[])Preconditions.checkNotNull((Object)frame.getPlanes())).length == 3) {
            object = this.zzc;
            synchronized (object) {
                if (!this.zzd) {
                    throw new IllegalStateException("Cannot use detector after release()");
                }
                faceArray = this.zzb.zza((Image.Plane[])Preconditions.checkNotNull((Object)frame.getPlanes()), zzs.zza((Frame)frame));
            }
        }
        object = frame.getBitmap() != null ? zzw.zza((Bitmap)((Bitmap)Preconditions.checkNotNull((Object)frame.getBitmap())), (boolean)true) : frame.getGrayscaleImageData();
        HashSet<Integer> hashSet = this.zzc;
        synchronized (hashSet) {
            if (!this.zzd) {
                throw new IllegalStateException("Cannot use detector after release()");
            }
            faceArray = this.zzb.zza((ByteBuffer)Preconditions.checkNotNull((Object)object), zzs.zza((Frame)frame));
        }
        int n = 0;
        hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        Face[] faceArray2 = faceArray;
        int n2 = faceArray.length;
        for (int i = 0; i < n2; ++i) {
            Face face = faceArray2[i];
            int n3 = face.getId();
            n = Math.max(n, n3);
            if (hashSet.contains(n3)) {
                n3 = ++n;
            }
            hashSet.add(n3);
            int n4 = this.zza.zza(n3);
            sparseArray.append(n4, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFocus(int n) {
        int n2 = this.zza.zzb(n);
        Object object = this.zzc;
        synchronized (object) {
            if (!this.zzd) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzb.zza(n2);
        }
    }

    public final boolean isOperational() {
        return this.zzb.zzb();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zzb zzb2) {
        this.zzb = zzb2;
    }

    private static boolean zzb(zzf zzf2) {
        boolean bl = true;
        if (zzf2.zza != 2 && zzf2.zzb == 2) {
            Log.e((String)"FaceDetector", (String)"Contour is not supported for non-SELFIE mode.");
            bl = false;
        }
        if (zzf2.zzb == 2 && zzf2.zzc == 1) {
            Log.e((String)"FaceDetector", (String)"Classification is not supported with contour.");
            bl = false;
        }
        return bl;
    }

    /* synthetic */ FaceDetector(zzb zzb2, zza zza2) {
        this(zzb2);
    }

    public static class Builder {
        private final Context zza;
        private int zzb = 0;
        private boolean zzc = false;
        private int zzd = 0;
        private boolean zze = true;
        private int zzf = 0;
        private float zzg = -1.0f;

        public Builder(@RecentlyNonNull Context context) {
            this.zza = context;
        }

        @RecentlyNonNull
        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1 && n != 2) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.zzb = n;
            return this;
        }

        @RecentlyNonNull
        public Builder setProminentFaceOnly(boolean bl) {
            this.zzc = bl;
            return this;
        }

        @RecentlyNonNull
        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzd = n;
            return this;
        }

        @RecentlyNonNull
        public Builder setTrackingEnabled(boolean bl) {
            this.zze = bl;
            return this;
        }

        @RecentlyNonNull
        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.zzf = n;
            return this;
        }

        @RecentlyNonNull
        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.zzg = f;
            return this;
        }

        @RecentlyNonNull
        public FaceDetector build() {
            zzf zzf2 = new zzf();
            new zzf().zza = this.zzf;
            zzf2.zzb = this.zzb;
            zzf2.zzc = this.zzd;
            zzf2.zzd = this.zzc;
            zzf2.zze = this.zze;
            zzf2.zzf = this.zzg;
            if (!FaceDetector.zzb(zzf2)) {
                throw new IllegalArgumentException("Invalid build options");
            }
            zzb zzb2 = new zzb(this.zza, zzf2);
            return new FaceDetector(zzb2, null);
        }
    }
}

