/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.Image;
import android.os.Build;
import android.util.SparseArray;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.vision.zzk;
import com.google.android.gms.internal.vision.zzm;
import com.google.android.gms.internal.vision.zzs;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzm zza;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzm zzm2) {
        this.zza = zzm2;
    }

    public final void release() {
        super.release();
        this.zza.zzc();
    }

    @RecentlyNonNull
    public final SparseArray<Barcode> detect(@RecentlyNonNull Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzs zzs2 = zzs.zza((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zza.zza((Bitmap)Preconditions.checkNotNull((Object)frame.getBitmap()), zzs2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else if (Build.VERSION.SDK_INT >= 19 && frame.getPlanes() != null) {
            byteBuffer = ((Image.Plane[])Preconditions.checkNotNull((Object)frame.getPlanes()))[0].getBuffer();
            zzs2 = new zzs(((Image.Plane[])Preconditions.checkNotNull((Object)frame.getPlanes()))[0].getRowStride(), zzs2.zzb, zzs2.zzc, zzs2.zzd, zzs2.zze);
            barcodeArray = this.zza.zza((ByteBuffer)Preconditions.checkNotNull((Object)byteBuffer), zzs2);
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zza.zza((ByteBuffer)Preconditions.checkNotNull((Object)byteBuffer), zzs2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zza.zzb();
    }

    /* synthetic */ BarcodeDetector(zzm zzm2, zzc zzc2) {
        this(zzm2);
    }

    public static class Builder {
        private Context zza;
        private zzk zzb;

        public Builder(@RecentlyNonNull Context context) {
            this.zza = context;
            this.zzb = new zzk();
        }

        @RecentlyNonNull
        public Builder setBarcodeFormats(int n) {
            this.zzb.zza = n;
            return this;
        }

        @RecentlyNonNull
        public BarcodeDetector build() {
            zzm zzm2 = new zzm(this.zza, this.zzb);
            return new BarcodeDetector(zzm2, null);
        }
    }
}

