/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.vision.zzk;
import com.google.android.gms.internal.vision.zzl;
import com.google.android.gms.internal.vision.zzn;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.internal.vision.zzs;
import com.google.android.gms.internal.vision.zzt;
import com.google.android.gms.vision.barcode.Barcode;
import java.nio.ByteBuffer;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

public final class zzm
extends zzt<zzl> {
    private final zzk zza;

    public zzm(Context context, zzk zzk2) {
        super(context, "BarcodeNativeHandle", "barcode");
        this.zza = zzk2;
        this.zzd();
    }

    public final Barcode[] zza(ByteBuffer byteBuffer, zzs zzs2) {
        if (!this.zzb()) {
            return new Barcode[0];
        }
        try {
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)byteBuffer);
            return ((zzl)Preconditions.checkNotNull((Object)((zzl)this.zzd()))).zza(iObjectWrapper, zzs2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"BarcodeNativeHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    public final Barcode[] zza(Bitmap bitmap, zzs zzs2) {
        if (!this.zzb()) {
            return new Barcode[0];
        }
        try {
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)bitmap);
            return ((zzl)Preconditions.checkNotNull((Object)((zzl)this.zzd()))).zzb(iObjectWrapper, zzs2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"BarcodeNativeHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    protected final void zza() throws RemoteException {
        if (this.zzb()) {
            ((zzl)Preconditions.checkNotNull((Object)((zzl)this.zzd()))).zza();
        }
    }

    @Nullable
    protected final /* synthetic */ Object zza(@UnknownInitialization zzm this, DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.LoadingException {
        IInterface iInterface;
        zzn zzn2;
        Context context2 = context;
        DynamiteModule dynamiteModule2 = dynamiteModule;
        zzm zzm2 = this;
        IBinder iBinder = dynamiteModule2.instantiate("com.google.android.gms.vision.barcode.ChimeraNativeBarcodeDetectorCreator");
        if ((iBinder == null ? null : (zzn2 = (iInterface = iBinder.queryLocalInterface("com.google.android.gms.vision.barcode.internal.client.INativeBarcodeDetectorCreator")) instanceof zzn ? (zzn)iInterface : new zzp(iBinder))) == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context2);
        return zzn2.zza(iObjectWrapper, (zzk)((Object)Preconditions.checkNotNull((Object)((Object)zzm2.zza))));
    }
}

