/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzab;
import com.google.android.gms.internal.vision.zzah;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzah[] zzeh;
    private Point[] cornerPoints;
    private List<Line> zzei;
    private String zzej;
    private Rect zzek;

    TextBlock(SparseArray<zzah> sparseArray) {
        this.zzeh = new zzah[sparseArray.size()];
        for (int i = 0; i < this.zzeh.length; ++i) {
            this.zzeh[i] = (zzah)((Object)sparseArray.valueAt(i));
        }
    }

    @Override
    public String getLanguage() {
        if (this.zzej != null) {
            return this.zzej;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzah[] zzahArray = this.zzeh;
        int n = this.zzeh.length;
        for (int i = 0; i < n; ++i) {
            zzah zzah2 = zzahArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzah2.zzej)) {
                n2 = (Integer)hashMap.get(zzah2.zzej);
            }
            hashMap.put(zzah2.zzej, n2 + 1);
        }
        this.zzej = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzej == null || this.zzej.isEmpty()) {
            this.zzej = "und";
        }
        return this.zzej;
    }

    @Override
    public String getValue() {
        if (this.zzeh.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzeh[0].zzes);
        for (int i = 1; i < this.zzeh.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzeh[i].zzes);
        }
        return stringBuilder.toString();
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzeh.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n;
                int n2;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzeh.length; ++i) {
                    zzab zzab2 = textBlock.zzeh[0].zzep;
                    zzab zzab3 = textBlock.zzeh[i].zzep;
                    n2 = -zzab2.left;
                    n = -zzab2.top;
                    double d = Math.sin(Math.toRadians(zzab2.zzen));
                    double d2 = Math.cos(Math.toRadians(zzab2.zzen));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzab3.left, zzab3.top);
                    pointArray2[0].offset(n2, n);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzab3.width, n8);
                    pointArray2[2] = new Point(n7 + zzab3.width, n8 + zzab3.height);
                    pointArray2[3] = new Point(n7, n8 + zzab3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n3 = Math.min(n3, point.x);
                        n4 = Math.max(n4, point.x);
                        n5 = Math.min(n5, point.y);
                        n6 = Math.max(n6, point.y);
                    }
                }
                zzab zzab4 = textBlock.zzeh[0].zzep;
                n = n6;
                n2 = n4;
                int n9 = n5;
                int n10 = n3;
                int n11 = zzab4.left;
                int n12 = zzab4.top;
                double d = Math.sin(Math.toRadians(zzab4.zzen));
                double d3 = Math.cos(Math.toRadians(zzab4.zzen));
                Point[] pointArray = new Point[4];
                Point[] pointArray4 = pointArray;
                pointArray[0] = new Point(n10, n9);
                pointArray4[1] = new Point(n2, n9);
                pointArray4[2] = new Point(n2, n);
                pointArray4[3] = new Point(n10, n);
                for (int i = 0; i < 4; ++i) {
                    int n13 = (int)((double)pointArray4[i].x * d3 - (double)pointArray4[i].y * d);
                    int n14 = (int)((double)pointArray4[i].x * d + (double)pointArray4[i].y * d3);
                    pointArray4[i].x = n13;
                    pointArray4[i].y = n14;
                    pointArray4[i].offset(n11, n12);
                }
                textBlock.cornerPoints = pointArray4;
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzeh.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzei == null) {
            textBlock.zzei = new ArrayList<Line>(textBlock.zzeh.length);
            zzah[] zzahArray = textBlock.zzeh;
            int n = textBlock.zzeh.length;
            for (int i = 0; i < n; ++i) {
                zzah zzah2 = zzahArray[i];
                textBlock.zzei.add(new Line(zzah2));
            }
        }
        return textBlock.zzei;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzek == null) {
            this.zzek = zzc.zza(this);
        }
        return this.zzek;
    }
}

