/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzah;
import com.google.android.gms.internal.vision.zzaj;
import com.google.android.gms.internal.vision.zzam;
import com.google.android.gms.internal.vision.zzan;
import com.google.android.gms.internal.vision.zzu;
import com.google.android.gms.internal.vision.zzv;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzan zzem;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzan zzan2) {
        this.zzem = zzan2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        Rect rect;
        int n;
        int n2;
        Frame.Metadata metadata;
        Bitmap bitmap;
        zzaj zzaj2 = new zzaj(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzu zzu2 = zzu.zzd((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            metadata = frame2.getMetadata();
            int n3 = zzu2.height;
            n2 = zzu2.width;
            n = metadata.getFormat();
            rect = frame2.getGrayscaleImageData();
            if (rect.hasArray() && rect.arrayOffset() == 0) {
                byArray = rect.array();
            } else {
                byArray = new byte[rect.capacity()];
                rect.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        bitmap = zzv.zzb((Bitmap)bitmap, (zzu)zzu2);
        if (!zzaj2.zzey.isEmpty()) {
            Rect rect2;
            zzu zzu3 = zzu2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            rect = zzaj2.zzey;
            switch (zzu3.rotation) {
                case 1: {
                    rect2 = new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
                    break;
                }
                case 2: {
                    rect2 = new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
                    break;
                }
                case 3: {
                    rect2 = new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
                    break;
                }
                default: {
                    rect2 = rect;
                }
            }
            metadata = rect2;
            zzaj2.zzey.set((Rect)metadata);
        }
        zzu2.rotation = 0;
        rect = textRecognizer.zzem.zza(bitmap, zzu2, zzaj2);
        SparseArray sparseArray = new SparseArray();
        for (ByteArrayOutputStream byteArrayOutputStream : rect) {
            SparseArray sparseArray2 = (SparseArray)sparseArray.get(((zzah)((Object)byteArrayOutputStream)).zzew);
            if (sparseArray2 == null) {
                sparseArray2 = new SparseArray();
                sparseArray.append(((zzah)((Object)byteArrayOutputStream)).zzew, (Object)sparseArray2);
            }
            sparseArray2.append(((zzah)((Object)byteArrayOutputStream)).zzex, (Object)byteArrayOutputStream);
        }
        Rect rect3 = new SparseArray(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            rect3.append(sparseArray.keyAt(i), (Object)new TextBlock((SparseArray<zzah>)((SparseArray)sparseArray.valueAt(i))));
        }
        return rect3;
    }

    public final boolean isOperational() {
        return this.zzem.isOperational();
    }

    public final void release() {
        super.release();
        this.zzem.zzp();
    }

    /* synthetic */ TextRecognizer(zzan zzan2, zzb zzb2) {
        this(zzan2);
    }

    public static class Builder {
        private Context zzg;
        private zzam zzen;

        public Builder(Context context) {
            this.zzg = context;
            this.zzen = new zzam();
        }

        public TextRecognizer build() {
            zzan zzan2 = new zzan(this.zzg, this.zzen);
            return new TextRecognizer(zzan2, null);
        }
    }
}

