/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.vision.zzbe;
import com.google.android.gms.internal.vision.zzn;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.internal.vision.zzr;
import com.google.android.gms.vision.face.Contour;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.internal.client.zzh;
import com.google.android.gms.vision.face.internal.client.zzi;
import com.google.android.gms.vision.face.internal.client.zzl;
import java.nio.ByteBuffer;

public final class zzb
extends zzn<zzh> {
    private final zzf zzcz;

    public zzb(Context context, zzf zzf2) {
        super(context, "FaceNativeHandle", "face");
        zzbe.init((Context)context);
        this.zzcz = zzf2;
        this.zzp();
    }

    public final Face[] zzb(ByteBuffer byteBuffer, zzp zzp2) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = ObjectWrapper.wrap((Object)byteBuffer);
            faceParcelArray = ((zzh)this.zzp()).zzc((IObjectWrapper)faceArray, zzp2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            AbstractSafeParcelable abstractSafeParcelable;
            int n;
            Object[] objectArray;
            FaceParcel faceParcel = faceParcelArray[i];
            int n2 = faceParcel.id;
            PointF pointF = new PointF(faceParcel.centerX, faceParcel.centerY);
            float f = faceParcel.width;
            float f2 = faceParcel.height;
            float f3 = faceParcel.zzda;
            float f4 = faceParcel.zzdb;
            float f5 = faceParcel.zzdc;
            FaceParcel faceParcel2 = faceParcel;
            AbstractSafeParcelable[] abstractSafeParcelableArray = faceParcel2.zzdd;
            if (faceParcel2.zzdd == null) {
                objectArray = new Landmark[]{};
            } else {
                objectArray = new Landmark[abstractSafeParcelableArray.length];
                for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                    abstractSafeParcelable = abstractSafeParcelableArray[n];
                    objectArray[n] = new Landmark(new PointF(abstractSafeParcelable.x, abstractSafeParcelable.y), abstractSafeParcelable.type);
                }
            }
            Landmark[] landmarkArray = objectArray;
            faceParcel2 = faceParcel;
            abstractSafeParcelableArray = faceParcel2.zzde;
            if (faceParcel2.zzde == null) {
                objectArray = new Contour[]{};
            } else {
                objectArray = new Contour[abstractSafeParcelableArray.length];
                for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                    abstractSafeParcelable = abstractSafeParcelableArray[n];
                    objectArray[n] = new Contour(abstractSafeParcelable.zzcy, abstractSafeParcelable.type);
                }
            }
            faceArray[i] = new Face(n2, pointF, f, f2, f3, f4, f5, landmarkArray, (Contour[])objectArray, faceParcel.zzcf, faceParcel.zzcg, faceParcel.zzch, faceParcel.zzci);
        }
        return faceArray;
    }

    public final boolean zzd(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zzh)this.zzp()).zzd(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected final void zzn() throws RemoteException {
        ((zzh)this.zzp()).zzm();
    }

    protected final /* synthetic */ Object zza(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.LoadingException {
        Context context2 = context;
        DynamiteModule dynamiteModule2 = dynamiteModule;
        zzb zzb2 = this;
        zzi zzi2 = zzr.zza((Context)context2, (String)"com.google.android.gms.vision.dynamite.face") ? zzl.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.NativeFaceDetectorV2Creator")) : zzl.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
        if (zzi2 == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context2);
        return zzi2.newFaceDetector(iObjectWrapper, zzb2.zzcz);
    }
}

