/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.zzb;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.zza;
import com.google.android.gms.vision.zzc;
import java.nio.ByteBuffer;
import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int CONTOUR_LANDMARKS = 2;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    public static final int SELFIE_MODE = 2;
    private final zzc zzck = new zzc();
    @GuardedBy(value="lock")
    private final zzb zzcl;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean zzcm = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        super.release();
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzcm) {
                return;
            }
            this.zzcl.zzo();
            this.zzcm = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.zzcm) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        ByteBuffer byteBuffer;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        if (frame.getBitmap() != null) {
            Bitmap bitmap = frame.getBitmap();
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            int n3 = n * n2;
            int n4 = (n + 1) / 2 * ((n2 + 1) / 2) << 1;
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n3 + n4);
            int n5 = n3;
            for (int i = 0; i < n3; ++i) {
                int n6 = bitmap.getPixel(i % n, i / n);
                int n7 = Color.red((int)n6);
                int n8 = Color.green((int)n6);
                int n9 = Color.blue((int)n6);
                float f = 0.299f * (float)n7 + 0.587f * (float)n8 + 0.114f * (float)n9;
                byteBuffer2.put(i, (byte)f);
                if (i / n % 2 != 0 || i % n % 2 != 0) continue;
                float f2 = -0.169f * (float)n7 + -0.331f * (float)n8 + 0.5f * (float)n9 + 128.0f;
                float f3 = 0.5f * (float)n7 + -0.419f * (float)n8 + -0.081f * (float)n9 + 128.0f;
                byteBuffer2.put(n5++, (byte)f2);
                byteBuffer2.put(n5++, (byte)f3);
            }
            byteBuffer = byteBuffer2;
        } else {
            byteBuffer = frame.getGrayscaleImageData();
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzcm) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzcl.zzb(byteBuffer, zzp.zzc((Frame)frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        Face[] faceArray2 = faceArray;
        int n10 = faceArray.length;
        for (int i = 0; i < n10; ++i) {
            Face face = faceArray2[i];
            int n11 = face.getId();
            n = Math.max(n, n11);
            if (hashSet.contains(n11)) {
                n11 = ++n;
            }
            hashSet.add(n11);
            int n12 = this.zzck.zzb(n11);
            sparseArray.append(n12, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFocus(int n) {
        int n2 = this.zzck.zzc(n);
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzcm) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzcl.zzd(n2);
        }
    }

    public final boolean isOperational() {
        return this.zzcl.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zzb zzb2) {
        this.zzcl = zzb2;
    }

    private static boolean zza(zzf zzf2) {
        boolean bl = true;
        if (zzf2.mode != 2 && zzf2.landmarkType == 2) {
            Log.e((String)"FaceDetector", (String)"Contour is not supported for non-SELFIE mode.");
            bl = false;
        }
        if (zzf2.landmarkType == 2 && zzf2.zzcp == 1) {
            Log.e((String)"FaceDetector", (String)"Classification is not supported with contour.");
            bl = false;
        }
        return bl;
    }

    /* synthetic */ FaceDetector(zzb zzb2, zza zza2) {
        this(zzb2);
    }

    public static class Builder {
        private final Context zze;
        private int landmarkType = 0;
        private boolean zzco = false;
        private int zzcp = 0;
        private boolean trackingEnabled = true;
        private int mode = 0;
        private float proportionalMinFaceSize = -1.0f;

        public Builder(Context context) {
            this.zze = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1 && n != 2) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.landmarkType = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.zzco = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzcp = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.trackingEnabled = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.mode = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.proportionalMinFaceSize = f;
            return this;
        }

        public FaceDetector build() {
            zzf zzf2 = new zzf();
            new zzf().mode = this.mode;
            zzf2.landmarkType = this.landmarkType;
            zzf2.zzcp = this.zzcp;
            zzf2.zzco = this.zzco;
            zzf2.trackingEnabled = this.trackingEnabled;
            zzf2.proportionalMinFaceSize = this.proportionalMinFaceSize;
            if (!FaceDetector.zza(zzf2)) {
                throw new IllegalArgumentException("Invalid build options");
            }
            zzb zzb2 = new zzb(this.zze, zzf2);
            return new FaceDetector(zzb2, null);
        }
    }
}

