/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzf;
import com.google.android.gms.internal.vision.zzh;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzh zzbk;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzh zzh2) {
        this.zzbk = zzh2;
    }

    public final void release() {
        super.release();
        this.zzbk.zzo();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzp zzp2 = zzp.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbk.zza(frame.getBitmap(), zzp2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbk.zza(byteBuffer, zzp2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzbk.isOperational();
    }

    /* synthetic */ BarcodeDetector(zzh zzh2, zzc zzc2) {
        this(zzh2);
    }

    public static class Builder {
        private Context zze;
        private zzf zzbl;

        public Builder(Context context) {
            this.zze = context;
            this.zzbl = new zzf();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbl.zzbm = n;
            return this;
        }

        public BarcodeDetector build() {
            zzh zzh2 = new zzh(this.zze, this.zzbl);
            return new BarcodeDetector(zzh2, null);
        }
    }
}

