/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.vision.zzm;
import com.google.android.gms.internal.vision.zzn;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.vision.face.Contour;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.zze;
import com.google.android.gms.vision.face.internal.client.zzg;
import com.google.android.gms.vision.face.internal.client.zzj;
import com.google.android.gms.vision.face.internal.client.zzk;
import java.nio.ByteBuffer;

public final class zzc
extends zzm<zzg> {
    private final zze zzda;

    public zzc(Context context, zze zze2) {
        super(context, "FaceNativeHandle", "face");
        this.zzda = zze2;
        this.zzq();
    }

    public final Face[] zzb(ByteBuffer byteBuffer, zzn zzn2) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = ObjectWrapper.wrap((Object)byteBuffer);
            faceParcelArray = ((zzg)this.zzq()).zzc((IObjectWrapper)faceArray, zzn2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            AbstractSafeParcelable abstractSafeParcelable;
            int n;
            Object[] objectArray;
            FaceParcel faceParcel = faceParcelArray[i];
            int n2 = faceParcel.id;
            PointF pointF = new PointF(faceParcel.centerX, faceParcel.centerY);
            float f = faceParcel.width;
            float f2 = faceParcel.height;
            float f3 = faceParcel.zzdb;
            float f4 = faceParcel.zzdc;
            float f5 = faceParcel.zzdd;
            FaceParcel faceParcel2 = faceParcel;
            AbstractSafeParcelable[] abstractSafeParcelableArray = faceParcel2.zzde;
            if (faceParcel2.zzde == null) {
                objectArray = new Landmark[]{};
            } else {
                objectArray = new Landmark[abstractSafeParcelableArray.length];
                for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                    abstractSafeParcelable = abstractSafeParcelableArray[n];
                    objectArray[n] = new Landmark(new PointF(abstractSafeParcelable.x, abstractSafeParcelable.y), abstractSafeParcelable.type);
                }
            }
            Landmark[] landmarkArray = objectArray;
            faceParcel2 = faceParcel;
            abstractSafeParcelableArray = faceParcel2.zzdf;
            if (faceParcel2.zzdf == null) {
                objectArray = new Contour[]{};
            } else {
                objectArray = new Contour[abstractSafeParcelableArray.length];
                for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                    abstractSafeParcelable = abstractSafeParcelableArray[n];
                    objectArray[n] = new Contour(abstractSafeParcelable.zzcz, abstractSafeParcelable.type);
                }
            }
            faceArray[i] = new Face(n2, pointF, f, f2, f3, f4, f5, landmarkArray, (Contour[])objectArray, faceParcel.zzcg, faceParcel.zzch, faceParcel.zzci);
        }
        return faceArray;
    }

    public final boolean zzd(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zzg)this.zzq()).zzd(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected final void zzm() throws RemoteException {
        ((zzg)this.zzq()).zzn();
    }

    protected final /* synthetic */ Object zza(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.LoadingException {
        Context context2 = context;
        DynamiteModule dynamiteModule2 = dynamiteModule;
        zzc zzc2 = this;
        zzj zzj2 = zzp.zza((Context)context2, (String)"com.google.android.gms.vision.dynamite.face") ? zzk.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.NativeFaceDetectorV2Creator")) : zzk.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
        if (zzj2 == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context2);
        return zzj2.newFaceDetector(iObjectWrapper, zzc2.zzda);
    }
}

