/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzad;
import com.google.android.gms.internal.vision.zzae;
import com.google.android.gms.internal.vision.zzm;
import com.google.android.gms.internal.vision.zzo;
import com.google.android.gms.internal.vision.zzx;
import com.google.android.gms.internal.vision.zzz;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzad zzdf;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzad zzad2) {
        this.zzdf = zzad2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        Rect rect;
        int n;
        int n2;
        Frame.Metadata metadata;
        Bitmap bitmap;
        zzz zzz2 = new zzz(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzm zzm2 = zzm.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            metadata = frame2.getMetadata();
            int n3 = zzm2.height;
            n2 = zzm2.width;
            n = metadata.getFormat();
            rect = frame2.getGrayscaleImageData();
            if (rect.hasArray() && rect.arrayOffset() == 0) {
                byArray = rect.array();
            } else {
                byArray = new byte[rect.capacity()];
                rect.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        bitmap = zzo.zzb((Bitmap)bitmap, (zzm)zzm2);
        if (!zzz2.zzdr.isEmpty()) {
            Rect rect2;
            zzm zzm3 = zzm2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            rect = zzz2.zzdr;
            switch (zzm3.rotation) {
                case 1: {
                    rect2 = new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
                    break;
                }
                case 2: {
                    rect2 = new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
                    break;
                }
                case 3: {
                    rect2 = new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
                    break;
                }
                default: {
                    rect2 = rect;
                }
            }
            metadata = rect2;
            zzz2.zzdr.set((Rect)metadata);
        }
        zzm2.rotation = 0;
        rect = textRecognizer.zzdf.zza(bitmap, zzm2, zzz2);
        SparseArray sparseArray = new SparseArray();
        for (ByteArrayOutputStream byteArrayOutputStream : rect) {
            SparseArray sparseArray2 = (SparseArray)sparseArray.get(((zzx)((Object)byteArrayOutputStream)).zzdp);
            if (sparseArray2 == null) {
                sparseArray2 = new SparseArray();
                sparseArray.append(((zzx)((Object)byteArrayOutputStream)).zzdp, (Object)sparseArray2);
            }
            sparseArray2.append(((zzx)((Object)byteArrayOutputStream)).zzdq, (Object)byteArrayOutputStream);
        }
        Rect rect3 = new SparseArray(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            rect3.append(sparseArray.keyAt(i), (Object)new TextBlock((SparseArray<zzx>)((SparseArray)sparseArray.valueAt(i))));
        }
        return rect3;
    }

    public final boolean isOperational() {
        return this.zzdf.isOperational();
    }

    public final void release() {
        super.release();
        this.zzdf.zzo();
    }

    /* synthetic */ TextRecognizer(zzad zzad2, zzb zzb2) {
        this(zzad2);
    }

    public static class Builder {
        private Context zze;
        private zzae zzdg;

        public Builder(Context context) {
            this.zze = context;
            this.zzdg = new zzae();
        }

        public TextRecognizer build() {
            zzad zzad2 = new zzad(this.zze, this.zzdg);
            return new TextRecognizer(zzad2, null);
        }
    }
}

