/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzr;
import com.google.android.gms.internal.vision.zzx;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzx[] zzdb;
    private Point[] cornerPoints;
    private List<Line> zzdc;
    private String zzdd;
    private Rect zzde;

    TextBlock(SparseArray<zzx> sparseArray) {
        this.zzdb = new zzx[sparseArray.size()];
        for (int i = 0; i < this.zzdb.length; ++i) {
            this.zzdb[i] = (zzx)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzdd != null) {
            return this.zzdd;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzx[] zzxArray = this.zzdb;
        int n = this.zzdb.length;
        for (int i = 0; i < n; ++i) {
            zzx zzx2 = zzxArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzx2.zzdd)) {
                n2 = (Integer)hashMap.get(zzx2.zzdd);
            }
            hashMap.put(zzx2.zzdd, n2 + 1);
        }
        this.zzdd = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzdd == null || this.zzdd.isEmpty()) {
            this.zzdd = "und";
        }
        return this.zzdd;
    }

    @Override
    public String getValue() {
        if (this.zzdb.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzdb[0].zzdm);
        for (int i = 1; i < this.zzdb.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzdb[i].zzdm);
        }
        return stringBuilder.toString();
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzdb.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n;
                int n2;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzdb.length; ++i) {
                    zzr zzr2 = textBlock.zzdb[0].zzdj;
                    zzr zzr3 = textBlock.zzdb[i].zzdj;
                    n2 = -zzr2.left;
                    n = -zzr2.top;
                    double d = Math.sin(Math.toRadians(zzr2.zzdh));
                    double d2 = Math.cos(Math.toRadians(zzr2.zzdh));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzr3.left, zzr3.top);
                    pointArray2[0].offset(n2, n);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzr3.width, n8);
                    pointArray2[2] = new Point(n7 + zzr3.width, n8 + zzr3.height);
                    pointArray2[3] = new Point(n7, n8 + zzr3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n3 = Math.min(n3, point.x);
                        n4 = Math.max(n4, point.x);
                        n5 = Math.min(n5, point.y);
                        n6 = Math.max(n6, point.y);
                    }
                }
                zzr zzr4 = textBlock.zzdb[0].zzdj;
                n = n6;
                n2 = n4;
                int n9 = n5;
                int n10 = n3;
                int n11 = zzr4.left;
                int n12 = zzr4.top;
                double d = Math.sin(Math.toRadians(zzr4.zzdh));
                double d3 = Math.cos(Math.toRadians(zzr4.zzdh));
                Point[] pointArray = new Point[4];
                Point[] pointArray4 = pointArray;
                pointArray[0] = new Point(n10, n9);
                pointArray4[1] = new Point(n2, n9);
                pointArray4[2] = new Point(n2, n);
                pointArray4[3] = new Point(n10, n);
                for (int i = 0; i < 4; ++i) {
                    int n13 = (int)((double)pointArray4[i].x * d3 - (double)pointArray4[i].y * d);
                    int n14 = (int)((double)pointArray4[i].x * d + (double)pointArray4[i].y * d3);
                    pointArray4[i].x = n13;
                    pointArray4[i].y = n14;
                    pointArray4[i].offset(n11, n12);
                }
                textBlock.cornerPoints = pointArray4;
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzdb.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzdc == null) {
            textBlock.zzdc = new ArrayList<Line>(textBlock.zzdb.length);
            zzx[] zzxArray = textBlock.zzdb;
            int n = textBlock.zzdb.length;
            for (int i = 0; i < n; ++i) {
                zzx zzx2 = zzxArray[i];
                textBlock.zzdc.add(new Line(zzx2));
            }
        }
        return textBlock.zzdc;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzde == null) {
            this.zzde = zzc.zza(this);
        }
        return this.zzde;
    }
}

