/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.vision.zzj;
import com.google.android.gms.internal.vision.zzk;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzc;
import com.google.android.gms.vision.face.internal.client.zze;
import com.google.android.gms.vision.face.internal.client.zzg;
import com.google.android.gms.vision.face.internal.client.zzh;
import java.nio.ByteBuffer;

public final class zza
extends zzj<zze> {
    private final zzc zzbw;

    public zza(Context context, zzc zzc2) {
        super(context, "FaceNativeHandle");
        this.zzbw = zzc2;
        this.zzh();
    }

    public final Face[] zzb(ByteBuffer byteBuffer, zzk zzk2) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = ObjectWrapper.wrap((Object)byteBuffer);
            faceParcelArray = ((zze)this.zzh()).zzc((IObjectWrapper)faceArray, zzk2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            Landmark[] landmarkArray;
            FaceParcel faceParcel = faceParcelArray[i];
            int n = faceParcel.id;
            PointF pointF = new PointF(faceParcel.centerX, faceParcel.centerY);
            float f = faceParcel.width;
            float f2 = faceParcel.height;
            float f3 = faceParcel.zzbx;
            float f4 = faceParcel.zzby;
            FaceParcel faceParcel2 = faceParcel;
            LandmarkParcel[] landmarkParcelArray = faceParcel2.zzbz;
            if (faceParcel2.zzbz == null) {
                landmarkArray = new Landmark[]{};
            } else {
                landmarkArray = new Landmark[landmarkParcelArray.length];
                for (int j = 0; j < landmarkParcelArray.length; ++j) {
                    LandmarkParcel landmarkParcel = landmarkParcelArray[j];
                    landmarkArray[j] = new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
                }
            }
            faceArray[i] = new Face(n, pointF, f, f2, f3, f4, landmarkArray, faceParcel.zzca, faceParcel.zzcb, faceParcel.zzcc);
        }
        return faceArray;
    }

    public final boolean zzd(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zze)this.zzh()).zzd(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected final void zze() throws RemoteException {
        ((zze)this.zzh()).zzf();
    }

    protected final /* synthetic */ Object zza(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.LoadingException {
        IInterface iInterface;
        zzg zzg2;
        Context context2 = context;
        DynamiteModule dynamiteModule2 = dynamiteModule;
        zza zza2 = this;
        IBinder iBinder = dynamiteModule2.instantiate("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator");
        if ((iBinder == null ? null : (zzg2 = (iInterface = iBinder.queryLocalInterface("com.google.android.gms.vision.face.internal.client.INativeFaceDetectorCreator")) instanceof zzg ? (zzg)iInterface : new zzh(iBinder))) == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context2);
        return zzg2.zza(iObjectWrapper, zza2.zzbw);
    }
}

