/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdkv;
import com.google.android.gms.internal.zzdkx;
import com.google.android.gms.internal.zzdld;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzdkx zza;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzdkx zzdkx2) {
        this.zza = zzdkx2;
    }

    public final void release() {
        super.release();
        this.zza.zzc();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzdld zzdld2 = zzdld.zza((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zza.zza(frame.getBitmap(), zzdld2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zza.zza(byteBuffer, zzdld2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zza.zzb();
    }

    /* synthetic */ BarcodeDetector(zzdkx zzdkx2, zzc zzc2) {
        this(zzdkx2);
    }

    public static class Builder {
        private Context zza;
        private zzdkv zzb;

        public Builder(Context context) {
            this.zza = context;
            this.zzb = new zzdkv();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzb.zza = n;
            return this;
        }

        public BarcodeDetector build() {
            zzdkx zzdkx2 = new zzdkx(this.zza, this.zzb);
            return new BarcodeDetector(zzdkx2, null);
        }
    }
}

