/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdim;
import com.google.android.gms.internal.zzdio;
import com.google.android.gms.internal.zzdiu;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzdio zzktu;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzdio zzdio2) {
        this.zzktu = zzdio2;
    }

    public final void release() {
        super.release();
        this.zzktu.zzbji();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzdiu zzdiu2 = zzdiu.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzktu.zza(frame.getBitmap(), zzdiu2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzktu.zza(byteBuffer, zzdiu2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzktu.isOperational();
    }

    /* synthetic */ BarcodeDetector(zzdio zzdio2, zzc zzc2) {
        this(zzdio2);
    }

    public static class Builder {
        private Context mContext;
        private zzdim zzktv;

        public Builder(Context context) {
            this.mContext = context;
            this.zzktv = new zzdim();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzktv.zzktw = n;
            return this;
        }

        public BarcodeDetector build() {
            zzdio zzdio2 = new zzdio(this.mContext, this.zzktv);
            return new BarcodeDetector(zzdio2, null);
        }
    }
}

