/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzgi;
import com.google.android.gms.internal.vision.zzie;
import com.google.android.gms.internal.vision.zzik;
import com.google.android.gms.internal.vision.zzjz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzif
extends zzgi<Integer>
implements zzik<Integer>,
zzjz,
RandomAccess {
    private static final zzif zzyv = new zzif(new int[0], 0);
    private int[] zzyw;
    private int size;

    public static zzif zzhg() {
        return zzyv;
    }

    zzif() {
        this(new int[10], 0);
    }

    private zzif(int[] nArray, int n) {
        this.zzyw = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzek();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyw, n2, this.zzyw, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzif)) {
            return super.equals(object);
        }
        zzif zzif2 = (zzif)object;
        if (this.size != zzif2.size) {
            return false;
        }
        int[] nArray = zzif2.zzyw;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyw[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzyw[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzal(n);
        return this.zzyw[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.zzyw[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbs(int n) {
        this.zzek();
        if (this.size == this.zzyw.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyw, 0, nArray, 0, this.size);
            this.zzyw = nArray;
        }
        this.zzyw[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzek();
        zzie.checkNotNull(collection);
        if (!(collection instanceof zzif)) {
            return super.addAll(collection);
        }
        zzif zzif2 = (zzif)collection;
        if (zzif2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzif2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzif2.size;
        if (n > this.zzyw.length) {
            this.zzyw = Arrays.copyOf(this.zzyw, n);
        }
        System.arraycopy(zzif2.zzyw, 0, this.zzyw, this.size, zzif2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzek();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyw[i])) continue;
            System.arraycopy(this.zzyw, i + 1, this.zzyw, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzal(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzam(n));
        }
    }

    private final String zzam(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        int n2 = (Integer)object;
        zzif zzif2 = this;
        zzif2.zzek();
        zzif2.zzal(n);
        int n3 = zzif2.zzyw[n];
        zzif2.zzyw[n] = n2;
        return n3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzif zzif2 = this;
        zzif2.zzek();
        zzif2.zzal(n);
        int n2 = zzif2.zzyw[n];
        if (n < zzif2.size - 1) {
            System.arraycopy(zzif2.zzyw, n + 1, zzif2.zzyw, n, zzif2.size - n - 1);
        }
        --zzif2.size;
        ++zzif2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        int n2 = (Integer)object;
        zzif zzif2 = this;
        zzif2.zzek();
        if (n < 0 || n > zzif2.size) {
            throw new IndexOutOfBoundsException(zzif2.zzam(n));
        }
        if (zzif2.size < zzif2.zzyw.length) {
            System.arraycopy(zzif2.zzyw, n, zzif2.zzyw, n + 1, zzif2.size - n);
        } else {
            int[] nArray = new int[zzif2.size * 3 / 2 + 1];
            System.arraycopy(zzif2.zzyw, 0, nArray, 0, n);
            System.arraycopy(zzif2.zzyw, n, nArray, n + 1, zzif2.size - n);
            zzif2.zzyw = nArray;
        }
        zzif2.zzyw[n] = n2;
        ++zzif2.size;
        ++zzif2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzbs((Integer)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzik zzan(int n) {
        int n2 = n;
        zzif zzif2 = this;
        if (n2 < zzif2.size) {
            throw new IllegalArgumentException();
        }
        return new zzif(Arrays.copyOf(zzif2.zzyw, n2), zzif2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzyv.zzej();
    }
}

