/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzgi;
import com.google.android.gms.internal.vision.zzie;
import com.google.android.gms.internal.vision.zzik;
import com.google.android.gms.internal.vision.zzjz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgq
extends zzgi<Boolean>
implements zzik<Boolean>,
zzjz,
RandomAccess {
    private static final zzgq zzto = new zzgq(new boolean[0], 0);
    private boolean[] zztp;
    private int size;

    zzgq() {
        this(new boolean[10], 0);
    }

    private zzgq(boolean[] blArray, int n) {
        this.zztp = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzek();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zztp, n2, this.zztp, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgq)) {
            return super.equals(object);
        }
        zzgq zzgq2 = (zzgq)object;
        if (this.size != zzgq2.size) {
            return false;
        }
        boolean[] blArray = zzgq2.zztp;
        for (int i = 0; i < this.size; ++i) {
            if (this.zztp[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzie.zzm(this.zztp[i]);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Boolean)) {
            return -1;
        }
        boolean bl = (Boolean)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zztp[i] != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzek();
        if (this.size == this.zztp.length) {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zztp, 0, blArray, 0, this.size);
            this.zztp = blArray;
        }
        this.zztp[this.size++] = bl;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzek();
        zzie.checkNotNull(collection);
        if (!(collection instanceof zzgq)) {
            return super.addAll(collection);
        }
        zzgq zzgq2 = (zzgq)collection;
        if (zzgq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgq2.size;
        if (n > this.zztp.length) {
            this.zztp = Arrays.copyOf(this.zztp, n);
        }
        System.arraycopy(zzgq2.zztp, 0, this.zztp, this.size, zzgq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzek();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zztp[i])) continue;
            System.arraycopy(this.zztp, i + 1, this.zztp, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzal(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzam(n));
        }
    }

    private final String zzam(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        boolean bl = (Boolean)object;
        zzgq zzgq2 = this;
        zzgq2.zzek();
        zzgq2.zzal(n);
        boolean bl2 = zzgq2.zztp[n];
        zzgq2.zztp[n] = bl;
        return bl2;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgq zzgq2 = this;
        zzgq2.zzek();
        zzgq2.zzal(n);
        boolean bl = zzgq2.zztp[n];
        if (n < zzgq2.size - 1) {
            System.arraycopy(zzgq2.zztp, n + 1, zzgq2.zztp, n, zzgq2.size - n - 1);
        }
        --zzgq2.size;
        ++zzgq2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        boolean bl = (Boolean)object;
        zzgq zzgq2 = this;
        zzgq2.zzek();
        if (n < 0 || n > zzgq2.size) {
            throw new IndexOutOfBoundsException(zzgq2.zzam(n));
        }
        if (zzgq2.size < zzgq2.zztp.length) {
            System.arraycopy(zzgq2.zztp, n, zzgq2.zztp, n + 1, zzgq2.size - n);
        } else {
            boolean[] blArray = new boolean[zzgq2.size * 3 / 2 + 1];
            System.arraycopy(zzgq2.zztp, 0, blArray, 0, n);
            System.arraycopy(zzgq2.zztp, n, blArray, n + 1, zzgq2.size - n);
            zzgq2.zztp = blArray;
        }
        zzgq2.zztp[n] = bl;
        ++zzgq2.size;
        ++zzgq2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.addBoolean((Boolean)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzik zzan(int n) {
        int n2 = n;
        zzgq zzgq2 = this;
        if (n2 < zzgq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgq(Arrays.copyOf(zzgq2.zztp, n2), zzgq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgq zzgq2 = this;
        zzgq2.zzal(n);
        return zzgq2.zztp[n];
    }

    static {
        zzto.zzej();
    }
}

