/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzcz;
import com.google.android.gms.internal.vision.zzde;
import com.google.android.gms.internal.vision.zzdr;
import com.google.android.gms.internal.vision.zzds;
import com.google.android.gms.internal.vision.zzdt;
import com.google.android.gms.internal.vision.zzdu;
import com.google.android.gms.internal.vision.zzdv;
import com.google.android.gms.internal.vision.zzdx;
import com.google.android.gms.internal.vision.zzea;
import com.google.android.gms.internal.vision.zzec;
import com.google.android.gms.internal.vision.zzfc;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class zzdp<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Object zzmf = new Object();
    @NullableDecl
    private transient Object zzmg;
    @NullableDecl
    transient int[] zzmh;
    @NullableDecl
    transient Object[] zzmi;
    @NullableDecl
    transient Object[] zzmj;
    private transient int zzmk;
    private transient int size;
    @NullableDecl
    private transient Set<K> zzml;
    @NullableDecl
    private transient Set<Map.Entry<K, V>> zzmm;
    @NullableDecl
    private transient Collection<V> zzmn;

    zzdp() {
        zzdp zzdp2 = this;
        zzde.checkArgument(true, "Expected size must be >= 0");
        zzdp2.zzmk = zzfc.zzc(3, 1, 0x3FFFFFFF);
    }

    final boolean zzce() {
        return this.zzmg == null;
    }

    @NullableDecl
    final Map<K, V> zzcf() {
        if (this.zzmg instanceof Map) {
            return (Map)this.zzmg;
        }
        return null;
    }

    private final void zzs(int n) {
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        this.zzmk = zzea.zzb(this.zzmk, n2, 31);
    }

    private final int zzcg() {
        return (1 << (this.zzmk & 0x1F)) - 1;
    }

    final void zzch() {
        this.zzmk += 32;
    }

    @Override
    @NullableDecl
    public final V put(@NullableDecl K k, @NullableDecl V v) {
        int n;
        int n2;
        Map<K, V> map;
        int n3;
        int n4;
        int n5;
        int n6;
        zzdp zzdp2;
        if (this.zzce()) {
            zzdp2 = this;
            zzde.checkState(zzdp2.zzce(), "Arrays already allocated");
            n5 = n6 = zzdp2.zzmk;
            n4 = Math.max(n5 + 1, 2);
            int n7 = Integer.highestOneBit(n4);
            n3 = Math.max(4, n4 > (int)(1.0 * (double)n7) && (n7 <<= 1) <= 0 ? 0x40000000 : n7);
            zzdp2.zzmg = zzea.zzv(n3);
            zzdp2.zzs(n3 - 1);
            zzdp2.zzmh = new int[n6];
            zzdp2.zzmi = new Object[n6];
            zzdp2.zzmj = new Object[n6];
        }
        if ((map = this.zzcf()) != null) {
            return map.put(k, v);
        }
        int[] nArray = this.zzmh;
        Object[] objectArray = this.zzmi;
        Object[] objectArray2 = this.zzmj;
        int n8 = this.size;
        int n9 = n8 + 1;
        int n10 = zzec.zzf(k);
        int n11 = n10 & (n2 = this.zzcg());
        int n12 = zzea.zza(this.zzmg, n11);
        if (n12 == 0) {
            if (n9 > n2) {
                n2 = this.zza(n2, zzea.zzw(n2), n10, n8);
            } else {
                zzea.zza(this.zzmg, n11, n8 + 1);
            }
        } else {
            int n13;
            int n14 = n10 & ~n2;
            int n15 = 0;
            do {
                int n16;
                if (((n13 = nArray[n16 = n12 - 1]) & ~n2) == n14 && zzcz.equal(k, objectArray[n16])) {
                    Object object = objectArray2[n16];
                    objectArray2[n16] = v;
                    return (V)object;
                }
                n12 = n13 & n2;
                ++n15;
            } while (n12 != 0);
            if (n15 >= 9) {
                zzdp2 = this;
                n5 = zzdp2.zzcg() + 1;
                LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>(n5, 1.0f);
                n3 = zzdp2.zzci();
                while (n3 >= 0) {
                    linkedHashMap.put(zzdp2.zzmi[n3], zzdp2.zzmj[n3]);
                    n3 = zzdp2.zzt(n3);
                }
                zzdp2.zzmg = linkedHashMap;
                zzdp2.zzmh = null;
                zzdp2.zzmi = null;
                zzdp2.zzmj = null;
                zzdp2.zzch();
                return linkedHashMap.put(k, v);
            }
            if (n9 > n2) {
                n2 = this.zza(n2, zzea.zzw(n2), n10, n8);
            } else {
                nArray[n16] = zzea.zzb(n13, n8 + 1, n2);
            }
        }
        n6 = n9;
        zzdp2 = this;
        n3 = zzdp2.zzmh.length;
        if (n6 > n3 && (n5 = Math.min(0x3FFFFFFF, n3 + Math.max(1, n3 >>> 1) | 1)) != n3) {
            n = n5;
            zzdp zzdp3 = zzdp2;
            zzdp3.zzmh = Arrays.copyOf(zzdp3.zzmh, n);
            zzdp3.zzmi = Arrays.copyOf(zzdp3.zzmi, n);
            zzdp3.zzmj = Arrays.copyOf(zzdp3.zzmj, n);
        }
        n = n2;
        n4 = n10;
        V v2 = v;
        K k2 = k;
        n6 = n8;
        zzdp2 = this;
        zzdp2.zzmh[n6] = zzea.zzb(n4, 0, n);
        zzdp2.zzmi[n6] = k2;
        zzdp2.zzmj[n6] = v2;
        this.size = n9;
        this.zzch();
        return null;
    }

    private final int zza(int n, int n2, int n3, int n4) {
        Object object = zzea.zzv(n2);
        int n5 = n2 - 1;
        if (n4 != 0) {
            zzea.zza(object, n3 & n5, n4 + 1);
        }
        Object object2 = this.zzmg;
        int[] nArray = this.zzmh;
        for (int i = 0; i <= n; ++i) {
            int n6 = zzea.zza(object2, i);
            while (n6 != 0) {
                int n7 = n6 - 1;
                int n8 = nArray[n7];
                int n9 = n8 & ~n | i;
                int n10 = n9 & n5;
                int n11 = zzea.zza(object, n10);
                zzea.zza(object, n10, n6);
                nArray[n7] = zzea.zzb(n9, n11, n5);
                n6 = n8 & n;
            }
        }
        this.zzmg = object;
        this.zzs(n5);
        return n5;
    }

    private final int indexOf(@NullableDecl Object object) {
        int n;
        int n2;
        if (this.zzce()) {
            return -1;
        }
        int n3 = zzec.zzf(object);
        int n4 = zzea.zza(this.zzmg, n3 & (n2 = this.zzcg()));
        if (n4 == 0) {
            return -1;
        }
        int n5 = n3 & ~n2;
        do {
            int n6;
            if (((n = this.zzmh[n6 = n4 - 1]) & ~n2) != n5 || !zzcz.equal(object, this.zzmi[n6])) continue;
            return n6;
        } while ((n4 = n & n2) != 0);
        return -1;
    }

    @Override
    public final boolean containsKey(@NullableDecl Object object) {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.containsKey(object);
        }
        return this.indexOf(object) != -1;
    }

    @Override
    public final V get(@NullableDecl Object object) {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.get(object);
        }
        int n = this.indexOf(object);
        if (n == -1) {
            return null;
        }
        return (V)this.zzmj[n];
    }

    @Override
    @NullableDecl
    public final V remove(@NullableDecl Object object) {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.remove(object);
        }
        Object object2 = this.zze(object);
        if (object2 == zzmf) {
            return null;
        }
        return (V)object2;
    }

    @NullableDecl
    private final Object zze(@NullableDecl Object object) {
        if (this.zzce()) {
            return zzmf;
        }
        int n = this.zzcg();
        int n2 = zzea.zza(object, null, n, this.zzmg, this.zzmh, this.zzmi, null);
        if (n2 == -1) {
            return zzmf;
        }
        Object object2 = this.zzmj[n2];
        this.zzf(n2, n);
        --this.size;
        this.zzch();
        return object2;
    }

    final void zzf(int n, int n2) {
        int n3 = this.size() - 1;
        if (n < n3) {
            int n4;
            int n5;
            int n6;
            Object object;
            this.zzmi[n] = object = this.zzmi[n3];
            this.zzmj[n] = this.zzmj[n3];
            this.zzmi[n3] = null;
            this.zzmj[n3] = null;
            this.zzmh[n] = this.zzmh[n3];
            this.zzmh[n3] = 0;
            int n7 = zzec.zzf(object) & n2;
            int n8 = zzea.zza(this.zzmg, n7);
            if (n8 == (n6 = n3 + 1)) {
                zzea.zza(this.zzmg, n7, n + 1);
                return;
            }
            while ((n8 = (n5 = this.zzmh[n4 = n8 - 1]) & n2) != n6) {
            }
            this.zzmh[n4] = zzea.zzb(n5, n + 1, n2);
            return;
        }
        this.zzmi[n] = null;
        this.zzmj[n] = null;
        this.zzmh[n] = 0;
    }

    final int zzci() {
        if (this.isEmpty()) {
            return -1;
        }
        return 0;
    }

    final int zzt(int n) {
        if (n + 1 < this.size) {
            return n + 1;
        }
        return -1;
    }

    static int zzg(int n, int n2) {
        return n - 1;
    }

    @Override
    public final Set<K> keySet() {
        if (this.zzml == null) {
            zzdp zzdp2 = this;
            this.zzml = new zzdv(zzdp2);
            return this.zzml;
        }
        return this.zzml;
    }

    final Iterator<K> zzcj() {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.keySet().iterator();
        }
        return new zzds(this);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.zzmm == null) {
            zzdp zzdp2 = this;
            this.zzmm = new zzdt(zzdp2);
            return this.zzmm;
        }
        return this.zzmm;
    }

    final Iterator<Map.Entry<K, V>> zzck() {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.entrySet().iterator();
        }
        return new zzdr(this);
    }

    @Override
    public final int size() {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.size();
        }
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsValue(@NullableDecl Object object) {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.containsValue(object);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!zzcz.equal(object, this.zzmj[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Collection<V> values() {
        if (this.zzmn == null) {
            zzdp zzdp2 = this;
            this.zzmn = new zzdx(zzdp2);
            return this.zzmn;
        }
        return this.zzmn;
    }

    final Iterator<V> zzcl() {
        Map<K, V> map = this.zzcf();
        if (map != null) {
            return map.values().iterator();
        }
        return new zzdu(this);
    }

    @Override
    public final void clear() {
        if (this.zzce()) {
            return;
        }
        this.zzch();
        Map<K, V> map = this.zzcf();
        if (map != null) {
            this.zzmk = zzfc.zzc(this.size(), 3, 0x3FFFFFFF);
            map.clear();
            this.zzmg = null;
            this.size = 0;
            return;
        }
        Arrays.fill(this.zzmi, 0, this.size, null);
        Arrays.fill(this.zzmj, 0, this.size, null);
        Object object = this.zzmg;
        if (object instanceof byte[]) {
            Arrays.fill((byte[])object, (byte)0);
        } else if (object instanceof short[]) {
            Arrays.fill((short[])object, (short)0);
        } else {
            Arrays.fill((int[])object, 0);
        }
        Arrays.fill(this.zzmh, 0, this.size, 0);
        this.size = 0;
    }

    static /* synthetic */ int zza(zzdp zzdp2) {
        return zzdp2.zzmk;
    }

    static /* synthetic */ Object zza(zzdp zzdp2, Object object) {
        return zzdp2.zze(object);
    }

    static /* synthetic */ Object zzcm() {
        return zzmf;
    }

    static /* synthetic */ int zzb(zzdp zzdp2, Object object) {
        return zzdp2.indexOf(object);
    }

    static /* synthetic */ int zzb(zzdp zzdp2) {
        return zzdp2.zzcg();
    }

    static /* synthetic */ Object zzc(zzdp zzdp2) {
        return zzdp2.zzmg;
    }

    static /* synthetic */ int zzd(zzdp zzdp2) {
        return zzdp2.size--;
    }
}

