/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfc;
import com.google.android.gms.internal.vision.zzgy;
import com.google.android.gms.internal.vision.zzhe;
import com.google.android.gms.internal.vision.zzit;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgg
extends zzfc<Double>
implements zzhe<Double>,
zzit,
RandomAccess {
    private static final zzgg zzti = new zzgg(new double[0], 0);
    private double[] zztj;
    private int size;

    zzgg() {
        this(new double[10], 0);
    }

    private zzgg(double[] dArray, int n) {
        this.zztj = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdr();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zztj, n2, this.zztj, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgg)) {
            return super.equals(object);
        }
        zzgg zzgg2 = (zzgg)object;
        if (this.size != zzgg2.size) {
            return false;
        }
        double[] dArray = zzgg2.zztj;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zztj[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zztj[i]);
            n = n * 31 + zzgy.zzab(l);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Double)) {
            return -1;
        }
        double d = (Double)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zztj[i] != d) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzdr();
        if (this.size == this.zztj.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zztj, 0, dArray, 0, this.size);
            this.zztj = dArray;
        }
        this.zztj[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzdr();
        zzgy.checkNotNull(collection);
        if (!(collection instanceof zzgg)) {
            return super.addAll(collection);
        }
        zzgg zzgg2 = (zzgg)collection;
        if (zzgg2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgg2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgg2.size;
        if (n > this.zztj.length) {
            this.zztj = Arrays.copyOf(this.zztj, n);
        }
        System.arraycopy(zzgg2.zztj, 0, this.zztj, this.size, zzgg2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdr();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zztj[i])) continue;
            System.arraycopy(this.zztj, i + 1, this.zztj, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgg zzgg2 = this;
        zzgg2.zzdr();
        zzgg2.zzaf(n);
        double d3 = zzgg2.zztj[n];
        zzgg2.zztj[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgg zzgg2 = this;
        zzgg2.zzdr();
        zzgg2.zzaf(n);
        double d = zzgg2.zztj[n];
        if (n < zzgg2.size - 1) {
            System.arraycopy(zzgg2.zztj, n + 1, zzgg2.zztj, n, zzgg2.size - n - 1);
        }
        --zzgg2.size;
        ++zzgg2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgg zzgg2 = this;
        zzgg2.zzdr();
        if (n < 0 || n > zzgg2.size) {
            throw new IndexOutOfBoundsException(zzgg2.zzag(n));
        }
        if (zzgg2.size < zzgg2.zztj.length) {
            System.arraycopy(zzgg2.zztj, n, zzgg2.zztj, n + 1, zzgg2.size - n);
        } else {
            double[] dArray = new double[zzgg2.size * 3 / 2 + 1];
            System.arraycopy(zzgg2.zztj, 0, dArray, 0, n);
            System.arraycopy(zzgg2.zztj, n, dArray, n + 1, zzgg2.size - n);
            zzgg2.zztj = dArray;
        }
        zzgg2.zztj[n] = d2;
        ++zzgg2.size;
        ++zzgg2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzc(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzhe zzah(int n) {
        int n2 = n;
        zzgg zzgg2 = this;
        if (n2 < zzgg2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgg(Arrays.copyOf(zzgg2.zztj, n2), zzgg2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgg zzgg2 = this;
        zzgg2.zzaf(n);
        return zzgg2.zztj[n];
    }

    static {
        zzti.zzdq();
    }
}

