/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzex;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzio;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzff
extends zzex<Boolean>
implements zzgz<Boolean>,
zzio,
RandomAccess {
    private static final zzff zzry = new zzff(new boolean[0], 0);
    private boolean[] zzrz;
    private int size;

    zzff() {
        this(new boolean[10], 0);
    }

    private zzff(boolean[] blArray, int n) {
        this.zzrz = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzrz, n2, this.zzrz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzff)) {
            return super.equals(object);
        }
        zzff zzff2 = (zzff)object;
        if (this.size != zzff2.size) {
            return false;
        }
        boolean[] blArray = zzff2.zzrz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzrz[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzgt.zzm(this.zzrz[i]);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Boolean)) {
            return -1;
        }
        boolean bl = (Boolean)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzrz[i] != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzdq();
        if (this.size == this.zzrz.length) {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzrz, 0, blArray, 0, this.size);
            this.zzrz = blArray;
        }
        this.zzrz[this.size++] = bl;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzdq();
        zzgt.checkNotNull(collection);
        if (!(collection instanceof zzff)) {
            return super.addAll(collection);
        }
        zzff zzff2 = (zzff)collection;
        if (zzff2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzff2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzff2.size;
        if (n > this.zzrz.length) {
            this.zzrz = Arrays.copyOf(this.zzrz, n);
        }
        System.arraycopy(zzff2.zzrz, 0, this.zzrz, this.size, zzff2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzrz[i])) continue;
            System.arraycopy(this.zzrz, i + 1, this.zzrz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzff zzff2 = this;
        zzff2.zzdq();
        zzff2.zzaf(n);
        boolean bl3 = zzff2.zzrz[n];
        zzff2.zzrz[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzff zzff2 = this;
        zzff2.zzdq();
        zzff2.zzaf(n);
        boolean bl = zzff2.zzrz[n];
        if (n < zzff2.size - 1) {
            System.arraycopy(zzff2.zzrz, n + 1, zzff2.zzrz, n, zzff2.size - n - 1);
        }
        --zzff2.size;
        ++zzff2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzff zzff2 = this;
        zzff2.zzdq();
        if (n < 0 || n > zzff2.size) {
            throw new IndexOutOfBoundsException(zzff2.zzag(n));
        }
        if (zzff2.size < zzff2.zzrz.length) {
            System.arraycopy(zzff2.zzrz, n, zzff2.zzrz, n + 1, zzff2.size - n);
        } else {
            boolean[] blArray = new boolean[zzff2.size * 3 / 2 + 1];
            System.arraycopy(zzff2.zzrz, 0, blArray, 0, n);
            System.arraycopy(zzff2.zzrz, n, blArray, n + 1, zzff2.size - n);
            zzff2.zzrz = blArray;
        }
        zzff2.zzrz[n] = bl2;
        ++zzff2.size;
        ++zzff2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Boolean bl = (Boolean)object;
        this.addBoolean(bl);
        return true;
    }

    @Override
    public final /* synthetic */ zzgz zzah(int n) {
        int n2 = n;
        zzff zzff2 = this;
        if (n2 < zzff2.size) {
            throw new IllegalArgumentException();
        }
        return new zzff(Arrays.copyOf(zzff2.zzrz, n2), zzff2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzff zzff2 = this;
        zzff2.zzaf(n);
        return zzff2.zzrz[n];
    }

    static {
        zzry.zzdp();
    }
}

