/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfe;
import com.google.android.gms.internal.vision.zzhf;
import com.google.android.gms.internal.vision.zzjm;
import com.google.android.gms.internal.vision.zzjt;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzjl {
    private final ByteBuffer zzsw;
    private zzfe zzade;
    private int zzadf;

    private zzjl(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzjl(ByteBuffer byteBuffer) {
        this.zzsw = byteBuffer;
        this.zzsw.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzjl zzk(byte[] byArray) {
        return zzjl.zzl(byArray, 0, byArray.length);
    }

    public static zzjl zzl(byte[] byArray, int n, int n2) {
        return new zzjl(byArray, 0, n2);
    }

    public final void zza(int n, float f) throws IOException {
        this.zzd(n, 5);
        float f2 = f;
        int n2 = Float.floatToIntBits(f2);
        zzjl zzjl2 = this;
        if (zzjl2.zzsw.remaining() < 4) {
            throw new zzjm(zzjl2.zzsw.position(), zzjl2.zzsw.limit());
        }
        zzjl2.zzsw.putInt(n2);
    }

    public final void zzi(int n, long l) throws IOException {
        this.zzd(n, 0);
        long l2 = l;
        this.zzq(l2);
    }

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, 0);
        int n3 = n2;
        zzjl zzjl2 = this;
        if (n3 >= 0) {
            zzjl2.zzbv(n3);
            return;
        }
        zzjl2.zzq(n3);
    }

    public final void zzb(int n, boolean bl) throws IOException {
        this.zzd(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzjl zzjl2 = this;
        if (!zzjl2.zzsw.hasRemaining()) {
            throw new zzjm(zzjl2.zzsw.position(), zzjl2.zzsw.limit());
        }
        zzjl2.zzsw.put(by);
    }

    public final void zza(int n, String string) throws IOException {
        this.zzd(n, 2);
        String string2 = string;
        zzjl zzjl2 = this;
        try {
            int n2 = zzjl.zzbd(string2.length());
            int n3 = zzjl.zzbd(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzjl2.zzsw.position();
                if (zzjl2.zzsw.remaining() < n2) {
                    throw new zzjm(n4 + n2, zzjl2.zzsw.limit());
                }
                zzjl2.zzsw.position(n4 + n2);
                zzjl.zzd(string2, zzjl2.zzsw);
                int n5 = zzjl2.zzsw.position();
                zzjl2.zzsw.position(n4);
                zzjl2.zzbv(n5 - n4 - n2);
                zzjl2.zzsw.position(n5);
                return;
            }
            zzjl2.zzbv(zzjl.zza(string2));
            zzjl.zzd(string2, zzjl2.zzsw);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzjm zzjm2 = new zzjm(zzjl2.zzsw.position(), zzjl2.zzsw.limit());
            zzjm2.initCause(bufferOverflowException);
            throw zzjm2;
        }
    }

    public final void zza(int n, zzjt zzjt2) throws IOException {
        this.zzd(n, 2);
        zzjt zzjt3 = zzjt2;
        zzjl zzjl2 = this;
        zzjt zzjt4 = zzjt3;
        if (zzjt4.zzadp < 0) {
            zzjt4.zzeq();
        }
        zzjl2.zzbv(zzjt4.zzadp);
        zzjt3.zza(zzjl2);
    }

    public final void zze(int n, zzhf zzhf2) throws IOException {
        zzjl zzjl2 = this;
        if (zzjl2.zzade == null) {
            zzjl2.zzade = zzfe.zza(zzjl2.zzsw);
            zzjl2.zzadf = zzjl2.zzsw.position();
        } else if (zzjl2.zzadf != zzjl2.zzsw.position()) {
            zzjl2.zzade.write(zzjl2.zzsw.array(), zzjl2.zzadf, zzjl2.zzsw.position() - zzjl2.zzadf);
            zzjl2.zzadf = zzjl2.zzsw.position();
        }
        zzfe zzfe2 = zzjl2.zzade;
        zzfe2.zza(2, zzhf2);
        zzfe2.flush();
        this.zzadf = this.zzsw.position();
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zzd(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zzd(int n, long l) {
        long l2;
        return zzjl.zzav(n) + (((l2 = l) & 0xFFFFFFFFFFFFFF80L) == 0L ? 1 : ((l2 & 0xFFFFFFFFFFFFC000L) == 0L ? 2 : ((l2 & 0xFFFFFFFFFFE00000L) == 0L ? 3 : ((l2 & 0xFFFFFFFFF0000000L) == 0L ? 4 : ((l2 & 0xFFFFFFF800000000L) == 0L ? 5 : ((l2 & 0xFFFFFC0000000000L) == 0L ? 6 : ((l2 & 0xFFFE000000000000L) == 0L ? 7 : ((l2 & 0xFF00000000000000L) == 0L ? 8 : ((l2 & Long.MIN_VALUE) == 0L ? 9 : 10)))))))));
    }

    public static int zzi(int n, int n2) {
        return zzjl.zzav(n) + zzjl.zzaw(n2);
    }

    public static int zzb(int n, String string) {
        return zzjl.zzav(n) + zzjl.zzn(string);
    }

    public static int zzb(int n, zzjt zzjt2) {
        int n2 = zzjt2.zzeq();
        return zzjl.zzav(n) + (zzjl.zzbd(n2) + n2);
    }

    public static int zzaw(int n) {
        if (n >= 0) {
            return zzjl.zzbd(n);
        }
        return 10;
    }

    public static int zzn(String string) {
        int n = zzjl.zza(string);
        return zzjl.zzbd(n) + n;
    }

    public final void zzea() {
        if (this.zzsw.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzsw.remaining()));
        }
    }

    private final void zzbu(int n) throws IOException {
        byte by = (byte)n;
        zzjl zzjl2 = this;
        if (!zzjl2.zzsw.hasRemaining()) {
            throw new zzjm(zzjl2.zzsw.position(), zzjl2.zzsw.limit());
        }
        zzjl2.zzsw.put(by);
    }

    public final void zzl(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzjl zzjl2 = this;
        if (zzjl2.zzsw.remaining() >= n) {
            zzjl2.zzsw.put(byArray2, 0, n);
            return;
        }
        throw new zzjm(zzjl2.zzsw.position(), zzjl2.zzsw.limit());
    }

    private final void zzd(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzbv(n << 3 | n3);
    }

    public static int zzav(int n) {
        return zzjl.zzbd(n << 3);
    }

    public final void zzbv(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzbu(n);
                return;
            }
            this.zzbu(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzbd(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzq(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzbu((int)l);
                return;
            }
            this.zzbu((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }
}

