/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzef;
import com.google.android.gms.internal.vision.zzga;
import com.google.android.gms.internal.vision.zzge;
import com.google.android.gms.internal.vision.zzhr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzem
extends zzef<Boolean>
implements zzge<Boolean>,
zzhr,
RandomAccess {
    private static final zzem zzrv = new zzem();
    private boolean[] zzrw;
    private int size;

    zzem() {
        this(new boolean[10], 0);
    }

    private zzem(boolean[] blArray, int n) {
        this.zzrw = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzrw, n2, this.zzrw, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzem)) {
            return super.equals(object);
        }
        zzem zzem2 = (zzem)object;
        if (this.size != zzem2.size) {
            return false;
        }
        boolean[] blArray = zzem2.zzrw;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzrw[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzga.zzj(this.zzrw[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzcj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
        if (this.size < this.zzrw.length) {
            System.arraycopy(this.zzrw, n, this.zzrw, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzrw, 0, blArray, 0, n);
            System.arraycopy(this.zzrw, n, blArray, n + 1, this.size - n);
            this.zzrw = blArray;
        }
        this.zzrw[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzcj();
        zzga.checkNotNull(collection);
        if (!(collection instanceof zzem)) {
            return super.addAll(collection);
        }
        zzem zzem2 = (zzem)collection;
        if (zzem2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzem2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzem2.size;
        if (n > this.zzrw.length) {
            this.zzrw = Arrays.copyOf(this.zzrw, n);
        }
        System.arraycopy(zzem2.zzrw, 0, this.zzrw, this.size, zzem2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzrw[i])) continue;
            System.arraycopy(this.zzrw, i + 1, this.zzrw, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzem zzem2 = this;
        zzem2.zzcj();
        zzem2.zzaf(n);
        boolean bl3 = zzem2.zzrw[n];
        zzem2.zzrw[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzem zzem2 = this;
        zzem2.zzcj();
        zzem2.zzaf(n);
        boolean bl = zzem2.zzrw[n];
        if (n < zzem2.size - 1) {
            System.arraycopy(zzem2.zzrw, n + 1, zzem2.zzrw, n, zzem2.size - n);
        }
        --zzem2.size;
        ++zzem2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzge zzah(int n) {
        int n2 = n;
        zzem zzem2 = this;
        if (n2 < zzem2.size) {
            throw new IllegalArgumentException();
        }
        return new zzem(Arrays.copyOf(zzem2.zzrw, n2), zzem2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzem zzem2 = this;
        zzem2.zzaf(n);
        return zzem2.zzrw[n];
    }

    static {
        zzrv.zzci();
    }
}

