/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzbi;
import com.google.android.gms.internal.vision.zzct;
import com.google.android.gms.internal.vision.zzcw;
import com.google.android.gms.internal.vision.zzej;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzcp
extends zzbi<Float>
implements zzcw<Float>,
zzej,
RandomAccess {
    private static final zzcp zzko = new zzcp();
    private float[] zzkp;
    private int size;

    zzcp() {
        this(new float[10], 0);
    }

    private zzcp(float[] fArray, int n) {
        this.zzkp = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzap();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzkp, n2, this.zzkp, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzcp)) {
            return super.equals(object);
        }
        zzcp zzcp2 = (zzcp)object;
        if (this.size != zzcp2.size) {
            return false;
        }
        float[] fArray = zzcp2.zzkp;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzkp[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzkp[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zze(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzap();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
        if (this.size < this.zzkp.length) {
            System.arraycopy(this.zzkp, n, this.zzkp, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzkp, 0, fArray, 0, n);
            System.arraycopy(this.zzkp, n, fArray, n + 1, this.size - n);
            this.zzkp = fArray;
        }
        this.zzkp[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzap();
        zzct.checkNotNull(collection);
        if (!(collection instanceof zzcp)) {
            return super.addAll(collection);
        }
        zzcp zzcp2 = (zzcp)collection;
        if (zzcp2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzcp2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzcp2.size;
        if (n > this.zzkp.length) {
            this.zzkp = Arrays.copyOf(this.zzkp, n);
        }
        System.arraycopy(zzcp2.zzkp, 0, this.zzkp, this.size, zzcp2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzap();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzkp[i]))) continue;
            System.arraycopy(this.zzkp, i + 1, this.zzkp, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzi(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
    }

    private final String zzj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzcp zzcp2 = this;
        zzcp2.zzap();
        zzcp2.zzi(n);
        float f3 = zzcp2.zzkp[n];
        zzcp2.zzkp[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzcp zzcp2 = this;
        zzcp2.zzap();
        zzcp2.zzi(n);
        float f = zzcp2.zzkp[n];
        if (n < zzcp2.size - 1) {
            System.arraycopy(zzcp2.zzkp, n + 1, zzcp2.zzkp, n, zzcp2.size - n);
        }
        --zzcp2.size;
        ++zzcp2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzcw zzk(int n) {
        int n2 = n;
        zzcp zzcp2 = this;
        if (n2 < zzcp2.size) {
            throw new IllegalArgumentException();
        }
        return new zzcp(Arrays.copyOf(zzcp2.zzkp, n2), zzcp2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzcp zzcp2 = this;
        zzcp2.zzi(n);
        return Float.valueOf(zzcp2.zzkp[n]);
    }

    static {
        zzko.zzao();
    }
}

