/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzbi;
import com.google.android.gms.internal.vision.zzct;
import com.google.android.gms.internal.vision.zzcw;
import com.google.android.gms.internal.vision.zzej;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbm
extends zzbi<Boolean>
implements zzcw<Boolean>,
zzej,
RandomAccess {
    private static final zzbm zzgr = new zzbm();
    private boolean[] zzgs;
    private int size;

    zzbm() {
        this(new boolean[10], 0);
    }

    private zzbm(boolean[] blArray, int n) {
        this.zzgs = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzap();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzgs, n2, this.zzgs, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbm)) {
            return super.equals(object);
        }
        zzbm zzbm2 = (zzbm)object;
        if (this.size != zzbm2.size) {
            return false;
        }
        boolean[] blArray = zzbm2.zzgs;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzgs[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzct.zzc(this.zzgs[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzap();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
        if (this.size < this.zzgs.length) {
            System.arraycopy(this.zzgs, n, this.zzgs, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzgs, 0, blArray, 0, n);
            System.arraycopy(this.zzgs, n, blArray, n + 1, this.size - n);
            this.zzgs = blArray;
        }
        this.zzgs[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzap();
        zzct.checkNotNull(collection);
        if (!(collection instanceof zzbm)) {
            return super.addAll(collection);
        }
        zzbm zzbm2 = (zzbm)collection;
        if (zzbm2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbm2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbm2.size;
        if (n > this.zzgs.length) {
            this.zzgs = Arrays.copyOf(this.zzgs, n);
        }
        System.arraycopy(zzbm2.zzgs, 0, this.zzgs, this.size, zzbm2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzap();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzgs[i])) continue;
            System.arraycopy(this.zzgs, i + 1, this.zzgs, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzi(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
    }

    private final String zzj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzbm zzbm2 = this;
        zzbm2.zzap();
        zzbm2.zzi(n);
        boolean bl3 = zzbm2.zzgs[n];
        zzbm2.zzgs[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbm zzbm2 = this;
        zzbm2.zzap();
        zzbm2.zzi(n);
        boolean bl = zzbm2.zzgs[n];
        if (n < zzbm2.size - 1) {
            System.arraycopy(zzbm2.zzgs, n + 1, zzbm2.zzgs, n, zzbm2.size - n);
        }
        --zzbm2.size;
        ++zzbm2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzcw zzk(int n) {
        int n2 = n;
        zzbm zzbm2 = this;
        if (n2 < zzbm2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbm(Arrays.copyOf(zzbm2.zzgs, n2), zzbm2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbm zzbm2 = this;
        zzbm2.zzi(n);
        return zzbm2.zzgs[n];
    }

    static {
        zzgr.zzao();
    }
}

