/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object zzksm = new Object();
    private Camera zzksn;
    private int zzkso = 0;
    private int zzcfy;
    private Size zzksp;
    private float zzksq = 30.0f;
    private int zzksr = 1024;
    private int zzkss = 768;
    private boolean zzkst = false;
    private SurfaceTexture zzksu;
    private boolean zzksv;
    private Thread zzksw;
    private zzb zzksx;
    private Map<byte[], ByteBuffer> zzksy = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzksm;
        synchronized (object) {
            this.stop();
            this.zzksx.release();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.zzksm;
        synchronized (object) {
            if (this.zzksn != null) {
                return this;
            }
            this.zzksn = this.zzbjd();
            this.zzksu = new SurfaceTexture(100);
            this.zzksn.setPreviewTexture(this.zzksu);
            this.zzksv = true;
            this.zzksn.startPreview();
            this.zzksw = new Thread(this.zzksx);
            this.zzksx.setActive(true);
            this.zzksw.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzksm;
        synchronized (object) {
            if (this.zzksn != null) {
                return this;
            }
            this.zzksn = this.zzbjd();
            this.zzksn.setPreviewDisplay(surfaceHolder);
            this.zzksn.startPreview();
            this.zzksw = new Thread(this.zzksx);
            this.zzksx.setActive(true);
            this.zzksw.start();
            this.zzksv = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzksm;
        synchronized (object) {
            this.zzksx.setActive(false);
            if (this.zzksw != null) {
                try {
                    this.zzksw.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzksw = null;
            }
            if (this.zzksn != null) {
                this.zzksn.stopPreview();
                this.zzksn.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzksv) {
                        this.zzksn.setPreviewTexture(null);
                    } else {
                        this.zzksn.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                this.zzksn.release();
                this.zzksn = null;
            }
            this.zzksy.clear();
            return;
        }
    }

    public Size getPreviewSize() {
        return this.zzksp;
    }

    public int getCameraFacing() {
        return this.zzkso;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback) {
        Object object = this.zzksm;
        synchronized (object) {
            if (this.zzksn != null) {
                zzd zzd2 = new zzd(null);
                zzd2.zzktg = shutterCallback;
                zzc zzc2 = new zzc(this, null);
                zzc2.zzktf = pictureCallback;
                this.zzksn.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
            return;
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private final Camera zzbjd() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Camera.CameraInfo cameraInfo;
        block16: {
            int n5 = this.zzkso;
            cameraInfo = new Camera.CameraInfo();
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != n5) continue;
                n4 = i;
                break block16;
            }
            n4 = n3 = -1;
        }
        if (n4 == -1) {
            throw new IOException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n3);
        zze zze2 = CameraSource.zza(camera, this.zzksr, this.zzkss);
        if (zze2 == null) {
            throw new IOException("Could not find suitable preview size.");
        }
        Size size = zze2.zzbjf();
        this.zzksp = zze2.zzbje();
        int[] nArray = CameraSource.zza(camera, this.zzksq);
        if (nArray == null) {
            throw new IOException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        if (size != null) {
            parameters.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters.setPreviewSize(this.zzksp.getWidth(), this.zzksp.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        int n6 = n3;
        Camera.Parameters parameters2 = parameters;
        cameraInfo = camera;
        CameraSource cameraSource = this;
        WindowManager windowManager = (WindowManager)cameraSource.mContext.getSystemService("window");
        int n7 = 0;
        int n8 = windowManager.getDefaultDisplay().getRotation();
        switch (n8) {
            case 0: {
                n7 = 0;
                break;
            }
            case 1: {
                n7 = 90;
                break;
            }
            case 2: {
                n7 = 180;
                break;
            }
            case 3: {
                n7 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n8).toString());
            }
        }
        Camera.CameraInfo cameraInfo2 = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n6, (Camera.CameraInfo)cameraInfo2);
        if (cameraInfo2.facing == 1) {
            n2 = (cameraInfo2.orientation + n7) % 360;
            n = (360 - n2) % 360;
        } else {
            n = n2 = (cameraInfo2.orientation - n7 + 360) % 360;
        }
        cameraSource.zzcfy = n2 / 90;
        cameraInfo.setDisplayOrientation(n);
        parameters2.setRotation(n2);
        if (this.zzkst) {
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza(this, null));
        camera.addCallbackBuffer(this.zza(this.zzksp));
        camera.addCallbackBuffer(this.zza(this.zzksp));
        camera.addCallbackBuffer(this.zza(this.zzksp));
        camera.addCallbackBuffer(this.zza(this.zzksp));
        return camera;
    }

    private static zze zza(Camera camera, int n, int n2) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        ArrayList<zze> arrayList2 = arrayList;
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        ArrayList<zze> arrayList3 = arrayList2;
        int n4 = arrayList3.size();
        Object var6_19 = null;
        for (int i = 0; i < n4; ++i) {
            Object e = arrayList3.get(i);
            zze zze3 = (zze)e;
            Size size = zze3.zzbje();
            int n5 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n5 >= n3) continue;
            zze2 = zze3;
            n3 = n5;
        }
        return zze2;
    }

    @SuppressLint(value={"InlinedApi"})
    private static int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        for (int[] nArray2 : camera.getParameters().getSupportedPreviewFpsRange()) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    @SuppressLint(value={"InlinedApi"})
    private final byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        byte[] byArray = new byte[(int)Math.ceil((double)(size.getHeight() * size.getWidth() * n) / 8.0) + 1];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzksy.put(byArray, byteBuffer);
        return byArray;
    }

    /* synthetic */ CameraSource(com.google.android.gms.vision.zza zza2) {
        this();
    }

    final class zzb
    implements Runnable {
        private Detector<?> zzksz;
        private long zzdss = SystemClock.elapsedRealtime();
        private final Object mLock = new Object();
        private boolean mActive = true;
        private long zzktc;
        private int zzktd = 0;
        private ByteBuffer zzkte;
        private /* synthetic */ CameraSource zzktb;

        zzb(CameraSource cameraSource, Detector<?> detector) {
            this.zzktb = cameraSource;
            this.zzksz = detector;
        }

        @SuppressLint(value={"Assert"})
        final void release() {
            this.zzksz.release();
            this.zzksz = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setActive(boolean bl) {
            Object object = this.mLock;
            synchronized (object) {
                this.mActive = bl;
                this.mLock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void zza(byte[] byArray, Camera camera) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzkte != null) {
                    camera.addCallbackBuffer(this.zzkte.array());
                    this.zzkte = null;
                }
                if (!this.zzktb.zzksy.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.zzktc = SystemClock.elapsedRealtime() - this.zzdss;
                ++this.zzktd;
                this.zzkte = (ByteBuffer)this.zzktb.zzksy.get(byArray);
                this.mLock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public final void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.mLock;
                synchronized (object) {
                    while (this.mActive && this.zzkte == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.mActive) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzkte, this.zzktb.zzksp.getWidth(), this.zzktb.zzksp.getHeight(), 17).setId(this.zzktd).setTimestampMillis(this.zzktc).setRotation(this.zzktb.zzcfy).build();
                    byteBuffer = this.zzkte;
                    this.zzkte = null;
                }
                try {
                    this.zzksz.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    this.zzktb.zzksn.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    final class zza
    implements Camera.PreviewCallback {
        private /* synthetic */ CameraSource zzktb;

        private zza(CameraSource cameraSource) {
            this.zzktb = cameraSource;
        }

        public final void onPreviewFrame(byte[] byArray, Camera camera) {
            this.zzktb.zzksx.zza(byArray, camera);
        }

        /* synthetic */ zza(CameraSource cameraSource, com.google.android.gms.vision.zza zza2) {
            this(cameraSource);
        }
    }

    static final class zze {
        private Size zzkth;
        private Size zzkti;

        public zze(Camera.Size size, Camera.Size size2) {
            this.zzkth = new Size(size.width, size.height);
            if (size2 != null) {
                this.zzkti = new Size(size2.width, size2.height);
            }
        }

        public final Size zzbje() {
            return this.zzkth;
        }

        public final Size zzbjf() {
            return this.zzkti;
        }
    }

    final class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzktf;
        private /* synthetic */ CameraSource zzktb;

        private zzc(CameraSource cameraSource) {
            this.zzktb = cameraSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.zzktf != null) {
                this.zzktf.onPictureTaken(byArray);
            }
            Object object = this.zzktb.zzksm;
            synchronized (object) {
                if (this.zzktb.zzksn != null) {
                    this.zzktb.zzksn.startPreview();
                }
                return;
            }
        }

        /* synthetic */ zzc(CameraSource cameraSource, com.google.android.gms.vision.zza zza2) {
            this(cameraSource);
        }
    }

    static final class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzktg;

        private zzd() {
        }

        public final void onShutter() {
            if (this.zzktg != null) {
                this.zzktg.onShutter();
            }
        }

        /* synthetic */ zzd(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzksz;
        private CameraSource zzkta = new CameraSource(null);

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzksz = detector;
            this.zzkta.mContext = context;
        }

        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.zzkta.zzksq = f;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.zzkta.zzksr = n;
            this.zzkta.zzkss = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.zzkta.zzkso = n;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean bl) {
            this.zzkta.zzkst = bl;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzkta;
            cameraSource.getClass();
            this.zzkta.zzksx = new zzb(cameraSource, this.zzksz);
            return this.zzkta;
        }
    }
}

