/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzkhd = new Object();
    private Processor<T> zzkhe;

    public Detector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzkhd;
        synchronized (object) {
            if (this.zzkhe != null) {
                this.zzkhe.release();
                this.zzkhe = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzkhd;
        synchronized (object) {
            if (this.zzkhe == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzbij();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzkhe.receiveDetections(detections);
            return;
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzkhe = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzkhf;
        private Frame.Metadata zzkhg;
        private boolean zzkhh;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzkhf = sparseArray;
            this.zzkhg = metadata;
            this.zzkhh = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzkhf;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzkhg;
        }

        public boolean detectorIsOperational() {
            return this.zzkhh;
        }
    }
}

