/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;

public final class DuplicateTaskCompletionException
extends IllegalStateException {
    private DuplicateTaskCompletionException(String string, @Nullable Throwable throwable) {
        super(string, throwable);
    }

    public static IllegalStateException of(Task<?> task) {
        String string;
        if (!task.isComplete()) {
            return new IllegalStateException("DuplicateTaskCompletionException can only be created from completed Task.");
        }
        Exception exception = task.getException();
        if (exception != null) {
            string = "failure";
        } else if (task.isSuccessful()) {
            String string2 = String.valueOf(task.getResult());
            string = new StringBuilder(7 + String.valueOf(string2).length()).append("result ").append(string2).toString();
        } else {
            string = task.isCanceled() ? "cancellation" : "unknown issue";
        }
        String string3 = String.valueOf(string);
        return new DuplicateTaskCompletionException(string3.length() != 0 ? "Complete with: ".concat(string3) : new String("Complete with: "), exception);
    }
}

