/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzn;
import com.google.android.gms.tasks.zzo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzn<TResult> zzn2 = new zzn<TResult>();
        zzn2.setResult(TResult);
        return zzn2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzn zzn2 = new zzn();
        zzn2.setException(exception);
        return zzn2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        zzbo.zzb((Object)executor, (Object)"Executor must not be null");
        zzbo.zzb(callable, (Object)"Callback must not be null");
        zzn zzn2 = new zzn();
        executor.execute(new zzo(zzn2, callable));
        return zzn2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        zzbo.zzcG((String)"Must not be called on the main application thread");
        zzbo.zzb(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        zza2.await();
        return Tasks.zzb(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        zzbo.zzcG((String)"Must not be called on the main application thread");
        zzbo.zzb(task, (Object)"Task must not be null");
        zzbo.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        if (!zza2.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zzb(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        object = new zzn();
        zzc zzc2 = new zzc(collection.size(), (zzn<Void>)object);
        Iterator<Task<?>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tasks.zza(iterator.next(), zzc2);
        }
        return object;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zzb(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.zzbMd, zzb2);
        task.addOnFailureListener(TaskExecutors.zzbMd, (OnFailureListener)zzb2);
    }

    private Tasks() {
    }

    static final class zzc
    implements zzb {
        private final Object mLock = new Object();
        private final int zzbMj;
        private final zzn<Void> zzbMc;
        private int zzbMk;
        private int zzbMl;
        private Exception zzbMh;

        public zzc(int n, zzn<Void> zzn2) {
            this.zzbMj = n;
            this.zzbMc = zzn2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onFailure(@NonNull Exception exception) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.zzbMl;
                this.zzbMh = exception;
                this.zzDI();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onSuccess(Object object) {
            Object object2 = this.mLock;
            synchronized (object2) {
                ++this.zzbMk;
                this.zzDI();
                return;
            }
        }

        private final void zzDI() {
            if (this.zzbMk + this.zzbMl == this.zzbMj) {
                if (this.zzbMh == null) {
                    this.zzbMc.setResult(null);
                    return;
                }
                int n = this.zzbMl;
                int n2 = this.zzbMj;
                this.zzbMc.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.zzbMh));
            }
        }
    }

    static final class zza
    implements zzb {
        private final CountDownLatch zztL = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public final void onSuccess(Object object) {
            this.zztL.countDown();
        }

        @Override
        public final void onFailure(@NonNull Exception exception) {
            this.zztL.countDown();
        }

        public final void await() throws InterruptedException {
            this.zztL.await();
        }

        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zztL.await(l, timeUnit);
        }

        /* synthetic */ zza(zzo zzo2) {
            this();
        }
    }

    static interface zzb
    extends OnFailureListener,
    OnSuccessListener<Object> {
    }
}

