/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.R;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.location.places.ui.zzc;
import com.google.android.gms.location.places.ui.zzf;
import com.google.android.gms.location.places.ui.zzg;
import com.google.android.gms.maps.model.LatLngBounds;

public class SupportPlaceAutocompleteFragment
extends Fragment {
    private View zzhn;
    private View zzho;
    private EditText zzhp;
    private boolean zzhq;
    @Nullable
    private LatLngBounds zzhr;
    @Nullable
    private AutocompleteFilter zzhs;
    @Nullable
    private PlaceSelectionListener zzht;

    public SupportPlaceAutocompleteFragment() {
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzhn = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzho = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzhp = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        zzf zzf2 = new zzf(this);
        this.zzhn.setOnClickListener((View.OnClickListener)zzf2);
        this.zzhp.setOnClickListener((View.OnClickListener)zzf2);
        this.zzho.setOnClickListener((View.OnClickListener)new zzg(this));
        this.zzaj();
        return view;
    }

    public void onDestroyView() {
        this.zzhn = null;
        this.zzho = null;
        this.zzhp = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzhr = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzhs = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzhp.setText(charSequence);
        this.zzaj();
    }

    public void setHint(CharSequence charSequence) {
        this.zzhp.setHint(charSequence);
        this.zzhn.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzht = placeSelectionListener;
    }

    private final void zzaj() {
        boolean bl = !this.zzhp.getText().toString().isEmpty();
        this.zzho.setVisibility(bl ? 0 : 8);
    }

    private final void zzak() {
        int n = -1;
        try {
            Intent intent = ((zzc)new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzhr).setFilter(this.zzhs).zzh(this.zzhp.getText().toString()).zzg(1)).build((Activity)this.getActivity());
            this.zzhq = true;
            this.startActivityForResult(intent, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesRepairableException googlePlayServicesRepairableException2 = googlePlayServicesRepairableException;
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException2 = googlePlayServicesNotAvailableException;
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException2);
        }
        if (n != -1) {
            GoogleApiAvailability.getInstance().showErrorDialogFragment((Activity)this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzhq = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzht != null) {
                    this.zzht.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzht != null) {
                    this.zzht.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }

    static /* synthetic */ boolean zzb(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        return supportPlaceAutocompleteFragment.zzhq;
    }

    static /* synthetic */ void zzc(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        supportPlaceAutocompleteFragment.zzak();
    }
}

