/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzfk;
import com.google.android.gms.internal.places.zzhb;
import com.google.android.gms.internal.places.zzhg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhv
extends zzfk<Long>
implements zzhg<Long>,
RandomAccess {
    private static final zzhv zzuo = new zzhv();
    private long[] zzup;
    private int size;

    zzhv() {
        this(new long[10], 0);
    }

    private zzhv(long[] lArray, int n) {
        this.zzup = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbc();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzup, n2, this.zzup, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhv)) {
            return super.equals(object);
        }
        zzhv zzhv2 = (zzhv)object;
        if (this.size != zzhv2.size) {
            return false;
        }
        long[] lArray = zzhv2.zzup;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzup[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzhb.zzo(this.zzup[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzac(n);
        return this.zzup[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzp(long l) {
        this.zzl(this.size, l);
    }

    private final void zzl(int n, long l) {
        this.zzbc();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
        if (this.size < this.zzup.length) {
            System.arraycopy(this.zzup, n, this.zzup, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzup, 0, lArray, 0, n);
            System.arraycopy(this.zzup, n, lArray, n + 1, this.size - n);
            this.zzup = lArray;
        }
        this.zzup[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzbc();
        zzhb.checkNotNull(collection);
        if (!(collection instanceof zzhv)) {
            return super.addAll(collection);
        }
        zzhv zzhv2 = (zzhv)collection;
        if (zzhv2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhv2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhv2.size;
        if (n > this.zzup.length) {
            this.zzup = Arrays.copyOf(this.zzup, n);
        }
        System.arraycopy(zzhv2.zzup, 0, this.zzup, this.size, zzhv2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbc();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzup[i])) continue;
            System.arraycopy(this.zzup, i + 1, this.zzup, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzac(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
    }

    private final String zzad(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhv zzhv2 = this;
        zzhv2.zzbc();
        zzhv2.zzac(n);
        long l3 = zzhv2.zzup[n];
        zzhv2.zzup[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhv zzhv2 = this;
        zzhv2.zzbc();
        zzhv2.zzac(n);
        long l = zzhv2.zzup[n];
        if (n < zzhv2.size - 1) {
            System.arraycopy(zzhv2.zzup, n + 1, zzhv2.zzup, n, zzhv2.size - n);
        }
        --zzhv2.size;
        ++zzhv2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzl(n, l);
    }

    @Override
    public final /* synthetic */ zzhg zzae(int n) {
        int n2 = n;
        zzhv zzhv2 = this;
        if (n2 < zzhv2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhv(Arrays.copyOf(zzhv2.zzup, n2), zzhv2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzuo.zzbb();
    }
}

