/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.pay;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.pay.zzn;
import java.lang.ref.WeakReference;

public final class zzo
extends zzn {
    private final WeakReference<Activity> zza;
    private final int zzb;

    public zzo(Activity activity, int n) {
        WeakReference<Activity> weakReference = new WeakReference<Activity>(activity);
        this.zza = weakReference;
        this.zzb = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzr(Status status) {
        Intent intent;
        Activity activity = (Activity)this.zza.get();
        if (activity == null) {
            Log.d((String)"PayClientImpl", (String)"Ignoring onPendingIntent, Activity is gone");
            return;
        }
        if (status.hasResolution()) {
            try {
                status.startResolutionForResult(activity, this.zzb);
                return;
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.w((String)"PayClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
            }
        }
        if ((activity = activity.createPendingResult(this.zzb, intent = new Intent(), 0x40000000)) == null) {
            Log.w((String)"PayClientImpl", (String)"Null pending result returned for onPendingIntent");
            return;
        }
        try {
            int n = status.isSuccess();
            n = n != 0 ? -1 : status.getStatusCode();
            activity.send(n);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"PayClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
    }
}

