/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_text_common.zzou;
import com.google.android.gms.internal.mlkit_vision_text_common.zzuc;
import com.google.android.gms.internal.mlkit_vision_text_common.zzuq;
import com.google.android.gms.internal.mlkit_vision_text_common.zzut;
import com.google.android.gms.internal.mlkit_vision_text_common.zzuv;
import com.google.android.gms.internal.mlkit_vision_text_common.zzux;
import com.google.android.gms.internal.mlkit_vision_text_common.zzuy;
import com.google.android.gms.internal.mlkit_vision_text_common.zzvf;
import com.google.android.gms.internal.mlkit_vision_text_common.zzvh;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.internal.LoggingUtils;
import com.google.mlkit.vision.text.internal.TextOptionalModuleUtils;
import com.google.mlkit.vision.text.internal.zzb;
import com.google.mlkit.vision.text.internal.zzc;
import com.google.mlkit.vision.text.internal.zzm;

final class zzd
implements zzm {
    private final Context zza;
    private final TextRecognizerOptionsInterface zzb;
    private boolean zzc;
    private boolean zzd;
    private final zzuc zze;
    @Nullable
    private zzuv zzf;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final Text zza(InputImage inputImage) throws MlKitException {
        Object object;
        if (((zzd)object).zzf == null) {
            ((zzd)object).zzb();
        }
        Object object2 = (zzuv)Preconditions.checkNotNull((Object)((zzd)object).zzf);
        if (!((zzd)object).zzc) {
            try {
                object2.zze();
                ((zzd)object).zzc = true;
            }
            catch (RemoteException remoteException) {
                object = String.valueOf(((zzd)object).zzb.getLoggingLibraryName());
                throw new MlKitException("Failed to init text recognizer ".concat((String)object), 13, (Throwable)remoteException);
            }
        }
        Object object3 = new zzuq(inputImage.getFormat(), inputImage.getWidth(), inputImage.getHeight(), CommonConvertUtils.convertToMVRotation((int)inputImage.getRotationDegrees()), SystemClock.elapsedRealtime());
        IObjectWrapper iObjectWrapper = ImageUtils.getInstance().getImageDataWrapper(inputImage);
        try {
            object2 = object2.zzd(iObjectWrapper, (zzuq)((Object)object3));
            return new Text((zzvf)((Object)object2), inputImage.getCoordinatesMatrix());
        }
        catch (RemoteException remoteException) {
            object = String.valueOf(((zzd)object).zzb.getLoggingLibraryName());
            throw new MlKitException("Failed to run text recognizer ".concat((String)object), 13, (Throwable)remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static zzvh zzd(TextRecognizerOptionsInterface textRecognizerOptionsInterface, @Nullable String string) {
        int n;
        boolean bl = textRecognizerOptionsInterface instanceof zzc ? ((zzc)((Object)textRecognizerOptionsInterface)).zza() : false;
        String string2 = textRecognizerOptionsInterface.getConfigLabel();
        String string3 = textRecognizerOptionsInterface.getLoggingLibraryNameForOptionalModule();
        switch (textRecognizerOptionsInterface.getLoggingLanguageOption()) {
            default: {
                n = 1;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 8: {
                n = 9;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 7: {
                n = 8;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 6: {
                n = 7;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 5: {
                n = 6;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 4: {
                n = 5;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 3: {
                n = 4;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 2: {
                n = 3;
                return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
            }
            case 1: {
                n = 2;
            }
        }
        return new zzvh(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint(), bl);
    }

    zzd(Context context, TextRecognizerOptionsInterface textRecognizerOptionsInterface, zzuc zzuc2) {
        this.zza = context;
        this.zzb = textRecognizerOptionsInterface;
        this.zze = zzuc2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzb() throws MlKitException {
        Object object;
        if (((zzd)object).zzf != null) {
            return;
        }
        try {
            Object object2 = ((zzd)object).zzb;
            boolean bl = object2 instanceof zzb;
            object2 = bl ? ((zzb)object2).zza() : null;
            int n = ((zzd)object).zzb.getIsThickClient();
            if (n != 0) {
                Log.d((String)"DecoupledTextDelegate", (String)"Start loading thick OCR module.");
                object2 = zzux.zza(DynamiteModule.load((Context)((zzd)object).zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_LOCAL, (String)((zzd)object).zzb.getModuleId()).instantiate("com.google.mlkit.vision.text.bundled.common.BundledTextRecognizerCreator")).zze(ObjectWrapper.wrap((Object)((zzd)object).zza), com.google.mlkit.vision.text.internal.zzd.zzd(((zzd)object).zzb, (String)object2));
            } else if (bl) {
                Log.d((String)"DecoupledTextDelegate", (String)"Start loading custom OCR module.");
                object2 = zzut.zza(DynamiteModule.load((Context)((zzd)object).zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)((zzd)object).zzb.getModuleId()).instantiate("com.google.android.gms.vision.text.mlkit.CommonTextRecognizerCreator")).zzd(ObjectWrapper.wrap((Object)((zzd)object).zza), null, com.google.mlkit.vision.text.internal.zzd.zzd(((zzd)object).zzb, (String)object2));
            } else {
                Log.d((String)"DecoupledTextDelegate", (String)"Start loading thin OCR module.");
                zzuy zzuy2 = zzux.zza(DynamiteModule.load((Context)((zzd)object).zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)((zzd)object).zzb.getModuleId()).instantiate("com.google.android.gms.vision.text.mlkit.TextRecognizerCreator"));
                n = ((zzd)object).zzb.getLoggingLanguageOption();
                object2 = n == 1 ? zzuy2.zzd(ObjectWrapper.wrap((Object)((zzd)object).zza)) : zzuy2.zze(ObjectWrapper.wrap((Object)((zzd)object).zza), com.google.mlkit.vision.text.internal.zzd.zzd(((zzd)object).zzb, (String)object2));
            }
            ((zzd)object).zzf = object2;
            object2 = ((zzd)object).zze;
            bl = ((zzd)object).zzb.getIsThickClient();
            LoggingUtils.zzb((zzuc)object2, bl, zzou.zza);
            return;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            LoggingUtils.zzb(((zzd)object).zze, ((zzd)object).zzb.getIsThickClient(), zzou.zzB);
            if (((zzd)object).zzb.getIsThickClient()) {
                object = ((zzd)object).zzb;
                Object[] objectArray = new Object[]{object.getLoggingLibraryName(), loadingException.getMessage()};
                throw new MlKitException(String.format("Failed to load text module %s. %s", objectArray), 13, (Throwable)loadingException);
            }
        }
        catch (RemoteException remoteException) {
            LoggingUtils.zzb(((zzd)object).zze, ((zzd)object).zzb.getIsThickClient(), zzou.zzC);
            object = String.valueOf(((zzd)object).zzb.getLoggingLibraryName());
            throw new MlKitException("Failed to create text recognizer ".concat((String)object), 13, (Throwable)remoteException);
        }
        if (((zzd)object).zzd) {
            throw new MlKitException("Waiting for the text optional module to be downloaded. Please wait.", 14);
        }
        OptionalModuleUtils.requestDownload((Context)((zzd)object).zza, (Feature[])TextOptionalModuleUtils.zza(((zzd)object).zzb));
        ((zzd)object).zzd = true;
        throw new MlKitException("Waiting for the text optional module to be downloaded. Please wait.", 14);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzc() {
        zzuv zzuv2 = this.zzf;
        if (zzuv2 != null) {
            try {
                zzuv2.zzf();
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf(this.zzb.getLoggingLibraryName());
                Log.e((String)"DecoupledTextDelegate", (String)"Failed to release text recognizer ".concat(string), (Throwable)remoteException);
            }
            this.zzf = null;
        }
        this.zzc = false;
    }
}

