/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzlc;
import com.google.android.gms.internal.measurement.zzlk;
import com.google.android.gms.internal.measurement.zzmn;
import com.google.android.gms.internal.measurement.zzox;
import com.google.android.gms.internal.measurement.zzpd;
import com.google.android.gms.internal.measurement.zzpo;
import com.google.android.gms.internal.measurement.zzpv;
import com.google.android.gms.internal.measurement.zzqn;
import com.google.android.gms.internal.measurement.zzqs;
import com.google.android.gms.internal.measurement.zzqt;
import com.google.android.gms.internal.measurement.zzqy;
import com.google.android.gms.internal.measurement.zzqz;
import com.google.android.gms.internal.measurement.zzrl;
import com.google.android.gms.internal.measurement.zzrq;
import com.google.android.gms.internal.measurement.zzrw;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzms;
import com.google.android.gms.measurement.internal.zzni;
import com.google.android.gms.measurement.internal.zznm;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zznq;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zzns;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznu;
import com.google.android.gms.measurement.internal.zznw;
import com.google.android.gms.measurement.internal.zznx;
import com.google.android.gms.measurement.internal.zzny;
import com.google.android.gms.measurement.internal.zznz;
import com.google.android.gms.measurement.internal.zzoa;
import com.google.android.gms.measurement.internal.zzob;
import com.google.android.gms.measurement.internal.zzoe;
import com.google.android.gms.measurement.internal.zzof;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzoh;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzol;
import com.google.android.gms.measurement.internal.zzom;
import com.google.android.gms.measurement.internal.zzoo;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzv;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zznv
implements zzja {
    private static volatile @Nullable zznv zza;
    private zzhg zzb;
    private zzgp zzc;
    private zzam zzd;
    private zzgs zze;
    private zznm zzf;
    private zzv zzg;
    private final zzol zzh;
    private zzlf zzi;
    private zzms zzj;
    private final zznq zzk;
    private @MonotonicNonNull zzhd zzl;
    private final zzhw zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Set<String> zzr = new HashSet<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzjc> zzac;
    private final Map<String, zzaz> zzad;
    private final Map<String, zzb> zzae;
    private @Nullable zzlh zzaf;
    private @Nullable String zzag;
    private final zzoo zzah = new zzoa(this);

    private final int zza(String string, zzai zzai2) {
        zzjb zzjb2;
        zzh zzh2;
        if (this.zzb.zzb(string) == null) {
            zzai2.zza(zzjc.zza.zzd, zzal.zzj);
            return 1;
        }
        if (zzox.zza() && this.zze().zza(zzbj.zzcw) && (zzh2 = this.zzf().zze(string)) != null && com.google.android.gms.measurement.internal.zzd.zza((String)zzh2.zzak()).zza() == zzjb.zzb && (zzjb2 = this.zzb.zza(string, zzjc.zza.zzd)) != zzjb.zza) {
            zzai2.zza(zzjc.zza.zzd, zzal.zzi);
            if (zzjb2 == zzjb.zzd) {
                return 0;
            }
            return 1;
        }
        zzai2.zza(zzjc.zza.zzd, zzal.zzb);
        if (this.zzb.zzc(string, zzjc.zza.zzd)) {
            return 0;
        }
        return 1;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzu().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzx() {
        long l = this.zzb().currentTimeMillis();
        zzms zzms2 = this.zzj;
        zzms2.zzal();
        zzms2.zzt();
        long l2 = zzms2.zzf.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzms2.zzq().zzv().nextInt(86400000);
            zzms2.zzf.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    @WorkerThread
    final @Nullable Bundle zza(String string) {
        zzom zzom2;
        this.zzl().zzt();
        this.zzs();
        if (this.zzi().zzb(string) == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        zzjc zzjc2 = this.zzb(string);
        bundle.putAll(zzjc2.zzb());
        zzaz zzaz2 = this.zza(string, this.zzd(string), zzjc2, new zzai());
        bundle.putAll(zzaz2.zzb());
        int n = this.zzp().zzc(string) ? 1 : ((zzom2 = this.zzf().zze(string, "_npa")) != null ? (zzom2.zze.equals(1L) ? 1 : 0) : this.zza(string, new zzai()));
        bundle.putString("ad_personalization", n == 1 ? "denied" : "granted");
        return bundle;
    }

    public final Clock zzb(@UnknownInitialization zznv this) {
        return ((zzhw)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzh zza(zzp zzp2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        if (!zzp2.zzu.isEmpty()) {
            this.zzae.put(zzp2.zza, new zzb(this, zzp2.zzu, null));
        }
        zzh zzh2 = this.zzf().zze(zzp2.zza);
        boolean bl = false;
        zzjc zzjc2 = this.zzb(zzp2.zza).zza(zzjc.zzb((String)zzp2.zzt));
        String string = zzjc2.zzi() ? this.zzj.zza(zzp2.zza, zzp2.zzn) : "";
        if (zzh2 == null) {
            zzh2 = new zzh(this.zzm, zzp2.zza);
            if (zzjc2.zzj()) {
                zzh2.zzb(this.zza(zzjc2));
            }
            if (zzjc2.zzi()) {
                zzh2.zzh(string);
            }
        } else if (zzjc2.zzi() && string != null && !string.equals(zzh2.zzaj())) {
            boolean bl2 = TextUtils.isEmpty((CharSequence)zzh2.zzaj());
            zzh2.zzh(string);
            if (zzp2.zzn && !"00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzp2.zza, (zzjc)zzjc2).first) && !bl2) {
                if (zzpd.zza() && this.zze().zza(zzbj.zzdc) && !zzjc2.zzj()) {
                    bl = true;
                } else {
                    zzh2.zzb(this.zza(zzjc2));
                }
                if (this.zzf().zze(zzp2.zza, "_id") != null && this.zzf().zze(zzp2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zzom zzom2 = new zzom(zzp2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zzom2);
                }
            } else if (TextUtils.isEmpty((CharSequence)zzh2.zzad()) && zzjc2.zzj()) {
                zzh2.zzb(this.zza(zzjc2));
            }
        } else if (TextUtils.isEmpty((CharSequence)zzh2.zzad()) && zzjc2.zzj()) {
            zzh2.zzb(this.zza(zzjc2));
        }
        zzh2.zzf(zzp2.zzb);
        zzh2.zza(zzp2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzp2.zzk)) {
            zzh2.zze(zzp2.zzk);
        }
        if (zzp2.zze != 0L) {
            zzh2.zzn(zzp2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzp2.zzc)) {
            zzh2.zzd(zzp2.zzc);
        }
        zzh2.zzb(zzp2.zzj);
        if (zzp2.zzd != null) {
            zzh2.zzc(zzp2.zzd);
        }
        zzh2.zzk(zzp2.zzf);
        zzh2.zzb(zzp2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzp2.zzg)) {
            zzh2.zzg(zzp2.zzg);
        }
        zzh2.zza(zzp2.zzn);
        zzh2.zza(zzp2.zzq);
        zzh2.zzl(zzp2.zzr);
        zzh2.zzj(zzp2.zzv);
        if (zzpv.zza() && this.zze().zza(zzbj.zzbu)) {
            zzh2.zza(zzp2.zzs);
        } else if (zzpv.zza() && this.zze().zza(zzbj.zzbt)) {
            zzh2.zza((List<String>)null);
        }
        if (zzrw.zza() && this.zze().zza(zzbj.zzbw)) {
            this.zzq();
            if (zzop.zzf((String)zzh2.zzac())) {
                zzh2.zzc(zzp2.zzw);
                if (this.zze().zza(zzbj.zzbx)) {
                    zzh2.zzk(zzp2.zzac);
                }
            }
        }
        if (zzrl.zza() && this.zze().zza(zzbj.zzcg)) {
            zzh2.zza(zzp2.zzaa);
        }
        zzh2.zzt(zzp2.zzx);
        if (zzox.zza() && this.zze().zza(zzbj.zzcw)) {
            zzh2.zzi(zzp2.zzad);
        }
        if (zzpd.zza() && this.zze().zza(zzbj.zzdc)) {
            if (zzh2.zzas() || bl) {
                this.zzf().zza(zzh2, bl, false);
            }
        } else if (zzh2.zzas()) {
            this.zzf().zza(zzh2, false, false);
        }
        return zzh2;
    }

    @WorkerThread
    private final @Nullable zzp zzc(String string) {
        zzh zzh2 = this.zzf().zze(string);
        if (zzh2 == null || TextUtils.isEmpty((CharSequence)zzh2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzh2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzgi.zza((String)string));
            return null;
        }
        return new zzp(string, zzh2.zzah(), zzh2.zzaf(), zzh2.zze(), zzh2.zzae(), zzh2.zzq(), zzh2.zzn(), null, zzh2.zzar(), false, zzh2.zzag(), zzh2.zzd(), 0L, 0, zzh2.zzaq(), false, zzh2.zzaa(), zzh2.zzx(), zzh2.zzo(), zzh2.zzan(), null, this.zzb(string).zzh(), "", null, zzh2.zzat(), zzh2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzh2.zza(), zzh2.zzf(), zzh2.zzam(), zzh2.zzak());
    }

    public final zzv zzc() {
        return (zzv)zznv.zza(this.zzg);
    }

    public final zzac zzd() {
        return this.zzm.zzd();
    }

    public final zzah zze(@UnknownInitialization zznv this) {
        return ((zzhw)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzam zzf(@UnknownInitialization zznv this) {
        return (zzam)zznv.zza(this.zzd);
    }

    @VisibleForTesting
    @WorkerThread
    private final zzaz zza(String string, zzaz zzaz2, zzjc zzjc2, zzai zzai2) {
        int n;
        if (this.zzi().zzb(string) == null) {
            int n2;
            if (zzaz2.zzc() == zzjb.zzc) {
                n2 = zzaz2.zza();
                zzai2.zza(zzjc.zza.zzc, n2);
            } else {
                n2 = 90;
                zzai2.zza(zzjc.zza.zzc, zzal.zzj);
            }
            return new zzaz(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
        }
        zzjb zzjb2 = zzaz2.zzc();
        if (zzjb2 == zzjb.zzd || zzjb2 == zzjb.zzc) {
            n = zzaz2.zza();
            zzai2.zza(zzjc.zza.zzc, n);
        } else {
            n = 90;
            if (zzox.zza() && this.zze().zza(zzbj.zzcw)) {
                zzjc.zza zza2;
                zzjc.zza zza3;
                zzai zzai3 = zzai2;
                zzjc zzjc3 = zzjc2;
                zzjb zzjb3 = zzjb2;
                String string2 = string;
                zznv zznv2 = this;
                if (zzjb3 == zzjb.zzb && (zza3 = zznv2.zzb.zza(string2, zzjc.zza.zzc)) != zzjb.zza) {
                    zzai3.zza(zzjc.zza.zzc, zzal.zzi);
                    zza2 = zza3;
                } else {
                    boolean bl;
                    zza3 = zznv2.zzb.zzb(string2, zzjc.zza.zzc);
                    zzjb zzjb4 = zzjc3.zzc();
                    boolean bl2 = bl = zzjb4 == zzjb.zzd || zzjb4 == zzjb.zzc;
                    if (zza3 == zzjc.zza.zza && bl) {
                        zzai3.zza(zzjc.zza.zzc, zzal.zzc);
                        zza2 = zzjb4;
                    } else {
                        zzai3.zza(zzjc.zza.zzc, zzal.zzb);
                        zza2 = zznv2.zzb.zzc(string2, zzjc.zza.zzc) ? zzjb.zzd : zzjb.zzc;
                    }
                }
                zzjb2 = zza2;
            } else {
                zzai zzai4 = zzai2;
                zzjc zzjc4 = zzjc2;
                zzjb zzjb5 = zzjb2;
                String string3 = string;
                zznv zznv3 = this;
                Preconditions.checkArgument((zzjb5 == zzjb.zza || zzjb5 == zzjb.zzb ? 1 : 0) != 0);
                zzjb zzjb6 = zzjb5;
                zzjc.zza zza4 = zznv3.zzb.zzb(string3, zzjc.zza.zzc);
                Boolean bl = zzjc4.zze();
                if (zza4 == zzjc.zza.zza && bl != null) {
                    zzjb6 = bl != false ? zzjb.zzd : zzjb.zzc;
                    zzai4.zza(zzjc.zza.zzc, zzal.zzc);
                }
                if (zzjb6 == zzjb.zza) {
                    zzjb6 = zznv3.zzb.zzc(string3, zzjc.zza.zzc) ? zzjb.zzd : zzjb.zzc;
                    zzai4.zza(zzjc.zza.zzc, zzal.zzb);
                }
                zzjb2 = zzjb6;
            }
        }
        boolean bl = this.zzb.zzn(string);
        SortedSet<String> sortedSet = this.zzi().zzh(string);
        if (zzjb2 == zzjb.zzc || sortedSet.isEmpty()) {
            return new zzaz(Boolean.valueOf(false), n, Boolean.valueOf(bl), "-");
        }
        return new zzaz(Boolean.valueOf(true), n, Boolean.valueOf(bl), bl ? TextUtils.join((CharSequence)"", sortedSet) : "");
    }

    @WorkerThread
    private final zzaz zzd(String string) {
        this.zzl().zzt();
        this.zzs();
        zzaz zzaz2 = this.zzad.get(string);
        if (zzaz2 == null) {
            zzaz2 = this.zzf().zzg(string);
            this.zzad.put(string, zzaz2);
        }
        return zzaz2;
    }

    public final zzgh zzg() {
        return this.zzm.zzk();
    }

    public final zzgi zzj(@UnknownInitialization zznv this) {
        return ((zzhw)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzgp zzh() {
        return (zzgp)zznv.zza(this.zzc);
    }

    private final zzgs zzy() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzhg zzi() {
        return (zzhg)zznv.zza(this.zzb);
    }

    public final zzhp zzl(@UnknownInitialization zznv this) {
        return ((zzhw)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzhw zza(zznv zznv2) {
        return zznv2.zzm;
    }

    final zzhw zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzjc zzb(String string) {
        this.zzl().zzt();
        this.zzs();
        zzjc zzjc2 = this.zzac.get(string);
        if (zzjc2 == null) {
            zzjc2 = this.zzf().zzi(string);
            if (zzjc2 == null) {
                zzjc2 = zzjc.zza;
            }
            this.zza(string, zzjc2);
        }
        return zzjc2;
    }

    public final zzlf zzm() {
        return (zzlf)zznv.zza(this.zzi);
    }

    public final zzms zzn() {
        return this.zzj;
    }

    private final zznm zzz() {
        return (zznm)zznv.zza(this.zzf);
    }

    private static zznr zza(@Nullable zznr zznr2) {
        if (zznr2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zznr2.zzan()) {
            String string = String.valueOf(((Object)((Object)zznr2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zznr2;
    }

    public final zznq zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zznv zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zznv> clazz = zznv.class;
        synchronized (zznv.class) {
            if (zza != null) return zza;
            zzoh zzoh2 = (zzoh)Preconditions.checkNotNull((Object)new zzoh(context));
            zza = new zznv(zzoh2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zzol zzp() {
        return (zzol)zznv.zza(this.zzh);
    }

    public final zzop zzq(@UnknownInitialization zznv this) {
        return ((zzhw)Preconditions.checkNotNull((Object)this.zzm)).zzt();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzh zzh2) {
        try {
            if (zzh2.zze() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzh2.zzac(), (int)0).versionCode;
                if (zzh2.zze() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzh2.zzac(), (int)0).versionName;
                String string2 = zzh2.zzaf();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    private final @Nullable Boolean zzh(zzp zzp2) {
        Boolean bl = zzp2.zzq;
        if (zzox.zza() && this.zze().zza(zzbj.zzcw) && !TextUtils.isEmpty((CharSequence)zzp2.zzad)) {
            zzjb zzjb2 = com.google.android.gms.measurement.internal.zzd.zza((String)zzp2.zzad).zza();
            switch (zzjb2) {
                case zzd: {
                    bl = false;
                    break;
                }
                case zzc: {
                    bl = true;
                    break;
                }
                case zzb: 
                case zza: {
                    bl = null;
                }
            }
        }
        return bl;
    }

    @WorkerThread
    private final @Nullable String zza(zzjc zzjc2) {
        if (zzjc2.zzj()) {
            zznv zznv2 = this;
            byte[] byArray = new byte[16];
            zznv2.zzq().zzv().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzp zzp2) {
        Future future = this.zzl().zza((Callable)new zzob(this, zzp2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzgi.zza((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    static /* synthetic */ void zza(zznv zznv2, zzoh zzoh2) {
        zznv zznv3 = zznv2;
        zznv3.zzl().zzt();
        zznv zznv4 = zznv3;
        zznv3.zzl = new zzhd(zznv4);
        zznv4 = zznv3;
        zzam zzam2 = new zzam(zznv4);
        zzam2.zzam();
        zznv3.zzd = zzam2;
        zznv3.zze().zza((zzaj)Preconditions.checkNotNull((Object)((Object)zznv3.zzb)));
        zznv4 = zznv3;
        zzms zzms2 = new zzms(zznv4);
        zzms2.zzam();
        zznv3.zzj = zzms2;
        zznv4 = zznv3;
        zzv zzv2 = new zzv(zznv4);
        zzv2.zzam();
        zznv3.zzg = zzv2;
        zznv4 = zznv3;
        zzlf zzlf2 = new zzlf(zznv4);
        zzlf2.zzam();
        zznv3.zzi = zzlf2;
        zznv4 = zznv3;
        zznm zznm2 = new zznm(zznv4);
        zznm2.zzam();
        zznv3.zzf = zznm2;
        zznv4 = zznv3;
        zznv3.zze = new zzgs(zznv4);
        if (zznv3.zzs != zznv3.zzt) {
            zznv3.zzj().zzg().zza("Not all upload components initialized", (Object)zznv3.zzs, (Object)zznv3.zzt);
        }
        zznv3.zzn = true;
    }

    private zznv(zzoh zzoh2) {
        this(zzoh2, null);
    }

    private zznv(zzoh zzoh2, @Nullable zzhw zzhw2) {
        Preconditions.checkNotNull((Object)zzoh2);
        this.zzm = zzhw2 = zzhw.zza((Context)zzoh2.zza, null, null);
        this.zzab = -1L;
        zznv zznv2 = this;
        this.zzk = new zznq(zznv2);
        zznv2 = this;
        zzol zzol2 = new zzol(zznv2);
        zzol2.zzam();
        this.zzh = zzol2;
        zznv2 = this;
        zzgp zzgp2 = new zzgp(zznv2);
        zzgp2.zzam();
        this.zzc = zzgp2;
        zznv2 = this;
        zzhg zzhg2 = new zzhg(zznv2);
        zzhg2.zzam();
        this.zzb = zzhg2;
        this.zzac = new HashMap<String, zzjc>();
        this.zzad = new HashMap<String, zzaz>();
        this.zzae = new HashMap<String, zzb>();
        this.zzl().zzb((Runnable)new zznx(this, zzoh2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzt();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzr() {
        int n;
        this.zzl().zzt();
        this.zzs();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzaf()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzab();
        int n4 = n2;
        zznv zznv2 = this;
        zznv2.zzl().zzt();
        if (n4 > n3) {
            zznv2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zznv2.zza(n3, zznv2.zzy)) {
            zznv2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zznv2.zzj().zzp().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzs() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzaa() {
        this.zzl().zzt();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzp().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzp().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzgn.zzk.zza zza2) {
        int n;
        int n2;
        String string2;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzq(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzt(string) && !TextUtils.isEmpty((CharSequence)(string2 = zza2.zzy())) && (n2 = string2.indexOf(".")) != -1) {
            string2 = string2.substring(0, n2);
            zza2.zzo(string2);
        }
        if (this.zzi().zzu(string) && (n = zzol.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzs(string)) {
            zza2.zzk();
        }
        if (this.zzi().zzp(string)) {
            zza2.zzh();
            if (!zzpd.zza() || !this.zze().zza(zzbj.zzdc) || this.zzb(string).zzj()) {
                zzb zzb2 = this.zzae.get(string);
                if (zzb2 == null || zzb2.zzb + this.zze().zzc(string, zzbj.zzaw) < this.zzb().elapsedRealtime()) {
                    zzb2 = new zzb(this, null);
                    this.zzae.put(string, zzb2);
                }
                zza2.zzk(zzb2.zza);
            }
        }
        if (this.zzi().zzr(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzh zzh2) {
        this.zzl().zzt();
        if (TextUtils.isEmpty((CharSequence)zzh2.zzah()) && TextUtils.isEmpty((CharSequence)zzh2.zzaa())) {
            this.zzb((String)Preconditions.checkNotNull((Object)zzh2.zzac()), 204, null, null, null);
            return;
        }
        if (zzqt.zza() && this.zze().zza(zzbj.zzcc)) {
            String string = (String)Preconditions.checkNotNull((Object)zzh2.zzac());
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string);
            zzfx.zzd zzd2 = this.zzi().zzc(string);
            ArrayMap arrayMap = null;
            String string2 = this.zzi().zze(string);
            if (zzd2 != null) {
                String string3;
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string2);
                }
                if (!TextUtils.isEmpty((CharSequence)(string3 = this.zzi().zzd(string)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string3);
                }
            }
            this.zzu = true;
            zznv zznv2 = this;
            zznu zznu2 = new zznu(zznv2);
            ArrayMap arrayMap2 = arrayMap;
            zzh zzh3 = zzh2;
            zzgp zzgp2 = this.zzh();
            zzgp2.zzt();
            zzgp2.zzal();
            Preconditions.checkNotNull((Object)zzh3);
            Preconditions.checkNotNull((Object)zznu2);
            String string4 = ((zzno)zzgp2).zzo().zza(zzh3);
            try {
                URL uRL = new URI(string4).toURL();
                zzgp2.zzl().zza((Runnable)new zzgt(zzgp2, zzh3.zzac(), uRL, null, (Map)arrayMap2, zznu2));
                return;
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                zzgp2.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzgi.zza((String)zzh3.zzac()), (Object)string4);
                return;
            }
        }
        String string = this.zzk.zza(zzh2);
        try {
            String string5 = (String)Preconditions.checkNotNull((Object)zzh2.zzac());
            URL uRL = new URL(string);
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string5);
            zzfx.zzd zzd3 = this.zzi().zzc(string5);
            ArrayMap arrayMap = null;
            String string6 = this.zzi().zze(string5);
            if (zzd3 != null) {
                String string7;
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string6);
                }
                if (!TextUtils.isEmpty((CharSequence)(string7 = this.zzi().zzd(string5)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string7);
                }
            }
            this.zzu = true;
            zzny zzny2 = new zzny(this);
            ArrayMap arrayMap3 = arrayMap;
            URL uRL2 = uRL;
            String string8 = string5;
            zzgp zzgp3 = this.zzh();
            zzgp3.zzt();
            zzgp3.zzal();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzny2);
            zzgp3.zzl().zza((Runnable)new zzgt(zzgp3, string8, uRL2, null, (Map)arrayMap3, zzny2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzgi.zza((String)zzh2.zzac()), (Object)string);
            return;
        }
    }

    @WorkerThread
    final void zza(zzh zzh2, zzgn.zzk.zza zza2) {
        Object object7;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.zzl().zzt();
        this.zzs();
        zzai zzai2 = zzai.zza(zza2.zzv());
        if (zzox.zza() && this.zze().zza(zzbj.zzcw)) {
            object6 = zzai2;
            object5 = zzh2.zzac();
            object4 = this;
            ((zznv)object4).zzl().zzt();
            ((zznv)object4).zzs();
            object3 = ((zznv)object4).zzb((String)object5);
            switch (object3.zzc()) {
                case zzb: {
                    ((zzai)object6).zza(zzjc.zza.zza, zzal.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzai)object6).zza(zzjc.zza.zza, object3.zza());
                    break;
                }
                default: {
                    ((zzai)object6).zza(zzjc.zza.zza, zzal.zzj);
                }
            }
            switch (object3.zzd()) {
                case zzb: {
                    ((zzai)object6).zza(zzjc.zza.zzb, zzal.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzai)object6).zza(zzjc.zza.zzb, object3.zza());
                    break;
                }
                default: {
                    ((zzai)object6).zza(zzjc.zza.zzb, zzal.zzj);
                    break;
                }
            }
        } else {
            object3 = zzai2;
            object5 = zzh2.zzac();
            object4 = this;
            ((zznv)object4).zzl().zzt();
            ((zznv)object4).zzs();
            object2 = ((zznv)object4).zzb((String)object5);
            if (object2.zze() != null) {
                ((zzai)object3).zza(zzjc.zza.zza, object2.zza());
            } else {
                ((zzai)object3).zza(zzjc.zza.zza, zzal.zzj);
            }
            if (object2.zzf() != null) {
                ((zzai)object3).zza(zzjc.zza.zzb, object2.zza());
            } else {
                ((zzai)object3).zza(zzjc.zza.zzb, zzal.zzj);
            }
        }
        object3 = zzai2;
        object6 = zza2;
        object5 = zzh2.zzac();
        object4 = this;
        ((zznv)object4).zzl().zzt();
        ((zznv)object4).zzs();
        object2 = ((zznv)object4).zza((String)object5, ((zznv)object4).zzd((String)object5), ((zznv)object4).zzb((String)object5), (zzai)object3);
        ((zzgn.zzk.zza)((Object)object6)).zzb((Boolean)Preconditions.checkNotNull((Object)object2.zzd()));
        if (!TextUtils.isEmpty((CharSequence)object2.zze())) {
            ((zzgn.zzk.zza)((Object)object6)).zzh(object2.zze());
        }
        object3 = zzai2;
        object6 = zza2;
        object5 = zzh2;
        object4 = this;
        ((zznv)object4).zzl().zzt();
        ((zznv)object4).zzs();
        object2 = null;
        for (Object object7 : ((zzgn.zzk.zza)((Object)object6)).zzab()) {
            if (!"_npa".equals(object7.zzg())) continue;
            object2 = object7;
            break;
        }
        if (object2 != null) {
            if (((zzai)object3).zza(zzjc.zza.zzd) == zzal.zza) {
                zzom zzom2 = ((zznv)object4).zzf().zze(((zzh)object5).zzac(), "_npa");
                if (zzom2 != null) {
                    if ("tcf".equals(zzom2.zzb)) {
                        ((zzai)object3).zza(zzjc.zza.zzd, zzal.zzh);
                    } else if ("app".equals(zzom2.zzb)) {
                        ((zzai)object3).zza(zzjc.zza.zzd, zzal.zzf);
                    } else {
                        ((zzai)object3).zza(zzjc.zza.zzd, zzal.zzd);
                    }
                } else {
                    object7 = ((zzh)object5).zzx();
                    if (object7 == null || object7 == Boolean.TRUE && ((zzgn.zzo)((Object)object2)).zzc() != 1L || object7 == Boolean.FALSE && ((zzgn.zzo)((Object)object2)).zzc() != 0L) {
                        ((zzai)object3).zza(zzjc.zza.zzd, zzal.zzf);
                    } else {
                        ((zzai)object3).zza(zzjc.zza.zzd, zzal.zzd);
                    }
                }
            }
        } else {
            int n = ((zznv)object4).zza(((zzh)object5).zzac(), (zzai)object3);
            ((zzgn.zzk.zza)((Object)object6)).zza((zzgn.zzo)((zzlc)zzgn.zzo.zze().zza("_npa").zzb(((zznv)object4).zzb().currentTimeMillis()).zza(n).zzai()));
            ((zznv)object4).zzj().zzp().zza("Setting user property", (Object)"non_personalized_ads(_npa)", (Object)n);
        }
        zza2.zzf(zzai2.toString());
        boolean bl = this.zzb.zzn(zzh2.zzac());
        object4 = zza2;
        object3 = ((zzgn.zzk.zza)((Object)object4)).zzaa();
        for (int i = 0; i < object3.size(); ++i) {
            if (!"_tcf".equals(((zzgn.zzf)((Object)object3.get(i))).zzg())) continue;
            zzgn.zzf.zza zza3 = (zzgn.zzf.zza)((zzgn.zzf)((Object)object3.get(i))).zzcd();
            object7 = zza3.zzf();
            for (int j = 0; j < object7.size(); ++j) {
                if (!"_tcfd".equals(((zzgn.zzh)((Object)object7.get(j))).zzg())) continue;
                String string = zzni.zza((String)((zzgn.zzh)((Object)object7.get(j))).zzh(), (boolean)bl);
                zza3.zza(j, zzgn.zzh.zze().zza("_tcfd").zzb(string));
                break;
            }
            ((zzgn.zzk.zza)((Object)object4)).zza(i, zza3);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzgn.zzf.zza zza2, int n, String string) {
        List<zzgn.zzh> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzg())) continue;
            return;
        }
        zzgn.zzh zzh2 = (zzgn.zzh)((zzlc)zzgn.zzh.zze().zza("_err").zza(n).zzai());
        zzgn.zzh zzh3 = (zzgn.zzh)((zzlc)zzgn.zzh.zze().zza("_ev").zzb(string).zzai());
        zza2.zza(zzh2).zza(zzh3);
    }

    @WorkerThread
    final void zza(zzbh zzbh2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzl().zzt();
        this.zzs();
        String string = zzp2.zza;
        long l = zzbh2.zzd;
        zzgm zzgm2 = zzgm.zza((zzbh)zzbh2);
        String string2 = string;
        zzja zzja2 = this;
        zzja2.zzl().zzt();
        zzop.zza(zzja2.zzaf == null || zzja2.zzag == null || !zzja2.zzag.equals(string2) ? null : zzja2.zzaf, (Bundle)zzgm2.zzd, (boolean)false);
        zzbh2 = zzgm2.zza();
        this.zzp();
        if (!zzol.zza(zzbh2, zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        if (zzp2.zzs != null) {
            if (zzp2.zzs.contains(zzbh2.zza)) {
                Bundle bundle = zzbh2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbh2 = new zzbh(zzbh2.zza, new zzbc(bundle), zzbh2.zzc, zzbh2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbh2.zza, (Object)zzbh2.zzc);
                return;
            }
        }
        this.zzf().zzp();
        try {
            zzaf zzaf2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            long l2 = l;
            string2 = string;
            zzja2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzja2.zzt();
            zzja2.zzal();
            if (l2 < 0L) {
                zzja2.zzj().zzu().zza("Invalid time querying timed out conditional properties", zzgi.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzja2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzp().zza("User property timed out", (Object)((zzaf)object22).zza, (Object)this.zzm.zzk().zzc(((zzaf)object22).zzc.zza), ((zzaf)object22).zzc.zza());
                if (((zzaf)object22).zzg != null) {
                    this.zzc(new zzbh(((zzaf)object22).zzg, l), zzp2);
                }
                this.zzf().zza(string, ((zzaf)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzja2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzja2.zzt();
            zzja2.zzal();
            if (l2 < 0L) {
                zzja2.zzj().zzu().zza("Invalid time querying expired conditional properties", zzgi.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzja2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzaf)object4.next();
                if (object == null) continue;
                this.zzj().zzp().zza("User property expired", (Object)((zzaf)object).zza, (Object)this.zzm.zzk().zzc(((zzaf)object).zzc.zza), ((zzaf)object).zzc.zza());
                this.zzf().zzh(string, ((zzaf)object).zzc.zza);
                if (((zzaf)object).zzk != null) {
                    object22.add(((zzaf)object).zzk);
                }
                this.zzf().zza(string, ((zzaf)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbh)e;
                this.zzc(new zzbh((zzbh)object, l), zzp2);
            }
            long l3 = l;
            String string4 = zzbh2.zza;
            string2 = string;
            zzja2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzja2.zzt();
            zzja2.zzal();
            if (l3 < 0L) {
                zzja2.zzj().zzu().zza("Invalid time querying triggered conditional properties", zzgi.zza((String)string2), (Object)zzja2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzja2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzaf2 = (zzaf)iterator.next();
                if (zzaf2 == null) continue;
                zzok zzok2 = zzaf2.zzc;
                zzom zzom2 = new zzom((String)Preconditions.checkNotNull((Object)zzaf2.zza), zzaf2.zzb, zzok2.zza, l, Preconditions.checkNotNull((Object)zzok2.zza()));
                if (this.zzf().zza(zzom2)) {
                    this.zzj().zzp().zza("User property triggered", (Object)zzaf2.zza, (Object)this.zzm.zzk().zzc(zzom2.zzc), zzom2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzgi.zza((String)zzaf2.zza), (Object)this.zzm.zzk().zzc(zzom2.zzc), zzom2.zze);
                }
                if (zzaf2.zzi != null) {
                    object.add(zzaf2.zzi);
                }
                zzaf2.zzc = new zzok(zzom2);
                zzaf2.zze = true;
                this.zzf().zza(zzaf2);
            }
            this.zzc(zzbh2, zzp2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzaf2 = (zzbh)e;
                this.zzc(new zzbh((zzbh)zzaf2, l), zzp2);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(zzbh zzbh2, String string) {
        zzh zzh2 = this.zzf().zze(string);
        if (zzh2 == null || TextUtils.isEmpty((CharSequence)zzh2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzh2);
        if (bl == null) {
            if (!"_ui".equals(zzbh2.zza)) {
                this.zzj().zzu().zza("Could not find package. appId", zzgi.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzgi.zza((String)string));
            return;
        }
        zzp zzp2 = new zzp(string, zzh2.zzah(), zzh2.zzaf(), zzh2.zze(), zzh2.zzae(), zzh2.zzq(), zzh2.zzn(), null, zzh2.zzar(), false, zzh2.zzag(), zzh2.zzd(), 0L, 0, zzh2.zzaq(), false, zzh2.zzaa(), zzh2.zzx(), zzh2.zzo(), zzh2.zzan(), null, this.zzb(string).zzh(), "", null, zzh2.zzat(), zzh2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzh2.zza(), zzh2.zzf(), zzh2.zzam(), zzh2.zzak());
        this.zzb(zzbh2, zzp2);
    }

    @WorkerThread
    private final void zzb(zzbh zzbh2, zzp zzp2) {
        String string;
        Preconditions.checkNotEmpty((String)zzp2.zza);
        zzgm zzgm2 = zzgm.zza((zzbh)zzbh2);
        this.zzq().zza(zzgm2.zzd, this.zzf().zzd(zzp2.zza));
        this.zzq().zza(zzgm2, this.zze().zzb(zzp2.zza));
        zzbh2 = zzgm2.zza();
        zzp zzp3 = zzp2;
        zzbh zzbh3 = zzbh2;
        zznv zznv2 = this;
        if ("_cmp".equals(zzbh3.zza) && "referrer API v2".equals(zzbh3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbh3.zzb.zzd("gclid")))) {
            zzok zzok2 = new zzok("_lgclid", zzbh3.zzd, (Object)string, "auto");
            zznv2.zza(zzok2, zzp3);
        }
        this.zza(zzbh2, zzp2);
    }

    @VisibleForTesting
    private final void zza(zzgn.zzk.zza zza2, long l, boolean bl) {
        zzom zzom2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzom2 = (zzom2 = this.zzf().zze(zza2.zzt(), string)) == null || zzom2.zze == null ? new zzom(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zzom(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zzom2.zze + l));
        zzgn.zzo zzo2 = (zzgn.zzo)((zzlc)zzgn.zzo.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza((Long)zzom2.zze).zzai());
        boolean bl2 = false;
        int n = zzol.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzo2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzo2);
        }
        if (l > 0L) {
            this.zzf().zza(zzom2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzp().zza("Updated engagement user property. scope, value", (Object)string2, zzom2.zze);
        }
    }

    final void zzt() {
        ++this.zzt;
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        this.zzb(string, n, throwable, byArray, map);
    }

    @WorkerThread
    private final void zzab() {
        this.zzl().zzt();
        for (String string : this.zzr) {
            if (!zzrl.zza() || !this.zze().zze(string, zzbj.zzcg)) continue;
            this.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)string);
            Intent intent = new Intent();
            intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            intent.setPackage(string);
            this.zzm.zza().sendBroadcast(intent);
        }
        this.zzr.clear();
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzp().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzp();
            try {
                boolean bl;
                zzh zzh2 = this.zzf().zze(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzh2 == null) {
                    this.zzj().zzu().zza("App does not exist in onConfigFetched. appId", zzgi.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = list != null && !list.isEmpty() ? list.get(0) : null;
                    List<String> list2 = map != null ? map.get("ETag") : null;
                    String string4 = string2 = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string3, string2)) {
                        return;
                    }
                    zzh2.zzd(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzh2, false, false);
                    if (n == 404) {
                        this.zzj().zzv().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzp().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzu() && this.zzad()) {
                        this.zzw();
                    } else if (this.zze().zza(zzbj.zzbz) && this.zzh().zzu() && this.zzf().zzs(zzh2.zzac())) {
                        this.zze(zzh2.zzac());
                    } else {
                        this.zzac();
                    }
                } else {
                    zzh2.zzm(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzh2, false, false);
                    this.zzj().zzp().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zze.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzac();
                }
                this.zzf().zzw();
            }
            finally {
                this.zzf().zzu();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzaa();
        }
    }

    final void zza(boolean bl) {
        this.zzac();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string, List<Pair<zzgn.zzj, zzns>> list) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list2 = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (zzpo.zza() && this.zze().zza(zzbj.zzcr) && !bl || (n == 200 || n == 204) && throwable == null) {
                try {
                    if (!zzpo.zza() || !this.zze().zza(zzbj.zzcr) || bl) {
                        this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zze.zza(0L);
                    this.zzac();
                    if (!zzpo.zza() || !this.zze().zza(zzbj.zzcr) || bl) {
                        this.zzj().zzp().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else if (zzpo.zza() && this.zze().zza(zzbj.zzcr)) {
                        this.zzj().zzp().zza("Purged empty bundles");
                    }
                    this.zzf().zzp();
                    try {
                        if (this.zze().zza(zzbj.zzbz)) {
                            for (Pair l : list) {
                                zzgn.zzj zzj2 = (zzgn.zzj)((Object)l.first);
                                zzns zzns2 = (zzns)l.second;
                                this.zzf().zza(string, zzj2, zzns2.zzb(), zzns2.zzc(), zzns2.zza());
                            }
                        }
                        for (Long l : list2) {
                            try {
                                long l2 = l;
                                zzam zzam2 = this.zzf();
                                zzam2.zzt();
                                zzam2.zzal();
                                SQLiteDatabase sQLiteDatabase = zzam2.e_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzam2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzw();
                    }
                    finally {
                        this.zzf().zzu();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzu() && this.zzad()) {
                        this.zzw();
                    } else if (this.zze().zza(zzbj.zzbz) && this.zzh().zzu() && this.zzf().zzs(string)) {
                        this.zze(string);
                    } else {
                        this.zzab = -1L;
                        this.zzac();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzp().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                this.zzj().zzp().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zze.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list2);
                this.zzac();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(@NonNull String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable zzog zzog2) {
        this.zzl().zzt();
        this.zzs();
        try {
            if ((n == 200 || n == 204) && throwable == null) {
                if (zzog2 != null) {
                    Long l = zzog2.zza();
                    zzam zzam2 = this.zzf();
                    zzam2.zzt();
                    zzam2.zzal();
                    Preconditions.checkNotNull((Object)l);
                    if (!zzrw.zza() || zzam2.zze().zza(zzbj.zzbz)) {
                        SQLiteDatabase sQLiteDatabase = zzam2.e_();
                        String[] stringArray = new String[]{String.valueOf(l)};
                        try {
                            if (sQLiteDatabase.delete("upload_queue", "rowid=?", stringArray) != 1) {
                                zzam2.zzj().zzu().zza("Deleted fewer rows from upload_queue than expected");
                            }
                        }
                        catch (SQLiteException sQLiteException) {
                            zzam2.zzj().zzg().zza("Failed to delete a MeasurementBatch in a upload_queue table", (Object)sQLiteException);
                            throw sQLiteException;
                        }
                    }
                }
                this.zzj().zzp().zza("Successfully uploaded batch from upload queue. appId, status", (Object)string, (Object)n);
                if (this.zze().zza(zzbj.zzbz) && this.zzh().zzu() && this.zzf().zzs(string)) {
                    this.zze(string);
                } else {
                    this.zzac();
                }
            } else {
                this.zzj().zzp().zza("Network upload failed. Will retry later. appId, status", (Object)string, (Object)n);
                if (zzog2 != null) {
                    this.zzf().zza((Long)zzog2.zza());
                }
                this.zzac();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    final void zzb(zzh zzh2, zzgn.zzk.zza zza2) {
        this.zzl().zzt();
        this.zzs();
        zzgn.zza.zza zza3 = zzgn.zza.zzc();
        byte[] byArray = zzh2.zzav();
        if (byArray != null) {
            try {
                zza3 = zzol.zza(zza3, byArray);
            }
            catch (zzlk zzlk2) {
                this.zzj().zzu().zza("Failed to parse locally stored ad campaign info. appId", zzgi.zza((String)zzh2.zzac()));
            }
        }
        for (zzgn.zzf zzf2 : zza2.zzaa()) {
            if (!zzf2.zzg().equals("_cmp")) continue;
            zzgn.zzf zzf3 = zzf2;
            zzgn.zza.zza zza4 = zza3;
            zznv zznv2 = this;
            String string = (String)zzol.zza(zzf3, "gclid", (Object)"");
            String string2 = (String)zzol.zza(zzf3, "gbraid", (Object)"");
            String string3 = (String)zzol.zza(zzf3, "gad_source", (Object)"");
            if (string.isEmpty() && string2.isEmpty()) continue;
            long l = (Long)zzol.zza(zzf3, "click_timestamp", (Object)0L);
            if (l <= 0L) {
                l = zzf3.zzd();
            }
            if ("referrer API v2".equals(zzol.zzb(zzf3, "_cis"))) {
                if (!(l > zza4.zzb())) continue;
                if (string.isEmpty()) {
                    zza4.zzh();
                } else {
                    zza4.zzf(string);
                }
                if (string2.isEmpty()) {
                    zza4.zzg();
                } else {
                    zza4.zze(string2);
                }
                if (string3.isEmpty()) {
                    zza4.zzf();
                } else {
                    zza4.zzd(string3);
                }
                zza4.zzb(l);
                continue;
            }
            if (!(l > zza4.zza())) continue;
            if (string.isEmpty()) {
                zza4.zze();
            } else {
                zza4.zzc(string);
            }
            if (string2.isEmpty()) {
                zza4.zzd();
            } else {
                zza4.zzb(string2);
            }
            if (string3.isEmpty()) {
                zza4.zzc();
            } else {
                zza4.zza(string3);
            }
            zza4.zza(l);
        }
        if (!((zzgn.zza)((zzlc)zza3.zzai())).equals((Object)zzgn.zza.zze())) {
            zza2.zza((zzgn.zza)((zzlc)zza3.zzai()));
        }
        zzh2.zza(((zzgn.zza)((zzlc)zza3.zzai())).zzca());
        if (zzh2.zzas()) {
            this.zzf().zza(zzh2, false, false);
        }
    }

    @WorkerThread
    final void zzc(zzp zzp2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        if (!this.zze().zza(zzbj.zzdg)) {
            return;
        }
        if (this.zze().zza(zzbj.zzbi)) {
            long l;
            long l2 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbj.zzau);
            this.zze();
            long l3 = l2 - com.google.android.gms.measurement.internal.zzah.zzh();
            for (int i = 0; i < n && this.zza(null, l = l3); ++i) {
            }
        } else {
            this.zze();
            long l = com.google.android.gms.measurement.internal.zzah.zzn();
            int n = 0;
            while ((long)n < l && this.zza(zzp2.zza, 0L)) {
                ++n;
            }
        }
        if (this.zze().zza(zzbj.zzbj)) {
            this.zzab();
        }
    }

    @WorkerThread
    final void zzd(zzp zzp2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        if (!zznv.zzi(zzp2)) {
            return;
        }
        zzh zzh2 = this.zzf().zze(zzp2.zza);
        if (zzh2 != null && TextUtils.isEmpty((CharSequence)zzh2.zzah()) && !TextUtils.isEmpty((CharSequence)zzp2.zzb)) {
            zzh2.zzd(0L);
            this.zzf().zza(zzh2, false, false);
            this.zzi().zzj(zzp2.zza);
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        long l = zzp2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzm();
        int n = zzp2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzu().zza("Incorrect app type, assuming installed app. appId, appType", zzgi.zza((String)zzp2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzp();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzam zzam2;
            String string2;
            zzok zzok2;
            zzom zzom2 = this.zzf().zze(zzp2.zza, "_npa");
            Boolean bl = this.zzh(zzp2);
            if (zzom2 == null || "auto".equals(zzom2.zzb)) {
                if (bl != null) {
                    zzok2 = new zzok("_npa", l, (Object)(bl != false ? 1L : 0L), "auto");
                    if (zzom2 == null || !zzom2.zze.equals(zzok2.zzc)) {
                        this.zza(zzok2, zzp2);
                    }
                } else if (zzom2 != null) {
                    this.zza("_npa", zzp2);
                }
            }
            long l2 = l;
            zzp zzp3 = zzp2;
            zznv zznv2 = this;
            Object object3 = zznv2.zzf().zze((String)Preconditions.checkNotNull((Object)zzp3.zza));
            if (object3 != null) {
                zznv2.zzq();
                if (zzop.zza((String)zzp3.zzb, (String)((zzh)object3).zzah(), (String)zzp3.zzp, (String)((zzh)object3).zzaa())) {
                    zznv2.zzj().zzu().zza("New GMP App Id passed in. Removing cached database data. appId", zzgi.zza((String)((zzh)object3).zzac()));
                    string2 = ((zzh)object3).zzac();
                    zzam2 = zznv2.zzf();
                    zzam2.zzal();
                    zzam2.zzt();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzam2.e_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzam2.zzj().zzp().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzam2.zzj().zzg().zza("Error deleting application data. appId, error", zzgi.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl2 = ((zzh)object3).zze() != Integer.MIN_VALUE && ((zzh)object3).zze() != zzp3.zzj;
                string = ((zzh)object3).zzaf();
                if (bl2 | (((zzh)object3).zze() == Integer.MIN_VALUE && string != null && !string.equals(zzp3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbh("_au", new zzbc(bundle), "auto", l2);
                    zznv2.zza((zzbh)object, zzp3);
                }
            }
            this.zza(zzp2);
            zzok2 = null;
            if (n == 0) {
                zzok2 = this.zzf().zzd(zzp2.zza, "_f");
            } else if (n == 1) {
                zzok2 = this.zzf().zzd(zzp2.zza, "_v");
            }
            if (zzok2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzok zzok3 = new zzok("_fot", l, (Object)l3, "auto");
                    this.zza(zzok3, zzp2);
                    zzp3 = zzp2;
                    zznv2 = this;
                    zznv2.zzl().zzt();
                    String string3 = zzp3.zza;
                    zzhd zzhd2 = (zzhd)Preconditions.checkNotNull((Object)zznv2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzhd2.zza.zzj().zzw().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzhd2.zza.zzl().zzt();
                        if (!zzhd2.zza()) {
                            zzhd2.zza.zzj().zzn().zza("Install Referrer Reporter is not available");
                        } else {
                            zzhc zzhc2 = new zzhc(zzhd2, string3);
                            object3 = zzhd2;
                            ((zzhd)object3).zza.zzl().zzt();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzhd)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzhd)object3).zza.zzj().zzw().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzam2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzam2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzam2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzam2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzhd)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl3 = ConnectionTracker.getInstance().bindService(((zzhd)object3).zza.zza(), intent, (ServiceConnection)zzhc2, 1);
                                                ((zzhd)object3).zza.zzj().zzp().zza("Install Referrer Service is", (Object)(bl3 ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzhd)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzhd)object3).zza.zzj().zzu().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzhd)object3).zza.zzj().zzn().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzp3 = zzp2;
                    zznv2 = this;
                    zznv2.zzl().zzt();
                    zznv2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzp3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzp3.zza);
                    object2 = string4;
                    zzam zzam3 = zznv2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzam3.zzt();
                    zzam3.zzal();
                    long l5 = zzam3.zzb((String)object2, "first_open_count");
                    if (zznv2.zzm.zza().getPackageManager() == null) {
                        zznv2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzgi.zza((String)string4));
                    } else {
                        zzam2 = null;
                        try {
                            zzam2 = Wrappers.packageManager((Context)zznv2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zznv2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzgi.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzam2 != null && ((PackageInfo)zzam2).firstInstallTime != 0L) {
                            boolean bl4 = false;
                            if (((PackageInfo)zzam2).firstInstallTime != ((PackageInfo)zzam2).lastUpdateTime) {
                                if (zznv2.zze().zza(zzbj.zzbr)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl4 = true;
                            }
                            sQLiteDatabase = new zzok("_fi", l4, (Object)(bl4 ? 1L : 0L), "auto");
                            zznv2.zza((zzok)sQLiteDatabase, zzp3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zznv2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zznv2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzgi.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzam2 = new zzbh("_f", new zzbc((Bundle)object3), "auto", l4);
                    zznv2.zzb((zzbh)zzam2, zzp3);
                } else if (n == 1) {
                    zzok zzok4 = new zzok("_fvt", l, (Object)l3, "auto");
                    this.zza(zzok4, zzp2);
                    l2 = l;
                    zzp3 = zzp2;
                    zznv2 = this;
                    zznv2.zzl().zzt();
                    zznv2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzp3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbh zzbh2 = new zzbh("_v", new zzbc((Bundle)object3), "auto", l2);
                    zznv2.zzb(zzbh2, zzp3);
                }
            } else if (zzp2.zzi) {
                l2 = l;
                zzp3 = zzp2;
                zznv2 = this;
                object3 = new Bundle();
                zzbh zzbh3 = new zzbh("_cd", new zzbc((Bundle)object3), "auto", l2);
                zznv2.zzb(zzbh3, zzp3);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    final void zzu() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzaf zzaf2) {
        zzp zzp2 = this.zzc((String)Preconditions.checkNotNull((Object)zzaf2.zza));
        if (zzp2 != null) {
            this.zza(zzaf2, zzp2);
        }
    }

    @WorkerThread
    final void zza(zzaf zzaf2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzaf2);
        Preconditions.checkNotEmpty((String)zzaf2.zza);
        Preconditions.checkNotNull((Object)zzaf2.zzc);
        Preconditions.checkNotEmpty((String)zzaf2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        this.zzf().zzp();
        try {
            this.zza(zzp2);
            String string = (String)Preconditions.checkNotNull((Object)zzaf2.zza);
            zzaf zzaf3 = this.zzf().zzc(string, zzaf2.zzc.zza);
            if (zzaf3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzaf2.zza, (Object)this.zzm.zzk().zzc(zzaf2.zzc.zza));
                this.zzf().zza(string, zzaf2.zzc.zza);
                if (zzaf3.zze) {
                    this.zzf().zzh(string, zzaf2.zzc.zza);
                }
                if (zzaf2.zzk != null) {
                    Bundle bundle = null;
                    if (zzaf2.zzk.zzb != null) {
                        bundle = zzaf2.zzk.zzb.zzb();
                    }
                    zzbh zzbh2 = this.zzq().zza(string, ((zzbh)Preconditions.checkNotNull((Object)zzaf2.zzk)).zza, bundle, zzaf3.zzb, zzaf2.zzk.zzd, true, true);
                    this.zzc((zzbh)Preconditions.checkNotNull((Object)zzbh2), zzp2);
                }
            } else {
                this.zzj().zzu().zza("Conditional user property doesn't exist", zzgi.zza((String)zzaf2.zza), (Object)this.zzm.zzk().zzc(zzaf2.zzc.zza));
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting
    private static void zza(zzgn.zzf.zza zza2, @NonNull String string) {
        List<zzgn.zzh> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzp zzp2) {
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        Boolean bl = this.zzh(zzp2);
        if ("_npa".equals(string) && bl != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zzok zzok2 = new zzok("_npa", this.zzb().currentTimeMillis(), (Object)(bl != false ? 1L : 0L), "auto");
            this.zza(zzok2, zzp2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzp();
        try {
            this.zza(zzp2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzp2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzp2.zza), string);
            this.zzf().zzw();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zze(zzp zzp2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzp2.zza);
        zzam zzam2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzam2.zzt();
        zzam2.zzal();
        try {
            SQLiteDatabase sQLiteDatabase = zzam2.e_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("events_snapshot", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray) + sQLiteDatabase.delete("upload_queue", "app_id=?", stringArray);
            if (n > 0) {
                zzam2.zzj().zzp().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzam2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzgi.zza((String)string), (Object)sQLiteException);
        }
        if (zzp2.zzh) {
            this.zzd(zzp2);
        }
    }

    @WorkerThread
    final void zzf(zzp zzp2) {
        boolean bl;
        zzjb zzjb2;
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzp2.zza);
        zzaz zzaz2 = zzaz.zza((String)zzp2.zzz);
        this.zzj().zzp().zza("Setting DMA consent for package", (Object)zzp2.zza, (Object)zzaz2);
        zzaz zzaz3 = zzaz2;
        String string = zzp2.zza;
        zznv zznv2 = this;
        zznv2.zzl().zzt();
        zznv2.zzs();
        zzjb zzjb3 = zzaz.zza((Bundle)zznv2.zza(string), (int)100).zzc();
        zznv2.zzad.put(string, zzaz3);
        zznv2.zzf().zza(string, zzaz3);
        zzjb zzjb4 = zzjb2 = zzaz.zza((Bundle)zznv2.zza(string), (int)100).zzc();
        zzjb zzjb5 = zzjb3;
        String string2 = string;
        zznv zznv3 = zznv2;
        zznv3.zzl().zzt();
        zznv3.zzs();
        boolean bl2 = zzjb5 == zzjb.zzc && zzjb4 == zzjb.zzd;
        boolean bl3 = bl = zzjb5 == zzjb.zzd && zzjb4 == zzjb.zzc;
        boolean bl4 = zznv3.zze().zza(zzbj.zzcp) ? bl2 || bl : bl2;
        if (bl4) {
            zznv3.zzj().zzp().zza("Generated _dcu event for", (Object)string2);
            Bundle bundle = new Bundle();
            if (zznv3.zzf().zza((long)zznv3.zzx(), (String)string2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzf < (long)zznv3.zze().zzb(string2, zzbj.zzay)) {
                bundle.putLong("_r", 1L);
                zzar zzar2 = zznv3.zzf().zza(zznv3.zzx(), string2, false, false, false, false, false, true);
                zznv3.zzj().zzp().zza("_dcu realtime event count", (Object)string2, (Object)zzar2.zzf);
            }
            zznv3.zzah.zza(string2, "_dcu", bundle);
        }
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzlh zzlh2) {
        this.zzl().zzt();
        if (this.zzag == null || this.zzag.equals(string) || zzlh2 != null) {
            this.zzag = string;
            this.zzaf = zzlh2;
        }
    }

    @WorkerThread
    final void zzg(zzp zzp2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzp2.zza);
        int n = zzp2.zzy;
        zzjc zzjc2 = zzjc.zza((String)zzp2.zzt, (int)n);
        zzjc zzjc3 = this.zzb(zzp2.zza);
        this.zzj().zzp().zza("Setting storage consent for package", (Object)zzp2.zza, (Object)zzjc2);
        this.zza(zzp2.zza, zzjc2);
        if (!(zzpd.zza() && this.zze().zza(zzbj.zzdc) || !zzjc2.zzc(zzjc3))) {
            this.zze(zzp2);
        }
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzv() {
        this.zzl().zzt();
        this.zzf().zzv();
        zzam zzam2 = this.zzf();
        zzam2.zzt();
        zzam2.zzal();
        if (zzam2.zzaa() && (Long)zzbj.zzbh.zza(null) != 0L) {
            String[] stringArray;
            SQLiteDatabase sQLiteDatabase = zzam2.e_();
            int n = sQLiteDatabase.delete("trigger_uris", "abs(timestamp_millis - ?) > cast(? as integer)", stringArray = new String[]{String.valueOf(zzam2.zzb().currentTimeMillis()), String.valueOf(zzbj.zzbh.zza(null))});
            if (n > 0) {
                zzam2.zzj().zzp().zza("Deleted stale trigger uris. rowsDeleted", (Object)n);
            }
        }
        if (this.zzj.zzd.zza() == 0L) {
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzac();
    }

    @WorkerThread
    final void zzb(zzaf zzaf2) {
        zzp zzp2 = this.zzc((String)Preconditions.checkNotNull((Object)zzaf2.zza));
        if (zzp2 != null) {
            this.zzb(zzaf2, zzp2);
        }
    }

    @WorkerThread
    final void zzb(zzaf zzaf2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzaf2);
        Preconditions.checkNotEmpty((String)zzaf2.zza);
        Preconditions.checkNotNull((Object)zzaf2.zzb);
        Preconditions.checkNotNull((Object)zzaf2.zzc);
        Preconditions.checkNotEmpty((String)zzaf2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        zzaf zzaf3 = new zzaf(zzaf2);
        new zzaf(zzaf2).zze = false;
        this.zzf().zzp();
        try {
            boolean bl = false;
            zzaf zzaf4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzaf3.zza), zzaf3.zzc.zza);
            if (zzaf4 != null && !zzaf4.zzb.equals(zzaf3.zzb)) {
                this.zzj().zzu().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzaf3.zzc.zza), (Object)zzaf3.zzb, (Object)zzaf4.zzb);
            }
            if (zzaf4 != null && zzaf4.zze) {
                zzaf3.zzb = zzaf4.zzb;
                zzaf3.zzd = zzaf4.zzd;
                zzaf3.zzh = zzaf4.zzh;
                zzaf3.zzf = zzaf4.zzf;
                zzaf3.zzi = zzaf4.zzi;
                zzaf3.zze = zzaf4.zze;
                zzaf3.zzc = new zzok(zzaf3.zzc.zza, zzaf4.zzc.zzb, zzaf3.zzc.zza(), zzaf4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzaf3.zzf)) {
                zzaf3.zzc = new zzok(zzaf3.zzc.zza, zzaf3.zzd, zzaf3.zzc.zza(), zzaf3.zzc.zze);
                zzaf3.zze = true;
                bl = true;
            }
            if (zzaf3.zze) {
                zzok zzok2 = zzaf3.zzc;
                zzom zzom2 = new zzom((String)Preconditions.checkNotNull((Object)zzaf3.zza), zzaf3.zzb, zzok2.zza, zzok2.zzb, Preconditions.checkNotNull((Object)zzok2.zza()));
                if (this.zzf().zza(zzom2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzaf3.zza, (Object)this.zzm.zzk().zzc(zzom2.zzc), zzom2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzgi.zza((String)zzaf3.zza), (Object)this.zzm.zzk().zzc(zzom2.zzc), zzom2.zze);
                }
                if (bl && zzaf3.zzi != null) {
                    zzbh zzbh2 = new zzbh(zzaf3.zzi, zzaf3.zzd);
                    this.zzc(zzbh2, zzp2);
                }
            }
            if (this.zzf().zza(zzaf3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzaf3.zza, (Object)this.zzm.zzk().zzc(zzaf3.zzc.zza), zzaf3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzgi.zza((String)zzaf3.zza), (Object)this.zzm.zzk().zzc(zzaf3.zzc.zza), zzaf3.zzc.zza());
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    private final void zzac() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzt();
            this.zzs();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzp().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzy().zzb();
                    this.zzz().zzu();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzaf() || !this.zzad()) {
                this.zzj().zzp().zza("Nothing to upload or uploading impossible");
                this.zzy().zzb();
                this.zzz().zzu();
                return;
            }
            zznv zznv2 = this;
            long l5 = zznv2.zzb().currentTimeMillis();
            zznv2.zze();
            long l6 = Math.max(0L, (Long)zzbj.zzab.zza(null));
            boolean bl = zznv2.zzf().zzz() || zznv2.zzf().zzy();
            if (bl) {
                String string = zznv2.zze().zzu();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zznv2.zze();
                    l4 = Math.max(0L, (Long)zzbj.zzw.zza(null));
                } else {
                    zznv2.zze();
                    l4 = Math.max(0L, (Long)zzbj.zzv.zza(null));
                }
            } else {
                zznv2.zze();
                l4 = Math.max(0L, (Long)zzbj.zzu.zza(null));
            }
            long l7 = zznv2.zzj.zzd.zza();
            long l8 = zznv2.zzj.zze.zza();
            long l9 = zznv2.zzf().c_();
            long l10 = zznv2.zzf().d_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zznv2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zznv2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbj.zzad.zza(null)))) break;
                        long l15 = 1L << n;
                        zznv2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbj.zzac.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzp().zza("Next upload time is 0");
            this.zzy().zzb();
            this.zzz().zzu();
            return;
        }
        if (!this.zzh().zzu()) {
            this.zzj().zzp().zza("No network");
            this.zzy().zza();
            this.zzz().zzu();
            return;
        }
        l2 = this.zzj.zzc.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbj.zzs.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzy().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbj.zzx.zza(null));
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzp().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzz().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, zzjc zzjc2) {
        this.zzl().zzt();
        this.zzs();
        this.zzac.put(string, zzjc2);
        this.zzf().zzb(string, zzjc2);
    }

    @WorkerThread
    private final void zza(String string, boolean bl, @Nullable Long l, @Nullable Long l2) {
        zzh zzh2 = this.zzf().zze(string);
        if (zzh2 != null) {
            zzh2.zzd(bl);
            zzh2.zza(l);
            zzh2.zzb(l2);
            if (zzh2.zzas()) {
                this.zzf().zza(zzh2, false, false);
            }
        }
    }

    @WorkerThread
    final void zza(zzok zzok2, zzp zzp2) {
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        int n = this.zzq().zzb(zzok2.zza);
        if (n != 0) {
            this.zzq();
            String string = zzok2.zza;
            this.zze();
            String string2 = zzop.zza((String)string, (int)24, (boolean)true);
            int n2 = zzok2.zza != null ? zzok2.zza.length() : 0;
            this.zzq();
            zzop.zza((zzoo)this.zzah, (String)zzp2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zzok2.zza, zzok2.zza());
        if (n != 0) {
            this.zzq();
            String string = zzok2.zza;
            this.zze();
            String string3 = zzop.zza((String)string, (int)24, (boolean)true);
            Object object = zzok2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zzop.zza((zzoo)this.zzah, (String)zzp2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zzok2.zza, zzok2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzok2.zza)) {
            zzbd zzbd2;
            zzp zzp3 = zzp2;
            String string = zzok2.zze;
            long l = zzok2.zzb;
            zznv zznv2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzp3.zza);
            long l2 = 0L;
            zzom zzom2 = zznv2.zzf().zze(string4, "_sno");
            if (zzom2 != null && zzom2.zze instanceof Long) {
                l2 = (Long)zzom2.zze;
            } else {
                if (zzom2 != null) {
                    zznv2.zzj().zzu().zza("Retrieved last session number from database does not contain a valid (long) value", zzom2.zze);
                }
                if ((zzbd2 = zznv2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzbd2.zzc;
                    zznv2.zzj().zzp().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzbd2 = new zzok("_sno", l, (Object)(++l2), string);
            zznv2.zza((zzok)zzbd2, zzp3);
        }
        zzom zzom3 = new zzom((String)Preconditions.checkNotNull((Object)zzp2.zza), (String)Preconditions.checkNotNull((Object)zzok2.zze), zzok2.zza, zzok2.zzb, object);
        this.zzj().zzp().zza("Setting user property", (Object)this.zzm.zzk().zzc(zzom3.zzc), object);
        this.zzf().zzp();
        try {
            zzom zzom4;
            if ("_id".equals(zzom3.zzc) && (zzom4 = this.zzf().zze(zzp2.zza, "_id")) != null && !zzom3.zze.equals(zzom4.zze)) {
                this.zzf().zzh(zzp2.zza, "_lair");
            }
            this.zza(zzp2);
            boolean bl = this.zzf().zza(zzom3);
            if ("_sid".equals(zzok2.zza)) {
                long l = this.zzp().zza(zzp2.zzv);
                zzh zzh2 = this.zzf().zze(zzp2.zza);
                if (zzh2 != null) {
                    zzh2.zzs(l);
                    if (zzh2.zzas()) {
                        this.zzf().zza(zzh2, false, false);
                    }
                }
            }
            this.zzf().zzw();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zzom3.zzc), zzom3.zze);
                this.zzq();
                zzop.zza((zzoo)this.zzah, (String)zzp2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzr().zzab();
            if (bl == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzac();
                return;
            }
            if (this.zzae()) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzac();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbj.zzau);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzah.zzh();
            for (int i = 0; i < n && this.zza(null, l2 = l4); ++i) {
            }
            if (zzrl.zza()) {
                this.zzab();
            }
            if ((l = this.zzj.zzd.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().f_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().b_();
                }
                int n2 = this.zze().zzb(string, zzbj.zzg);
                Object object = string;
                Object object2 = this.zze();
                int n3 = Math.max(0, object2.zzb((String)object, zzbj.zzh));
                List<Pair<zzgn.zzk, Long>> list = this.zzf().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object3;
                    Object object4;
                    zzmn zzmn2;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    Object object9;
                    Object object10;
                    Object object11;
                    if (this.zzb(string).zzi()) {
                        object11 = null;
                        Iterator<Pair<zzgn.zzk, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzgn.zzk zzk2 = (zzgn.zzk)((Object)iterator.next().first);
                            if (zzk2.zzan().isEmpty()) continue;
                            object11 = zzk2.zzan();
                            break;
                        }
                        if (object11 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object10 = (zzgn.zzk)((Object)list.get((int)i).first);
                                if (((zzgn.zzk)((Object)object10)).zzan().isEmpty() || ((zzgn.zzk)((Object)object10)).zzan().equals(object11)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object11 = zzgn.zzj.zzb();
                    int n4 = list.size();
                    object10 = new ArrayList(list.size());
                    boolean bl2 = this.zze().zzj(string) && this.zzb(string).zzi();
                    boolean bl3 = this.zzb(string).zzi();
                    boolean bl4 = this.zzb(string).zzj();
                    boolean bl5 = zzrq.zza() && this.zze().zze(string, zzbj.zzbv);
                    zzns zzns2 = this.zzk.zza(string);
                    for (int i = 0; i < n4; ++i) {
                        object9 = (zzgn.zzk.zza)((zzgn.zzk)((Object)list.get((int)i).first)).zzcd();
                        object10.add((Long)list.get((int)i).second);
                        this.zze();
                        ((zzgn.zzk.zza)((Object)object9)).zzl(102001L).zzk(l3).zzd(false);
                        if (!bl2) {
                            ((zzgn.zzk.zza)((Object)object9)).zzk();
                        }
                        if (!bl3) {
                            ((zzgn.zzk.zza)((Object)object9)).zzq();
                            ((zzgn.zzk.zza)((Object)object9)).zzn();
                        }
                        if (!bl4) {
                            ((zzgn.zzk.zza)((Object)object9)).zzh();
                        }
                        this.zza(string, (zzgn.zzk.zza)((Object)object9));
                        if (!bl5) {
                            ((zzgn.zzk.zza)((Object)object9)).zzr();
                        }
                        if (zzpd.zza() && this.zze().zza(zzbj.zzdd) && !bl4) {
                            ((zzgn.zzk.zza)((Object)object9)).zzi();
                        }
                        if (zzpo.zza() && this.zze().zza(zzbj.zzcr)) {
                            object = object9;
                            object2 = this;
                            object8 = ((zzgn.zzk.zza)((Object)object)).zzz();
                            boolean bl6 = false;
                            if (TextUtils.isEmpty(object8) || ((String)object8).equals("00000000-0000-0000-0000-000000000000")) {
                                object7 = new ArrayList<zzgn.zzf>(((zzgn.zzk.zza)((Object)object)).zzaa());
                                boolean bl7 = false;
                                object6 = object7.iterator();
                                object5 = null;
                                Long l5 = null;
                                while (object6.hasNext()) {
                                    zzmn2 = (zzgn.zzf)((Object)object6.next());
                                    if ("_fx".equals(zzmn2.zzg())) {
                                        bl6 = true;
                                        object6.remove();
                                        bl7 = true;
                                        continue;
                                    }
                                    if (!"_f".equals(zzmn2.zzg())) continue;
                                    bl6 = true;
                                    if (!((zznv)object2).zze().zza(zzbj.zzcz)) continue;
                                    ((zznv)object2).zzp();
                                    zzgn.zzh zzh2 = zzol.zza((zzgn.zzf)zzmn2, "_pfo");
                                    if (zzh2 != null) {
                                        object5 = zzh2.zzd();
                                    }
                                    ((zznv)object2).zzp();
                                    zzgn.zzh zzh3 = zzol.zza((zzgn.zzf)zzmn2, "_uwa");
                                    if (zzh3 == null) continue;
                                    l5 = zzh3.zzd();
                                }
                                if (bl7) {
                                    ((zzgn.zzk.zza)((Object)object)).zzl();
                                    ((zzgn.zzk.zza)((Object)object)).zzb((Iterable<? extends zzgn.zzf>)object7);
                                }
                                if (bl6) {
                                    super.zza(((zzgn.zzk.zza)((Object)object)).zzt(), true, (Long)object5, l5);
                                }
                            }
                            if (((zzgn.zzk.zza)((Object)object9)).zzc() == 0) continue;
                        }
                        if (this.zze().zze(string, zzbj.zzbl)) {
                            object4 = ((zzgn.zzk)((zzlc)object9.zzai())).zzca();
                            ((zzgn.zzk.zza)((Object)object9)).zza(this.zzp().zza((byte[])object4));
                        }
                        if (zzrw.zza() && this.zze().zza(zzbj.zzbw)) {
                            this.zzq();
                            if (zzop.zzf((String)string) && zzns2.zza() == zznt.zzc) {
                                ((zzgn.zzk.zza)((Object)object9)).zzk();
                            }
                        }
                        ((zzgn.zzj.zza)((Object)object11)).zza((zzgn.zzk.zza)((Object)object9));
                    }
                    if (zzpo.zza() && this.zze().zza(zzbj.zzcr) && ((zzgn.zzj.zza)((Object)object11)).zza() == 0) {
                        this.zza((List<Long>)object10);
                        this.zza(false, 204, null, null, string, Collections.emptyList());
                        return;
                    }
                    zzgn.zzj zzj2 = (zzgn.zzj)((zzlc)object11.zzai());
                    object9 = new ArrayList();
                    if (this.zze().zza(zzbj.zzbw)) {
                        this.zzq();
                        if (zzop.zzf((String)string) && zzns2.zza() == zznt.zzc) {
                            String object122;
                            boolean bl6;
                            block57: {
                                object8 = ((zzgn.zzj)((zzlc)object11.zzai())).zzf().iterator();
                                while (object8.hasNext()) {
                                    if (!object8.next().zzbh()) continue;
                                    bl6 = true;
                                    break block57;
                                }
                                bl6 = false;
                            }
                            Object object13 = object4 = bl6 ? UUID.randomUUID().toString() : null;
                            object8 = (zzgn.zzj)((zzlc)object11.zzai());
                            object = string;
                            object2 = this;
                            ((zznv)object2).zzl().zzt();
                            ((zznv)object2).zzs();
                            object7 = zzgn.zzj.zza(object8);
                            if (!TextUtils.isEmpty((CharSequence)object13)) {
                                ((zzgn.zzj.zza)((Object)object7)).zza((String)object13);
                            }
                            if (!TextUtils.isEmpty((CharSequence)(object122 = ((zznv)object2).zzi().zzf((String)object)))) {
                                ((zzgn.zzj.zza)((Object)object7)).zzb(object122);
                            }
                            object6 = new ArrayList();
                            object5 = ((zzgn.zzj)((Object)object8)).zzf().iterator();
                            while (object5.hasNext()) {
                                zzmn2 = zzgn.zzk.zza(object5.next());
                                zzmn2.zzk();
                                object6.add((zzgn.zzk)((zzlc)zzmn2.zzai()));
                            }
                            ((zzgn.zzj.zza)((Object)object7)).zzb();
                            ((zzgn.zzj.zza)((Object)object7)).zza((Iterable<? extends zzgn.zzk>)object6);
                            ((zznv)object2).zzj().zzp().zza("Processed MeasurementBatch for sGTM with sgtmJoinId", (Object)((zzgn.zzj.zza)((Object)object7)).zzc());
                            zzj2 = (zzgn.zzj)((zzlc)object7.zzai());
                            if (!TextUtils.isEmpty((CharSequence)object4) && this.zze().zza(zzbj.zzca)) {
                                zzns zzns3;
                                object8 = object4;
                                object = (zzgn.zzj)((zzlc)object11.zzai());
                                object2 = this;
                                ((zznv)object2).zzl().zzt();
                                ((zznv)object2).zzs();
                                object13 = zzgn.zzj.zzb();
                                ((zznv)object2).zzj().zzp().zza("Processing Google Signal, sgtmJoinId", (Object)((zzgn.zzj)((Object)object)).zzd());
                                ((zzgn.zzj.zza)((Object)object13)).zza((String)object8);
                                for (zzgn.zzk zzk2 : ((zzgn.zzj)((Object)object)).zzf()) {
                                    ((zzgn.zzj.zza)((Object)object13)).zza(zzgn.zzk.zzw().zzj(zzk2.zzah()).zzg(zzk2.zzd()));
                                }
                                object3 = (Object)((zzgn.zzj)((zzlc)object13.zzai()));
                                object = string;
                                object8 = ((zzno)this.zzk).zzm().zzf((String)object);
                                if (!TextUtils.isEmpty((CharSequence)object8)) {
                                    object13 = Uri.parse((String)((String)zzbj.zzr.zza(null)));
                                    object7 = object13.buildUpon();
                                    object6 = object13.getAuthority();
                                    Object object12 = object8;
                                    object7.authority((String)object12 + "." + (String)object6);
                                    zzns3 = new zzns(object7.build().toString(), zznt.zzb);
                                } else {
                                    zzns3 = new zzns((String)zzbj.zzr.zza(null), zznt.zzb);
                                }
                                object9.add(Pair.create((Object)object3, (Object)zzns3));
                            }
                        }
                    }
                    object4 = null;
                    if (this.zzj().zza(2)) {
                        object4 = this.zzp().zza(zzj2);
                    }
                    this.zzp();
                    object3 = zzj2.zzca();
                    try {
                        this.zza((List<Long>)object10);
                        this.zzj.zze.zza(l3);
                        String string2 = "?";
                        if (n4 > 0) {
                            string2 = ((zzgn.zzj.zza)((Object)object11)).zza(0).zzz();
                        }
                        this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", (Object)string2, (Object)((byte[])object3).length, object4);
                        this.zzv = true;
                        this.zzh().zza(string, new URL(zzns2.zzb()), (byte[])object3, zzns2.zzc(), new zznw(this, string, (List)object9));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj().zzg().zza("Failed to parse upload URL. Not uploading. appId", zzgi.zza((String)string), (Object)zzns2.zzb());
                    }
                }
            } else {
                zzh zzh4;
                this.zzab = -1L;
                zzam zzam2 = this.zzf();
                this.zze();
                String string3 = zzam2.zza(l3 - com.google.android.gms.measurement.internal.zzah.zzh());
                if (!TextUtils.isEmpty((CharSequence)string3) && (zzh4 = this.zzf().zze(string3)) != null) {
                    this.zzb(zzh4);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final void zze(String string) {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            Object object = this.zzm.zzr().zzab();
            if (object == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (((Boolean)object).booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzac();
                return;
            }
            if (this.zzae()) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzac();
                return;
            }
            if (!this.zzf().zzs(string)) {
                this.zzj().zzp().zza("Upload queue has no batches for appId", (Object)string);
                return;
            }
            object = this.zzf().zzj(string);
            if (object == null) {
                return;
            }
            zzgn.zzj zzj2 = ((zzog)object).zzb();
            if (zzj2 == null) {
                return;
            }
            String string2 = this.zzp().zza(zzj2);
            byte[] byArray = zzj2.zzca();
            this.zzj().zzp().zza("Uploading data from upload queue. appId, uncompressed size, data", (Object)string, (Object)byArray.length, (Object)string2);
            try {
                this.zzv = true;
                this.zzh().zza(string, new URL(((zzog)object).zzc()), byArray, ((zzog)object).zzd(), new zznz(this, string, (zzog)object));
            }
            catch (MalformedURLException malformedURLException) {
                this.zzj().zzg().zza("Failed to parse URL. Not uploading MeasurementBatch. appId", zzgi.zza((String)string), (Object)((zzog)object).zzc());
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzgn.zzh.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zzop.zzg((String)zza2.zzf()) || zzop.zzg((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zzop.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zzop.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzv().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbh var1_1, zzp var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzt();
        this.zzs();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zzol.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzu().zza("Dropping blocked event. appId", zzgi.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzm(var5_4) != false || this.zzi().zzo(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zzop.zza((zzoo)this.zzah, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zze(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzp(), var7_7.zzg());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbj.zzaa.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzgm.zza((zzbh)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = zzqz.zza() != false && this.zze().zza(zzbj.zzcf) != false ? this.zze().zza(var5_4, zzbj.zzas, 10, 35) : 0;
        for (String var10_12 : new TreeSet<E>(var6_6.zzd.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzd.getParcelableArray(var10_12), var7_8, zzqz.zza() != false && this.zze().zza(zzbj.zzcf) != false);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzp().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        if (zzqs.zza()) {
            this.zze().zza(zzbj.zzcb);
        }
        this.zzf().zzp();
        try {
            block77: {
                block78: {
                    block80: {
                        block84: {
                            block83: {
                                block81: {
                                    block82: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block80;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block81;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block82;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block83;
                                    }
                                    var25_19.zzj().zzu().zza("Data lost. Currency value is too big. appId", zzgi.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block84;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + (String)var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbj.zzag) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzt();
                                    var41_32.zzal();
                                    try {
                                        var41_32.e_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzgi.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zzom(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zzom(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zzom)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzgi.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zzop.zza((zzoo)var25_19.zzah, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var11_38 = zzop.zzh((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zzop.zza((zzbc)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzx(), var5_4, var13_40, true, var11_38, false, var12_39, false, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - com.google.android.gms.measurement.internal.zzah.zzn();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzgi.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzw();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbj.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzgi.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zzop.zza((zzoo)this.zzah, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzw();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbj.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzgi.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzd(var5_4, var2_2.zzac)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 /* !! */  = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44 /* !! */ .zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44 /* !! */ .zze);
                    }
                    if (this.zze().zza(zzbj.zzdn) && Objects.equals(var1_1.zzc, "am") && Objects.equals(var1_1.zza, "_ai") && (var19_44 /* !! */  = var18_43.get("value")) != null && var19_44 /* !! */  instanceof String) {
                        try {
                            var20_46 = Double.parseDouble((String)var19_44 /* !! */ );
                            var18_43.remove("value");
                            var18_43.putDouble("value", var20_46);
                        }
                        catch (NumberFormatException v4) {}
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzu().zza("Data lost. Too many events stored on disk, deleted. appId", zzgi.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_47 = new zzba(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_48 = this.zzf().zzd(var5_4, var21_47.zzb);
                    if (var22_48 == null) {
                        if (this.zzf().zzc(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzgi.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_47.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zzop.zza((zzoo)this.zzah, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_49 = new zzbd(var5_4, var21_47.zzb, 0L, 0L, var21_47.zzd, 0L, null, null, null, null);
                    } else {
                        var21_47 = var21_47.zza(this.zzm, var22_48.zzf);
                        var23_49 = var22_48.zza(var21_47.zzd);
                    }
                    this.zzf().zza(var23_49);
                    var27_17 = var2_2;
                    var26_18 = var21_47;
                    var25_19 = this;
                    var25_19.zzl().zzt();
                    var25_19.zzs();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzgn.zzk.zzw().zzh(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzv)) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzf(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzjc.zzb((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zzg());
                    if (var28_14.zzx().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (zzrl.zza() && var25_19.zze().zze(var27_17.zza, zzbj.zzcg)) {
                        var25_19.zzq();
                        if (zzop.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzi() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_50 = var30_25;
                                var40_52 /* !! */  = zzgn.zzc.zza();
                                var40_52 /* !! */ .zzc((var37_50 & 1L) != 0L);
                                var40_52 /* !! */ .zze((var37_50 & 2L) != 0L);
                                var40_52 /* !! */ .zzf((var37_50 & 4L) != 0L);
                                var40_52 /* !! */ .zzg((var37_50 & 8L) != 0L);
                                var40_52 /* !! */ .zzb((var37_50 & 16L) != 0L);
                                var40_52 /* !! */ .zza((var37_50 & 32L) != 0L);
                                var40_52 /* !! */ .zzd((var37_50 & 64L) != 0L);
                                var28_14.zza((zzgn.zzc)((zzlc)var40_52 /* !! */ .zzai()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzc(var27_17.zzf);
                    }
                    var28_14.zzd(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzu();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_53 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzjc.zzb((String)var27_17.zzt))).zzi() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_53)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc((Boolean)var32_23.second);
                        }
                        if (zzpo.zza() && var25_19.zze().zza(zzbj.zzcr) && !var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zze(var27_17.zza)) != null && var33_29.zzau()) {
                            var25_19.zza(var27_17.zza, false, null, null);
                            var34_35 = new Bundle();
                            if (var25_19.zze().zza(zzbj.zzcz)) {
                                var35_54 = var33_29.zzy();
                                if (var35_54 != null) {
                                    var34_35.putLong("_pfo", Math.max(0L, var35_54.longValue()));
                                }
                                if ((var36_27 = var33_29.zzz()) != null) {
                                    var34_35.putLong("_uwa", var36_27.longValue());
                                }
                            } else if (var25_19.zze().zza(zzbj.zzcy)) {
                                var35_55 = var25_19.zzf().zzb(var27_17.zza) - 1L;
                                var34_35.putLong("_pfo", Math.max(0L, var35_55));
                            }
                            var34_35.putLong("_r", 1L);
                            var25_19.zzah.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzac();
                    v5 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzac();
                    v5.zzo(Build.VERSION.RELEASE).zzj((int)var25_19.zzm.zzg().zzg()).zzs(var25_19.zzm.zzg().zzh());
                    var28_14.zzj(var27_17.zzx);
                    if (var25_19.zzm.zzac()) {
                        var28_14.zzt();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zze(var27_17.zza)) == null) {
                        var32_24 = new zzh(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_53));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_53.zzi()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzq(0L);
                        var32_24.zzr(0L);
                        var32_24.zzp(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zzb(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzn(var27_17.zze);
                        var32_24.zzk(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzl(var27_17.zzr);
                        var42_31 = var32_24;
                        var25_19.zzf().zza((zzh)var42_31, false, false);
                    }
                    if (var31_53.zzj() && !TextUtils.isEmpty((CharSequence)var32_24.zzad())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzad()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzag())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzag()));
                    }
                    var33_29 = var25_19.zzf().zzl(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_54 = zzgn.zzo.zze().zza(((zzom)var33_29.get((int)var34_36)).zzc).zzb(((zzom)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza((zzgn.zzo.zza)var35_54, ((zzom)var33_29.get((int)var34_36)).zze);
                        var28_14.zza((zzgn.zzo.zza)var35_54);
                        if (!"_sid".equals(((zzom)var33_29.get((int)var34_36)).zzc) || var32_24.zzv() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzv()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzgn.zzk)((zzlc)var28_14.zzai()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzgi.zza((String)var28_14.zzt()), (Object)var36_28);
                        break block77;
                    }
                    v6 = var25_19.zzf();
                    var38_56 = var26_18;
                    var37_51 = var25_19;
                    if (var38_56.zzf == null) ** GOTO lbl-1000
                    for (zzgn.zzc.zza var40_52 : var38_56.zzf) {
                        if (!"_r".equals((Object)var40_52 /* !! */ )) continue;
                        v7 = true;
                        break block78;
                    }
                    var39_58 = var37_51.zzi().zzc(var38_56.zza, var38_56.zzb);
                    var40_52 /* !! */  = var37_51.zzf().zza(var37_51.zzx(), var38_56.zza, false, false, false, false, false, false);
                    if (var39_58 && var40_52 /* !! */ .zze < (long)var37_51.zze().zzc(var38_56.zza)) {
                        v7 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = false;
                    }
                }
                if (v6.zza((zzba)var26_18, var34_37, v7)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzw();
        }
        finally {
            this.zzf().zzu();
        }
        this.zzac();
        this.zzj().zzp().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zzi(zzp zzp2) {
        return !TextUtils.isEmpty((CharSequence)zzp2.zzb) || !TextUtils.isEmpty((CharSequence)zzp2.zzp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @WorkerThread
    private final boolean zza(@Nullable String var1_1, long var2_2) {
        this.zzf().zzp();
        try {
            block167: {
                block171: {
                    block170: {
                        block165: {
                            var4_3 = new zza(null);
                            var34_4 = var4_3;
                            var32_6 = this.zzab;
                            var30_12 = var2_2;
                            var29_19 = var1_1;
                            var28_20 = this.zzf();
                            Preconditions.checkNotNull((Object)var34_4);
                            var28_20.zzt();
                            var28_20.zzal();
                            var35_21 = null;
                            try {
                                var36_27 /* !! */  = var28_20.e_();
                                if (TextUtils.isEmpty((CharSequence)var29_19)) {
                                    var38_33 = var32_6 != -1L ? new String[]{String.valueOf(var32_6), String.valueOf(var30_12)} : new String[]{String.valueOf(var30_12)};
                                    var47_35 = var32_6 != -1L ? "rowid <= ? and " : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select app_id, metadata_fingerprint from raw_events where " + var47_35 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block165;
                                    var29_19 = var35_21.getString(0);
                                    var37_36 = var35_21.getString(1);
                                    var35_21.close();
                                } else {
                                    var38_33 = var32_6 != -1L ? new String[]{var29_19, String.valueOf(var32_6)} : new String[]{var29_19};
                                    var47_35 = var32_6 != -1L ? " and rowid <= ?" : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + var47_35 + " order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block165;
                                    var37_36 = var35_21.getString(0);
                                    var35_21.close();
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{var29_19, var37_36}, null, null, "rowid", "2");
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzg().zza("Raw event metadata record is missing. appId", zzgi.zza((String)var29_19));
                                    break block165;
                                }
                                var38_33 = var35_21.getBlob(0);
                                try {
                                    var39_37 /* !! */  = (zzgn.zzk)((zzlc)zzol.zza(zzgn.zzk.zzw(), (byte[])var38_33).zzai());
                                }
                                catch (IOException var40_38) {
                                    var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzgi.zza((String)var29_19), (Object)var40_38);
                                    if (var35_21 != null) {
                                        var35_21.close();
                                    }
                                    break block165;
                                }
                                if (var35_21.moveToNext()) {
                                    var28_20.zzj().zzu().zza("Get multiple raw event metadata records, expected one. appId", zzgi.zza((String)var29_19));
                                }
                                var35_21.close();
                                var34_4.zza(var39_37 /* !! */ );
                                if (var32_6 != -1L) {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                                    var41_41 = new String[]{var29_19, var37_36, String.valueOf(var32_6)};
                                } else {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ?";
                                    var41_41 = new String[]{var29_19, var37_36};
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, var40_39, var41_41, null, null, "rowid", null);
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzu().zza("Raw event data disappeared while in transaction. appId", zzgi.zza((String)var29_19));
                                    break block165;
                                }
                                do {
                                    var42_42 = var35_21.getLong(0);
                                    var38_33 = var35_21.getBlob(3);
                                    try {
                                        var44_44 = zzol.zza(zzgn.zzf.zze(), (byte[])var38_33);
                                    }
                                    catch (IOException var45_46) {
                                        var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzgi.zza((String)var29_19), (Object)var45_46);
                                        continue;
                                    }
                                    var44_44.zza(var35_21.getString(1)).zzb(var35_21.getLong(2));
                                    if (!var34_4.zza(var42_42, (zzgn.zzf)((zzlc)var44_44.zzai()))) break;
                                } while (var35_21.moveToNext());
                            }
                            catch (SQLiteException var36_28) {
                                var28_20.zzj().zzg().zza("Data loss. Error selecting raw event. appId", zzgi.zza((String)var29_19), (Object)var36_28);
                            }
                            finally {
                                if (var35_21 != null) {
                                    var35_21.close();
                                }
                            }
                        }
                        var28_20 = var4_3;
                        if (var28_20.zzc == null || var28_20.zzc.isEmpty() != false) break block167;
                        var5_49 = false;
                        var6_50 = ((zzgn.zzk.zza)var4_3.zza.zzcd()).zzl();
                        var7_51 = 0;
                        var8_52 = 0L;
                        var10_53 = null;
                        var11_54 = -1;
                        var12_55 = null;
                        var13_56 = -1;
                        for (var14_57 = 0; var14_57 < var4_3.zzc.size(); ++var14_57) {
                            block169: {
                                block168: {
                                    var15_58 = var5_49;
                                    var16_61 = (zzgn.zzf.zza)var4_3.zzc.get(var14_57).zzcd();
                                    if (this.zzi().zzd(var4_3.zza.zzz(), var16_61.zze())) {
                                        this.zzj().zzu().zza("Dropping blocked raw event. appId", zzgi.zza((String)var4_3.zza.zzz()), (Object)this.zzm.zzk().zza(var16_61.zze()));
                                        if (this.zzi().zzm(var4_3.zza.zzz()) != false || this.zzi().zzo(var4_3.zza.zzz()) != false || "_err".equals(var16_61.zze())) continue;
                                        this.zzq();
                                        zzop.zza((zzoo)this.zzah, (String)var4_3.zza.zzz(), (int)11, (String)"_ev", (String)var16_61.zze(), (int)0);
                                        continue;
                                    }
                                    if (var16_61.zze().equals(zzjf.zza((String)"_ai"))) {
                                        var16_61.zza("_ai");
                                        this.zzj().zzp().zza("Renaming ad_impression to _ai");
                                        if (this.zzj().zza(5)) {
                                            for (var17_64 = 0; var17_64 < var16_61.zza(); ++var17_64) {
                                                if (!"ad_platform".equals(var16_61.zzb(var17_64).zzg()) || var16_61.zzb(var17_64).zzh().isEmpty() || !"admob".equalsIgnoreCase(var16_61.zzb(var17_64).zzh())) continue;
                                                this.zzj().zzv().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                            }
                                        }
                                    }
                                    if ((var17_64 = this.zzi().zzc(var4_3.zza.zzz(), var16_61.zze())) != 0) break block168;
                                    this.zzp();
                                    var28_20 = var16_61.zze();
                                    Preconditions.checkNotEmpty((String)var28_20);
                                    var30_13 = var28_20;
                                    var31_94 = -1;
                                    switch (var30_13.hashCode()) {
                                        case 95027: {
                                            if (!var30_13.equals("_ui")) break;
                                            var31_94 = 0;
                                        }
                                    }
                                    switch (var31_94) {
                                        case 0: {
                                            v0 = true;
                                            break;
                                        }
                                        default: {
                                            v0 = false;
                                        }
                                    }
                                    if (!v0) break block169;
                                }
                                var18_70 = false;
                                var19_76 = 0;
                                for (var20_80 = 0; var20_80 < var16_61.zza(); ++var20_80) {
                                    if ("_c".equals(var16_61.zzb(var20_80).zzg())) {
                                        var21_83 = (zzgn.zzh)((zzlc)((zzgn.zzh.zza)var16_61.zzb(var20_80).zzcd()).zza(1L).zzai());
                                        var18_70 = true;
                                        var16_61.zza(var20_80, var21_83);
                                        continue;
                                    }
                                    if (!"_r".equals(var16_61.zzb(var20_80).zzg())) continue;
                                    var21_83 = (zzgn.zzh)((zzlc)((zzgn.zzh.zza)var16_61.zzb(var20_80).zzcd()).zza(1L).zzai());
                                    var19_76 = 1;
                                    var16_61.zza(var20_80, var21_83);
                                }
                                if (!var18_70 && var17_64 != 0) {
                                    this.zzj().zzp().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzgn.zzh.zze().zza("_c").zza(1L));
                                }
                                if (var19_76 == 0) {
                                    this.zzj().zzp().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzgn.zzh.zze().zza("_r").zza(1L));
                                }
                                var5_49 = true;
                                if (this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzz(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false).zze > (long)this.zze().zzc(var4_3.zza.zzz())) {
                                    zznv.zza((zzgn.zzf.zza)var16_61, "_r");
                                    var5_49 = var15_58;
                                }
                                if (zzop.zzh((String)var16_61.zze()) && var17_64 != 0 && this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzz(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(var4_3.zza.zzz(), zzbj.zzn)) {
                                    this.zzj().zzu().zza("Too many conversions. Not logging as conversion. appId", zzgi.zza((String)var4_3.zza.zzz()));
                                    var22_86 = false;
                                    var23_89 /* !! */  = null;
                                    var24_90 = -1;
                                    for (var25_91 = 0; var25_91 < var16_61.zza(); ++var25_91) {
                                        var26_93 = var16_61.zzb(var25_91);
                                        if ("_c".equals(var26_93.zzg())) {
                                            var23_89 /* !! */  = (zzgn.zzh.zza)var26_93.zzcd();
                                            var24_90 = var25_91;
                                            continue;
                                        }
                                        if (!"_err".equals(var26_93.zzg())) continue;
                                        var22_86 = true;
                                    }
                                    if (var22_86 && var23_89 /* !! */  != null) {
                                        var16_61.zza(var24_90);
                                    } else if (var23_89 /* !! */  != null) {
                                        var25_92 = (zzgn.zzh)((zzlc)((zzgn.zzh.zza)((zzlc.zzb)var23_89 /* !! */ .clone())).zza("_err").zza(10L).zzai());
                                        var16_61.zza(var24_90, var25_92);
                                    } else {
                                        this.zzj().zzg().zza("Did not find conversion parameter. appId", zzgi.zza((String)var4_3.zza.zzz()));
                                    }
                                }
                            }
                            if (var17_64 != 0) {
                                var29_19 = var16_61;
                                var28_20 = this;
                                var30_13 = new ArrayList<zzgn.zzh>(var29_19.zzf());
                                var31_94 = -1;
                                var32_7 = -1;
                                for (var33_99 = 0; var33_99 < var30_13.size(); ++var33_99) {
                                    if ("value".equals(((zzgn.zzh)var30_13.get(var33_99)).zzg())) {
                                        var31_94 = var33_99;
                                        continue;
                                    }
                                    if (!"currency".equals(((zzgn.zzh)var30_13.get(var33_99)).zzg())) continue;
                                    var32_7 = var33_99;
                                }
                                if (var31_94 != -1) {
                                    if (!((zzgn.zzh)var30_13.get(var31_94)).zzl() && !((zzgn.zzh)var30_13.get(var31_94)).zzj()) {
                                        var28_20.zzj().zzv().zza("Value must be specified with a numeric type.");
                                        var29_19.zza(var31_94);
                                        zznv.zza((zzgn.zzf.zza)var29_19, "_c");
                                        zznv.zza((zzgn.zzf.zza)var29_19, 18, "value");
                                    } else {
                                        var33_99 = 0;
                                        if (var32_7 == -1) {
                                            var33_99 = 1;
                                        } else {
                                            var34_4 = ((zzgn.zzh)var30_13.get(var32_7)).zzh();
                                            if (var34_4.length() != 3) {
                                                var33_99 = 1;
                                            } else {
                                                for (var35_22 = 0; var35_22 < var34_4.length(); var35_22 += Character.charCount(var36_29)) {
                                                    var36_29 = var34_4.codePointAt(var35_22);
                                                    if (Character.isLetter(var36_29)) continue;
                                                    var33_99 = 1;
                                                    break;
                                                }
                                            }
                                        }
                                        if (var33_99 != 0) {
                                            var28_20.zzj().zzv().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                            var29_19.zza(var31_94);
                                            zznv.zza((zzgn.zzf.zza)var29_19, "_c");
                                            zznv.zza((zzgn.zzf.zza)var29_19, 19, "currency");
                                        }
                                    }
                                }
                            }
                            if ("_e".equals(var16_61.zze())) {
                                this.zzp();
                                if (zzol.zza((zzgn.zzf)((zzlc)var16_61.zzai()), "_fr") == null) {
                                    if (var12_55 != null && Math.abs(var12_55.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_71 = (zzgn.zzf.zza)((zzlc.zzb)var12_55.clone());
                                        if (this.zza((zzgn.zzf.zza)var16_61, var18_71)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var13_56, var18_71);
                                        } else {
                                            var10_53 = var16_61;
                                            var11_54 = var7_51;
                                        }
                                    } else {
                                        var10_53 = var16_61;
                                        var11_54 = var7_51;
                                    }
                                }
                            } else if ("_vs".equals(var16_61.zze())) {
                                this.zzp();
                                if (zzol.zza((zzgn.zzf)((zzlc)var16_61.zzai()), "_et") == null) {
                                    if (var10_53 != null && Math.abs(var10_53.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_72 = (zzgn.zzf.zza)((zzlc.zzb)var10_53.clone());
                                        if (this.zza(var18_72, (zzgn.zzf.zza)var16_61)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var11_54, var18_72);
                                        } else {
                                            var12_55 = var16_61;
                                            var13_56 = var7_51;
                                        }
                                    } else {
                                        var12_55 = var16_61;
                                        var13_56 = var7_51;
                                    }
                                }
                            }
                            if (zzqy.zza() && this.zze().zza(zzbj.zzcu) && var16_61.zza() != 0) {
                                this.zzp();
                                var18_73 = zzol.zza(var16_61.zzf());
                                for (var19_76 = 0; var19_76 < var16_61.zza(); ++var19_76) {
                                    var20_81 = var16_61.zzb(var19_76);
                                    if (var20_81.zzg().equals("items") && !var20_81.zzi().isEmpty()) {
                                        var32_8 = var18_73;
                                        var31_95 = var4_3.zza.zzz();
                                        var30_14 = var16_61;
                                        var29_19 = var20_81;
                                        var28_20 = this;
                                        var33_100 = var29_19.zzi();
                                        var34_4 = new Bundle[var33_100.size()];
                                        for (var35_23 = 0; var35_23 < var33_100.size(); ++var35_23) {
                                            var36_30 = var33_100.get(var35_23);
                                            var28_20.zzp();
                                            var37_36 = zzol.zza(var36_30.zzi());
                                            for (zzgn.zzk var39_37 : var36_30.zzi()) {
                                                super.zza(var30_14.zze(), (zzgn.zzh.zza)var39_37 /* !! */ .zzcd(), (Bundle)var37_36, var31_95);
                                            }
                                            var34_4[var35_23] = var37_36;
                                        }
                                        var32_8.putParcelableArray("items", (Parcelable[])var34_4);
                                        continue;
                                    }
                                    if (var20_81.zzg().equals("items")) continue;
                                    this.zza(var16_61.zze(), (zzgn.zzh.zza)var20_81.zzcd(), var18_73, var4_3.zza.zzz());
                                }
                                var30_14 = var16_61;
                                var29_19 = var18_73;
                                var28_20 = this;
                                var30_14.zzd();
                                var34_4 = var29_19;
                                var33_101 = var28_20.zzp();
                                var35_24 = new ArrayList<zzgn.zzh>();
                                for (String var37_36 : var34_4.keySet()) {
                                    var38_33 = zzgn.zzh.zze().zza(var37_36);
                                    var39_37 /* !! */  = var34_4.get(var37_36);
                                    if (var39_37 /* !! */  == null) continue;
                                    var33_101.zza((zzgn.zzh.zza)var38_33, (Object)var39_37 /* !! */ );
                                    var35_24.add((zzgn.zzh)((zzlc)var38_33.zzai()));
                                }
                                var51_103 = var35_24;
                                var52_104 = var51_103.size();
                                for (var53_105 = 0; var53_105 < var52_104; ++var53_105) {
                                    v1 = var51_103.get(var53_105);
                                    var32_9 = (zzgn.zzh)v1;
                                    var30_14.zza(var32_9);
                                }
                            }
                            var4_3.zzc.set(var14_57, (zzgn.zzf)((zzlc)var16_61.zzai()));
                            ++var7_51;
                            var6_50.zza((zzgn.zzf.zza)var16_61);
                        }
                        for (var14_57 = 0; var14_57 < var7_51; ++var14_57) {
                            var15_59 = var6_50.zza(var14_57);
                            if ("_e".equals(var15_59.zzg())) {
                                this.zzp();
                                if (zzol.zza(var15_59, "_fr") != null) {
                                    var6_50.zzb(var14_57);
                                    --var7_51;
                                    --var14_57;
                                    continue;
                                }
                            }
                            this.zzp();
                            var16_61 = zzol.zza(var15_59, "_et");
                            if (var16_61 == null || (var17_66 = var16_61.zzl() != false ? Long.valueOf(var16_61.zzd()) : null) == null || var17_66 <= 0L) continue;
                            var8_52 += var17_66.longValue();
                        }
                        this.zza(var6_50, var8_52, false);
                        var14_57 = 0;
                        for (zzmn var16_61 : var6_50.zzaa()) {
                            if (!"_s".equals(var16_61.zzg())) continue;
                            var14_57 = 1;
                            break;
                        }
                        if (var14_57 != 0) {
                            this.zzf().zzh(var6_50.zzt(), "_se");
                        }
                        if (zzol.zza(var6_50, "_sid") >= 0) {
                            this.zza(var6_50, var8_52, true);
                        } else {
                            var16_62 = zzol.zza(var6_50, "_se");
                            if (var16_62 >= 0) {
                                var6_50.zzc(var16_62);
                                this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzgi.zza((String)var4_3.zza.zzz()));
                            }
                        }
                        this.zzp().zza(var6_50);
                        var30_15 = var6_50;
                        var29_19 = var4_3.zza.zzz();
                        var28_20 = this;
                        var28_20.zzl().zzt();
                        var28_20.zzs();
                        var31_96 /* !! */  = var28_20.zzf().zze((String)var29_19);
                        if (var31_96 /* !! */  == null) {
                            var28_20.zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzgi.zza((String)var29_19));
                        } else {
                            var28_20.zza(var31_96 /* !! */ , var30_15);
                        }
                        if (zzqn.zza() && this.zze().zza(zzbj.zzct)) {
                            var30_15 = var6_50;
                            var29_19 = var4_3.zza.zzz();
                            var28_20 = this;
                            var28_20.zzl().zzt();
                            var28_20.zzs();
                            var31_96 /* !! */  = var28_20.zzf().zze((String)var29_19);
                            if (var31_96 /* !! */  == null) {
                                var28_20.zzj().zzu().zza("Cannot populate ad_campaign_info without appInfo. appId", zzgi.zza((String)var29_19));
                            } else {
                                var28_20.zzb(var31_96 /* !! */ , var30_15);
                            }
                        }
                        var28_20 = var6_50;
                        var28_20.zzi(0x7FFFFFFFFFFFFFFFL).zze(-9223372036854775808L);
                        for (var30_16 = 0; var30_16 < var28_20.zzc(); ++var30_16) {
                            var31_96 /* !! */  = var28_20.zza(var30_16);
                            if (var31_96 /* !! */ .zzd() < var28_20.zzf()) {
                                var28_20.zzi(var31_96 /* !! */ .zzd());
                            }
                            if (var31_96 /* !! */ .zzd() <= var28_20.zze()) continue;
                            var28_20.zze(var31_96 /* !! */ .zzd());
                        }
                        var6_50.zzs();
                        var16_63 = zzjc.zza;
                        if (zzpd.zza() && this.zze().zza(zzbj.zzdc)) {
                            var16_63 = this.zzb(var4_3.zza.zzz()).zza(zzjc.zzb((String)var4_3.zza.zzae()));
                            var17_67 = this.zzf().zzh(var4_3.zza.zzz());
                            this.zzf().zza(var4_3.zza.zzz(), var16_63);
                            if (!var16_63.zzj() && var17_67.zzj()) {
                                this.zzf().zzq(var4_3.zza.zzz());
                            } else if (var16_63.zzj() && !var17_67.zzj()) {
                                this.zzf().zzr(var4_3.zza.zzz());
                            }
                            var29_19 = var16_63;
                            var28_20 = var6_50;
                            if (!var29_19.zzi()) {
                                var28_20.zzq();
                                var28_20.zzn();
                                var28_20.zzk();
                            }
                            if (!var29_19.zzj()) {
                                var28_20.zzh();
                                var28_20.zzr();
                            }
                        }
                        if (zzrl.zza() && this.zze().zze(var4_3.zza.zzz(), zzbj.zzcg)) {
                            this.zzq();
                            if (zzop.zzd((String)var4_3.zza.zzz()) && this.zzb(var4_3.zza.zzz()).zzi() && var4_3.zza.zzat()) {
                                for (var17_68 = 0; var17_68 < var6_50.zzc(); ++var17_68) {
                                    var18_74 = (zzgn.zzf.zza)var6_50.zza(var17_68).zzcd();
                                    var19_76 = 0;
                                    for (zzgn.zzh var21_83 : var18_74.zzf()) {
                                        if (!"_c".equals(var21_83.zzg())) continue;
                                        var19_76 = 1;
                                        break;
                                    }
                                    if (var19_76 == 0) continue;
                                    if (var4_3.zza.zza() >= this.zze().zzb(var4_3.zza.zzz(), zzbj.zzax)) {
                                        var20_82 = null;
                                        if (this.zze().zze(var4_3.zza.zzz(), zzbj.zzci)) {
                                            var20_82 = this.zzq().zzp();
                                            var21_83 = (zzgn.zzh)((zzlc)zzgn.zzh.zze().zza("_tu").zzb((String)var20_82).zzai());
                                            var18_74.zza(var21_83);
                                        }
                                        var21_83 = (zzgn.zzh)((zzlc)zzgn.zzh.zze().zza("_tr").zza(1L).zzai());
                                        var18_74.zza(var21_83);
                                        var22_88 = this.zzp().zza(var4_3.zza.zzz(), var6_50, var18_74, (String)var20_82);
                                        if (var22_88 != null) {
                                            this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzz(), (Object)var22_88.zza);
                                            this.zzf().zza(var4_3.zza.zzz(), var22_88);
                                            this.zzr.add(var4_3.zza.zzz());
                                        }
                                    }
                                    var6_50.zza(var17_68, (zzgn.zzf)((zzlc)var18_74.zzai()));
                                }
                            }
                        }
                        if (zzpd.zza() && this.zze().zza(zzbj.zzdc)) {
                            var6_50.zzi().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze(), var16_63.zzj() == false));
                        } else {
                            var6_50.zzi().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze()));
                        }
                        if (this.zze().zzk(var4_3.zza.zzz())) {
                            var30_17 = var4_3;
                            var29_19 = var6_50;
                            var28_20 = this;
                            var31_96 /* !! */  = new HashMap<K, V>();
                            var32_10 = new ArrayList<zzgn.zzf>();
                            var33_102 = var28_20.zzq().zzv();
                            for (var34_5 = 0; var34_5 < var29_19.zzc(); ++var34_5) {
                                block166: {
                                    var35_25 = (zzgn.zzf.zza)var29_19.zza(var34_5).zzcd();
                                    if (var35_25.zze().equals("_ep")) {
                                        var28_20.zzp();
                                        var36_27 /* !! */  = (String)zzol.zzb((zzgn.zzf)((zzlc)var35_25.zzai()), "_en");
                                        var37_36 = (zzbd)var31_96 /* !! */ .get(var36_27 /* !! */ );
                                        if (var37_36 == null && (var37_36 = var28_20.zzf().zzd(var30_17.zza.zzz(), (String)Preconditions.checkNotNull((Object)var36_27 /* !! */ ))) != null) {
                                            var31_96 /* !! */ .put(var36_27 /* !! */ , var37_36);
                                        }
                                        if (var37_36 != null && var37_36.zzi == null) {
                                            if (var37_36.zzj != null && var37_36.zzj > 1L) {
                                                var28_20.zzp();
                                                zzol.zza(var35_25, "_sr", (Object)var37_36.zzj);
                                            }
                                            if (var37_36.zzk != null && var37_36.zzk.booleanValue()) {
                                                var28_20.zzp();
                                                zzol.zza(var35_25, "_efs", (Object)1L);
                                            }
                                            var32_10.add((zzgn.zzf)((zzlc)var35_25.zzai()));
                                        }
                                        var29_19.zza(var34_5, var35_25);
                                        continue;
                                    }
                                    var36_32 = var28_20.zzi().zza(var30_17.zza.zzz());
                                    var28_20.zzq();
                                    var38_34 = zzop.zza((long)var35_25.zzc(), (long)var36_32);
                                    var40_40 = 1;
                                    var48_107 = 1L;
                                    var47_35 = "_dbg";
                                    var46_48 = (zzgn.zzf)((zzlc)var35_25.zzai());
                                    if (TextUtils.isEmpty((CharSequence)var47_35) || var48_107 == null) {
                                        v2 = false;
                                    } else {
                                        for (zzgn.zzh var50_109 : var46_48.zzh()) {
                                            if (!var47_35.equals(var50_109.zzg())) continue;
                                            v2 = var48_107 instanceof Long != false && var48_107.equals(var50_109.zzd()) != false || var48_107 instanceof String != false && var48_107.equals(var50_109.zzh()) != false || var48_107 instanceof Double && var48_107.equals(var50_109.zza());
                                            break block166;
                                        }
                                        v2 = false;
                                    }
                                }
                                if (!v2) {
                                    var40_40 = var28_20.zzi().zzb(var30_17.zza.zzz(), var35_25.zze());
                                }
                                if (var40_40 <= 0) {
                                    var28_20.zzj().zzu().zza("Sample rate must be positive. event, rate", (Object)var35_25.zze(), (Object)var40_40);
                                    var32_10.add((zzgn.zzf)((zzlc)var35_25.zzai()));
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                var41_41 = (String[])var31_96 /* !! */ .get(var35_25.zze());
                                if (var41_41 == null && (var41_41 = var28_20.zzf().zzd(var30_17.zza.zzz(), var35_25.zze())) == null) {
                                    var28_20.zzj().zzu().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)var30_17.zza.zzz(), (Object)var35_25.zze());
                                    var41_41 = new zzbd(var30_17.zza.zzz(), var35_25.zze(), 1L, 1L, 1L, var35_25.zzc(), 0L, null, null, null, null);
                                }
                                var28_20.zzp();
                                var42_43 = (Long)zzol.zzb((zzgn.zzf)((zzlc)var35_25.zzai()), "_eid");
                                var43_106 = var42_43 != null;
                                if (var40_40 == 1) {
                                    var32_10.add((zzgn.zzf)((zzlc)var35_25.zzai()));
                                    if (var43_106.booleanValue() && (var41_41.zzi != null || var41_41.zzj != null || var41_41.zzk != null)) {
                                        var41_41 = var41_41.zza(null, null, null);
                                        var31_96 /* !! */ .put(var35_25.zze(), var41_41);
                                    }
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                if (var33_102.nextInt(var40_40) == 0) {
                                    var28_20.zzp();
                                    zzol.zza(var35_25, "_sr", (Object)var40_40);
                                    var32_10.add((zzgn.zzf)((zzlc)var35_25.zzai()));
                                    if (var43_106.booleanValue()) {
                                        var41_41 = var41_41.zza(null, Long.valueOf(var40_40), null);
                                    }
                                    var31_96 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                } else {
                                    if (var41_41.zzh != null) {
                                        var44_45 = var41_41.zzh;
                                    } else {
                                        var28_20.zzq();
                                        var44_45 = zzop.zza((long)var35_25.zzb(), (long)var36_32);
                                    }
                                    if (var44_45 != var38_34) {
                                        var28_20.zzp();
                                        zzol.zza(var35_25, "_efs", (Object)1L);
                                        var28_20.zzp();
                                        zzol.zza(var35_25, "_sr", (Object)var40_40);
                                        var32_10.add((zzgn.zzf)((zzlc)var35_25.zzai()));
                                        if (var43_106.booleanValue()) {
                                            var41_41 = var41_41.zza(null, Long.valueOf(var40_40), Boolean.valueOf(true));
                                        }
                                        var31_96 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                    } else if (var43_106.booleanValue()) {
                                        var31_96 /* !! */ .put(var35_25.zze(), var41_41.zza(var42_43, null, null));
                                    }
                                }
                                var29_19.zza(var34_5, var35_25);
                            }
                            if (var32_10.size() < var29_19.zzc()) {
                                var29_19.zzl().zzb(var32_10);
                            }
                            for (Map.Entry var35_26 : var31_96 /* !! */ .entrySet()) {
                                var28_20.zzf().zza((zzbd)var35_26.getValue());
                            }
                        }
                        var17_69 = var4_3.zza.zzz();
                        var18_75 = this.zzf().zze(var17_69);
                        if (var18_75 != null) break block170;
                        this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzgi.zza((String)var4_3.zza.zzz()));
                        break block171;
                    }
                    if (var6_50.zzc() <= 0) break block171;
                    var19_77 = var18_75.zzs();
                    if (var19_77 != 0L) {
                        var6_50.zzg(var19_77);
                    } else {
                        var6_50.zzo();
                    }
                    var21_84 = var18_75.zzu();
                    if (var21_84 == 0L) {
                        var21_84 = var19_77;
                    }
                    if (var21_84 != 0L) {
                        var6_50.zzh(var21_84);
                    } else {
                        var6_50.zzp();
                    }
                    if (!zzrw.zza() || !this.zze().zza(zzbj.zzbw)) ** GOTO lbl-1000
                    this.zzq();
                    if (zzop.zzf((String)var18_75.zzac())) {
                        var18_75.zza((long)var6_50.zzc());
                        var6_50.zzg((int)var18_75.zzr());
                    } else lbl-1000:
                    // 2 sources

                    {
                        var18_75.zzap();
                    }
                    var6_50.zzf((int)var18_75.zzt());
                    var18_75.zzr(var6_50.zzf());
                    var18_75.zzp(var6_50.zze());
                    var23_89 /* !! */  = var18_75.zzab();
                    if (var23_89 /* !! */  != null) {
                        var6_50.zzn((String)var23_89 /* !! */ );
                    } else {
                        var6_50.zzm();
                    }
                    this.zzf().zza(var18_75, false, false);
                }
                if (var6_50.zzc() > 0) {
                    var19_79 = this.zzi().zzc(var4_3.zza.zzz());
                    if (var19_79 == null || !var19_79.zzs()) {
                        if (var4_3.zza.zzaj().isEmpty()) {
                            var6_50.zzb(-1L);
                        } else {
                            this.zzj().zzu().zza("Did not find measurement config or missing version info. appId", zzgi.zza((String)var4_3.zza.zzz()));
                        }
                    } else {
                        var6_50.zzb(var19_79.zzc());
                    }
                    this.zzf().zza((zzgn.zzk)((zzlc)var6_50.zzai()), var5_49);
                }
                var29_19 = var4_3.zzb;
                var28_20 = this.zzf();
                Preconditions.checkNotNull((Object)var29_19);
                var28_20.zzt();
                var28_20.zzal();
                var30_18 = new StringBuilder("rowid in (");
                for (var31_97 = 0; var31_97 < var29_19.size(); ++var31_97) {
                    if (var31_97 != 0) {
                        var30_18.append(",");
                    }
                    var30_18.append((Long)var29_19.get(var31_97));
                }
                var30_18.append(")");
                var32_11 = var28_20.e_().delete("raw_events", var30_18.toString(), null);
                if (var32_11 != var29_19.size()) {
                    var28_20.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)var32_11, (Object)var29_19.size());
                }
                var29_19 = var17_69;
                var28_20 = this.zzf();
                var30_18 = var28_20.e_();
                try {
                    var30_18.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{var29_19, var29_19});
                }
                catch (SQLiteException var31_98) {
                    var28_20.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzgi.zza((String)var29_19), (Object)var31_98);
                }
                this.zzf().zzw();
                return true;
            }
            this.zzf().zzw();
            return false;
        }
        finally {
            this.zzf().zzu();
        }
    }

    private final boolean zzad() {
        this.zzl().zzt();
        this.zzs();
        return this.zzf().zzx() || !TextUtils.isEmpty((CharSequence)this.zzf().f_());
    }

    @WorkerThread
    @VisibleForTesting
    private final boolean zzae() {
        this.zzl().zzt();
        return this.zzz != null;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzaf() {
        this.zzl().zzt();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzp().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(zzcf.zza().zza(file, string));
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzp().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzu().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzgn.zzf.zza zza2, zzgn.zzf.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzgn.zzh zzh2 = zzol.zza((zzgn.zzf)((zzlc)zza2.zzai()), "_sc");
        String string = zzh2 == null ? null : zzh2.zzh();
        this.zzp();
        zzgn.zzh zzh3 = zzol.zza((zzgn.zzf)((zzlc)zza3.zzai()), "_pc");
        String string2 = zzh3 == null ? null : zzh3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzgn.zzf.zza zza4 = zza3;
            zzgn.zzf.zza zza5 = zza2;
            zznv zznv2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zznv2.zzp();
            zzgn.zzh zzh4 = zzol.zza((zzgn.zzf)((zzlc)zza5.zzai()), "_et");
            if (zzh4 != null && zzh4.zzl() && zzh4.zzd() > 0L) {
                long l = zzh4.zzd();
                zznv2.zzp();
                zzh4 = zzol.zza((zzgn.zzf)((zzlc)zza4.zzai()), "_et");
                if (zzh4 != null && zzh4.zzd() > 0L) {
                    l += zzh4.zzd();
                }
                zznv2.zzp();
                zzol.zza(zza4, "_et", (Object)l);
                zznv2.zzp();
                zzol.zza(zza5, "_fr", (Object)1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    private final class zzb {
        final String zza;
        long zzb;

        private zzb(zznv zznv2) {
            this(zznv2, zznv2.zzq().zzp());
        }

        /* synthetic */ zzb(zznv zznv2, zzof zzof2) {
            this(zznv2);
        }

        private zzb(zznv zznv2, String string) {
            this.zza = string;
            this.zzb = zznv2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzb(zznv zznv2, String string, zzof zzof2) {
            this(zznv2, string);
        }
    }

    private final class zza
    implements zzat {
        zzgn.zzk zza;
        List<Long> zzb;
        List<zzgn.zzf> zzc;
        private long zzd;

        private static long zza(zzgn.zzf zzf2) {
            return zzf2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zzoe zzoe2) {
            this();
        }

        @Override
        public final void zza(zzgn.zzk zzk2) {
            Preconditions.checkNotNull((Object)((Object)zzk2));
            this.zza = zzk2;
        }

        @Override
        public final boolean zza(long l, zzgn.zzf zzf2) {
            Preconditions.checkNotNull((Object)((Object)zzf2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzgn.zzf>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zznv$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zznv$zza.zza(zzf2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzf2.zzcb();
            zznv.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbj.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzf2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zznv.this.zze();
            return n < Math.max(1, (Integer)zzbj.zzj.zza(null));
        }
    }
}

